/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.audit.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.context.ConsentContext;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;

public class CurrentConsentValuesAuditExtractor
implements Function<ProfileRequestContext, Collection<String>> {
    @Nonnull
    private Function<ProfileRequestContext, ConsentContext> consentContextLookupStrategy;

    public CurrentConsentValuesAuditExtractor() {
        this.consentContextLookupStrategy = new ChildContextLookup(ConsentContext.class);
    }

    public CurrentConsentValuesAuditExtractor(@Nonnull Function<ProfileRequestContext, ConsentContext> strategy) {
        this.consentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Consent context lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public Collection<String> apply(@Nullable ProfileRequestContext input) {
        ConsentContext consentContext = this.consentContextLookupStrategy.apply(input);
        if (consentContext != null && !consentContext.getCurrentConsents().isEmpty()) {
            return consentContext.getCurrentConsents().values().stream().map(Consent::getValue).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

