/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.logic.impl;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinFunction
implements Function<ProfileRequestContext, String> {
    @Nonnull
    public static final String SEPARATOR = ":";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JoinFunction.class);
    private Function<ProfileRequestContext, String> a;
    private Function<ProfileRequestContext, String> b;
    @Nonnull
    private final Joiner joiner;

    public JoinFunction(@Nonnull Function<ProfileRequestContext, String> functionA, @Nonnull Function<ProfileRequestContext, String> functionB) {
        Constraint.isNotNull(functionA, (String)"Function A cannot be null");
        Constraint.isNotNull(functionB, (String)"Function B cannot be null");
        this.a = functionA;
        this.b = functionB;
        this.joiner = Joiner.on((String)SEPARATOR).skipNulls();
    }

    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        if (input == null) {
            return null;
        }
        String resultA = (String)this.a.apply((Object)input);
        String resultB = (String)this.b.apply((Object)input);
        String result = this.joiner.join((Object)resultA, (Object)resultB, new Object[0]);
        this.log.debug("Result '{}'", (Object)result);
        return result;
    }
}

