/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.storage.impl;

import java.io.IOException;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.shibboleth.idp.consent.Consent;
import net.shibboleth.idp.consent.flow.storage.impl.AbstractConsentIndexedStorageAction;
import net.shibboleth.idp.consent.storage.impl.ConsentResult;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorResult;
import org.joda.time.DateTime;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateGlobalConsentResult
extends AbstractConsentIndexedStorageAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CreateGlobalConsentResult.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        try {
            Consent globalConsent = new Consent();
            globalConsent.setId("*");
            globalConsent.setApproved(true);
            String value = this.getStorageSerializer().serialize(Collections.singletonMap(globalConsent.getId(), globalConsent));
            long expiration = DateTime.now().plus(this.getConsentFlowDescriptor().getLifetime().longValue()).getMillis();
            ConsentResult result = new ConsentResult(this.getStorageContext(), this.getStorageKey(), value, expiration);
            this.log.debug("{} Created global consent result '{}'", (Object)this.getLogPrefix(), (Object)result);
            this.storeResultWithIndex(profileRequestContext, (ProfileInterceptorResult)result);
        }
        catch (IOException e) {
            this.log.debug("{} Unable to serialize consent", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
        }
    }
}

