/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.consent.flow.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.interceptor.ProfileInterceptorFlowDescriptor;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.DOMTypeSupport;

public class ConsentFlowDescriptor
extends ProfileInterceptorFlowDescriptor {
    private boolean compareValues;
    @Nonnull
    @Duration
    @NonNegative
    private Long lifetime = DOMTypeSupport.durationToLong((String)"P1Y");
    private int maxStoredRecords;
    private int expandedMaxStoredRecords;
    private long expandedStorageThreshold = 0x100000L;

    public boolean compareValues() {
        return this.compareValues;
    }

    @Nonnull
    @Duration
    @NonNegative
    public Long getLifetime() {
        return this.lifetime;
    }

    public int getMaximumNumberOfStoredRecords() {
        return this.maxStoredRecords;
    }

    public int getExpandedNumberOfStoredRecords() {
        return this.expandedMaxStoredRecords;
    }

    public long getExpandedStorageThreshold() {
        return this.expandedStorageThreshold;
    }

    public void setCompareValues(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.compareValues = flag;
    }

    @Duration
    public void setLifetime(@Nonnull @Duration @NonNegative Long consentLifetime) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)consentLifetime, (String)"Lifetime cannot be null");
        this.lifetime = Constraint.isGreaterThanOrEqual((long)0L, (long)consentLifetime, (String)"Lifetime must be greater than or equal to 0");
    }

    public void setMaximumNumberOfStoredRecords(int maximum) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.maxStoredRecords = maximum;
    }

    public void setExpandedNumberOfStoredRecords(int maximum) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.expandedMaxStoredRecords = maximum;
    }

    public void setExpandedStorageThreshold(long size) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.expandedStorageThreshold = size;
    }
}

