/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.spnego.impl;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.authn.spnego.impl.GSSContextAcceptor;
import net.shibboleth.idp.authn.spnego.impl.SPNEGOContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.codec.HTMLEncoder;
import org.apache.commons.codec.binary.Base64;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"%{idp.authn.spnego.externalAuthnPath:/Authn/SPNEGO}"})
public class SPNEGOAuthnController {
    @Nonnull
    @NotEmpty
    public static final String SPNEGO_NOT_AVAILABLE = "SPNEGONotAvailable";
    @Nonnull
    @NotEmpty
    public static final String NTLM_UNSUPPORTED = "NTLMUnsupported";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SPNEGOAuthnController.class);

    @RequestMapping(value={"/{conversationKey}"}, method={RequestMethod.GET})
    @Nullable
    public ModelAndView startSPNEGO(@PathVariable @Nonnull @NotEmpty String conversationKey, @Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse) throws ExternalAuthenticationException, IOException {
        String key = ExternalAuthentication.startExternalAuthentication((HttpServletRequest)httpRequest);
        if (!key.equals(conversationKey)) {
            throw new ExternalAuthenticationException("Conversation key on query string doesn't match URL path");
        }
        ProfileRequestContext prc = ExternalAuthentication.getProfileRequestContext((String)key, (HttpServletRequest)httpRequest);
        SPNEGOContext spnegoCtx = this.getSPNEGOContext(prc);
        if (spnegoCtx == null || spnegoCtx.getKerberosSettings() == null) {
            this.log.error("Kerberos settings not found in profile request context");
            this.finishWithError(conversationKey, httpRequest, httpResponse, "InvalidAuthenticationContext");
            return null;
        }
        this.log.trace("SPNEGO negotiation started, answering request with 401 (WWW-Authenticate: Negotiate)");
        return this.replyUnauthorizedNegotiate(prc, httpRequest, httpResponse);
    }

    @RequestMapping(value={"/{conversationKey}"}, method={RequestMethod.GET}, headers={"Authorization"})
    @Nullable
    public ModelAndView continueSPNEGO(@PathVariable @Nonnull @NotEmpty String conversationKey, @RequestHeader(value="Authorization") @Nonnull @NotEmpty String authorizationHeader, @Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse) throws ExternalAuthenticationException, IOException {
        byte[] tokenBytes;
        ProfileRequestContext prc = ExternalAuthentication.getProfileRequestContext((String)conversationKey, (HttpServletRequest)httpRequest);
        if (!authorizationHeader.startsWith("Negotiate ")) {
            return this.replyUnauthorizedNegotiate(prc, httpRequest, httpResponse);
        }
        SPNEGOContext spnegoCtx = this.getSPNEGOContext(prc);
        if (spnegoCtx == null || spnegoCtx.getKerberosSettings() == null) {
            this.log.error("Kerberos settings not found in profile request context");
            this.finishWithError(conversationKey, httpRequest, httpResponse, "InvalidAuthenticationContext");
            return null;
        }
        GSSContextAcceptor acceptor = spnegoCtx.getContextAcceptor();
        if (acceptor == null) {
            try {
                acceptor = this.createGSSContextAcceptor(spnegoCtx);
                spnegoCtx.setContextAcceptor(acceptor);
            }
            catch (GSSException e) {
                this.log.error("Unable to create GSSContextAcceptor", (Throwable)e);
                this.finishWithException(conversationKey, httpRequest, httpResponse, (Exception)((Object)new ExternalAuthenticationException(SPNEGO_NOT_AVAILABLE, (Exception)e)));
                return null;
            }
        }
        byte[] gssapiData = Base64.decodeBase64((byte[])authorizationHeader.substring(10).getBytes());
        this.log.trace("SPNEGO negotiation, Authorization header received, gssapi-data: {}", (Object)gssapiData);
        if (this.isNTLMMechanism(gssapiData)) {
            this.log.warn("NTLM is unsupported, failing context negotiation");
            acceptor.logout();
            this.finishWithError(conversationKey, httpRequest, httpResponse, NTLM_UNSUPPORTED);
            return null;
        }
        try {
            tokenBytes = acceptor.acceptSecContext(gssapiData, 0, gssapiData.length);
            this.log.trace("GSS token accepted");
        }
        catch (Exception e) {
            this.log.debug("Exception processing GSS token", (Throwable)e);
            acceptor.logout();
            this.finishWithException(conversationKey, httpRequest, httpResponse, (Exception)((Object)new ExternalAuthenticationException(SPNEGO_NOT_AVAILABLE, e)));
            return null;
        }
        if (acceptor.getContext() != null && acceptor.getContext().isEstablished()) {
            this.log.debug("GSS security context is complete");
            try {
                GSSName clientGSSName = acceptor.getContext().getSrcName();
                if (clientGSSName == null) {
                    this.log.error("Error extracting principal name from security context, check for hostname mismatch or other causes of a missing service ticket");
                    acceptor.logout();
                    this.finishWithException(conversationKey, httpRequest, httpResponse, (Exception)((Object)new ExternalAuthenticationException(SPNEGO_NOT_AVAILABLE)));
                    return null;
                }
                KerberosPrincipal kerberosPrincipal = new KerberosPrincipal(clientGSSName.toString());
                this.log.info("SPNEGO/Kerberos authentication succeeded for principal: {}", (Object)clientGSSName.toString());
                acceptor.logout();
                this.finishWithSuccess(conversationKey, httpRequest, httpResponse, kerberosPrincipal);
            }
            catch (GSSException e) {
                this.log.error("Error extracting principal name from security context", (Throwable)e);
                acceptor.logout();
                this.finishWithException(conversationKey, httpRequest, httpResponse, (Exception)((Object)new ExternalAuthenticationException(SPNEGO_NOT_AVAILABLE, (Exception)e)));
            }
        } else {
            this.log.trace("SPNEGO negotiation in process, output token: {}", (Object)tokenBytes);
            return this.replyUnauthorizedNegotiate(prc, httpRequest, httpResponse, Base64.encodeBase64String((byte[])tokenBytes));
        }
        return null;
    }

    @RequestMapping(value={"/{conversationKey}/error"}, method={RequestMethod.GET})
    public void handleError(@PathVariable String conversationKey, @Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse) throws ExternalAuthenticationException, IOException {
        this.log.warn("SPNEGO authentication problem signaled by client");
        this.finishWithError(conversationKey, httpRequest, httpResponse, SPNEGO_NOT_AVAILABLE);
    }

    private void finishWithSuccess(@Nonnull @NotEmpty String key, @Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse, @Nonnull KerberosPrincipal kerberosPrincipal) throws ExternalAuthenticationException, IOException {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new UsernamePrincipal(kerberosPrincipal.getName()));
        subject.getPrincipals().add(kerberosPrincipal);
        httpRequest.setAttribute("subject", (Object)subject);
        ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
    }

    private void finishWithError(@Nonnull @NotEmpty String key, @Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse, @Nonnull @NotEmpty String error) throws ExternalAuthenticationException, IOException {
        httpRequest.setAttribute("authnError", (Object)error);
        ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
    }

    private void finishWithException(@Nonnull @NotEmpty String key, @Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse, @Nonnull Exception ex) throws ExternalAuthenticationException, IOException {
        httpRequest.setAttribute("authnException", (Object)ex);
        ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
    }

    @Nullable
    private SPNEGOContext getSPNEGOContext(@Nonnull ProfileRequestContext prc) {
        AuthenticationContext authnContext = (AuthenticationContext)prc.getSubcontext(AuthenticationContext.class);
        return authnContext != null ? (SPNEGOContext)authnContext.getSubcontext(SPNEGOContext.class) : null;
    }

    @Nonnull
    protected GSSContextAcceptor createGSSContextAcceptor(@Nonnull SPNEGOContext spnegoCtx) throws GSSException {
        return new GSSContextAcceptor(spnegoCtx.getKerberosSettings());
    }

    @Nonnull
    private ModelAndView replyUnauthorizedNegotiate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse) {
        return this.replyUnauthorizedNegotiate(profileRequestContext, httpRequest, httpResponse, "");
    }

    @Nonnull
    private ModelAndView replyUnauthorizedNegotiate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse, @Nonnull String base64Token) {
        StringBuilder authenticateHeader = new StringBuilder("Negotiate");
        if (!base64Token.isEmpty()) {
            authenticateHeader.append(" " + base64Token);
        }
        httpResponse.addHeader("WWW-Authenticate", authenticateHeader.toString());
        httpResponse.setStatus(401);
        return this.createModelAndView(profileRequestContext, httpRequest, httpResponse);
    }

    @Nonnull
    private ModelAndView createModelAndView(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse) {
        ModelAndView modelAndView = new ModelAndView("spnego-unavailable");
        modelAndView.addObject("profileRequestContext", (Object)profileRequestContext);
        modelAndView.addObject("request", (Object)httpRequest);
        modelAndView.addObject("response", (Object)httpResponse);
        modelAndView.addObject("encoder", HTMLEncoder.class);
        StringBuffer errorUrl = httpRequest.getRequestURL();
        errorUrl.append("/error");
        String queryString = httpRequest.getQueryString();
        if (queryString != null) {
            errorUrl.append("?").append(queryString);
        }
        modelAndView.addObject("errorUrl", (Object)errorUrl.toString());
        return modelAndView;
    }

    private boolean isNTLMMechanism(@Nonnull byte[] token) {
        byte[] headerNTLM = new byte[]{78, 84, 76, 77, 83, 83, 80};
        return Arrays.equals(headerNTLM, Arrays.copyOfRange(token, 0, 7));
    }
}

