/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.spnego.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.spnego.impl.KerberosRealmSettings;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class KerberosSettings {
    @Nonnull
    @NotEmpty
    private String loginModuleClassName = "com.sun.security.auth.module.Krb5LoginModule";
    private boolean refreshKrb5Config;
    @NonnullAfterInit
    @NonnullElements
    private Collection<KerberosRealmSettings> realmSettings = Collections.emptyList();

    public void setLoginModuleClassName(@Nonnull @NotEmpty String name) {
        this.loginModuleClassName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Class name cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getLoginModuleClassName() {
        return this.loginModuleClassName;
    }

    public void setRefreshKrb5Config(boolean flag) {
        this.refreshKrb5Config = flag;
    }

    public boolean getRefreshKrb5Config() {
        return this.refreshKrb5Config;
    }

    public void setRealms(@Nullable @NonnullElements Collection<KerberosRealmSettings> realms) {
        this.realmSettings = realms != null ? List.copyOf(realms) : Collections.emptyList();
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Collection<KerberosRealmSettings> getRealms() {
        return this.realmSettings;
    }
}

