/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Strings;
import java.net.InetAddress;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UserAgentContext;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.net.IPRange;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateUserAgentAddress
extends AbstractValidationAction {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.address";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateUserAgentAddress.class);
    @Nonnull
    @NonnullElements
    private Map<String, Collection<IPRange>> mappings;
    @Nullable
    private UserAgentContext uaContext;
    @Nullable
    private String principalName;

    public ValidateUserAgentAddress() {
        this.setMetricName(DEFAULT_METRIC_NAME);
        this.mappings = Collections.emptyMap();
    }

    public void setMappings(@Nullable @NonnullElements Map<String, Collection<IPRange>> newMappings) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (newMappings != null) {
            this.mappings = new HashMap<String, Collection<IPRange>>(newMappings.size());
            for (Map.Entry<String, Collection<IPRange>> e : newMappings.entrySet()) {
                if (Strings.isNullOrEmpty((String)e.getKey())) continue;
                this.mappings.put(e.getKey(), List.copyOf(e.getValue()));
            }
        } else {
            this.mappings = Collections.emptyMap();
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.uaContext = (UserAgentContext)authenticationContext.getSubcontext(UserAgentContext.class, false);
        if (this.uaContext == null) {
            this.log.debug("{} No UserAgentContext available within authentication context", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return false;
        }
        if (this.uaContext.getAddress() == null) {
            this.log.debug("{} No address available within UserAgentContext", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        for (Map.Entry<String, Collection<IPRange>> e : this.mappings.entrySet()) {
            if (!this.isAuthenticated(this.uaContext.getAddress(), e.getValue())) continue;
            this.principalName = e.getKey();
            this.log.info("{} Authenticated user agent with address {} as {}", new Object[]{this.getLogPrefix(), this.uaContext.getAddress().getHostAddress(), this.principalName});
            this.recordSuccess(profileRequestContext);
            this.buildAuthenticationResult(profileRequestContext, authenticationContext);
            return;
        }
        this.log.debug("{} User agent with address {} was not authenticated", (Object)this.getLogPrefix(), (Object)this.uaContext.getAddress().getHostAddress());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
        this.recordFailure(profileRequestContext);
    }

    private boolean isAuthenticated(@Nonnull InetAddress address, @Nonnull @NonnullElements Collection<IPRange> ranges) {
        byte[] resolvedAddress = address.getAddress();
        for (IPRange range : ranges) {
            if (!range.contains(resolvedAddress)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        subject.getPrincipals().add((Principal)new UsernamePrincipal(this.principalName));
        return subject;
    }
}

