/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateFunctionResult
extends AbstractValidationAction {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.function";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateFunctionResult.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, ?> resultLookupStrategy;
    @Nullable
    private Object result;

    public ValidateFunctionResult() {
        this.setMetricName(DEFAULT_METRIC_NAME);
    }

    public void setResultLookupStrategy(@Nonnull Function<ProfileRequestContext, ?> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resultLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Result lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resultLookupStrategy == null) {
            throw new ComponentInitializationException("Result lookup strategy cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        this.result = this.resultLookupStrategy.apply(profileRequestContext);
        if (this.result == null) {
            this.log.info("{} Authentication by function failed", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            this.recordFailure(profileRequestContext);
        } else if (this.result instanceof String) {
            this.log.info("{} Validated user via name '{}'", (Object)this.getLogPrefix(), this.result);
            this.recordSuccess(profileRequestContext);
            this.buildAuthenticationResult(profileRequestContext, authenticationContext);
        } else if (this.result instanceof Principal) {
            this.log.info("{} Validated user via Principal '{}'", (Object)this.getLogPrefix(), this.result);
            this.recordSuccess(profileRequestContext);
            this.buildAuthenticationResult(profileRequestContext, authenticationContext);
        } else if (this.result instanceof Subject) {
            this.log.info("{} Validated user via Subject", (Object)this.getLogPrefix());
            this.recordSuccess(profileRequestContext);
            this.buildAuthenticationResult(profileRequestContext, authenticationContext);
        } else {
            this.log.info("{} Authentication by function failed, result type was invalid", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
            this.recordFailure(profileRequestContext);
        }
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        if (this.result instanceof String) {
            subject.getPrincipals().add((Principal)new UsernamePrincipal((String)this.result));
            return subject;
        }
        if (this.result instanceof Principal) {
            subject.getPrincipals().add((Principal)this.result);
            return subject;
        }
        if (this.result instanceof Subject) {
            ((Subject)this.result).getPrincipals().addAll(subject.getPrincipals());
            return (Subject)this.result;
        }
        throw new ConstraintViolationException("Result type was unexpected");
    }
}

