/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.filter.AttributeFilter;
import net.shibboleth.idp.attribute.filter.AttributeFilterException;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.ExternalAuthenticationContext;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.idp.authn.principal.ProxyAuthenticationPrincipal;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateExternalAuthentication
extends AbstractValidationAction {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.external";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateExternalAuthentication.class);
    @Nullable
    private ReloadableService<AttributeFilter> attributeFilterService;
    @Nullable
    private MetadataResolver metadataResolver;
    @Nullable
    private Pattern matchExpression;
    @Nullable
    private ExternalAuthenticationContext extContext;
    @Nullable
    private AttributeContext attributeContext;

    public ValidateExternalAuthentication() {
        this(null);
    }

    public ValidateExternalAuthentication(@Nullable ReloadableService<AttributeFilter> filterService) {
        this.setMetricName(DEFAULT_METRIC_NAME);
        this.attributeFilterService = filterService;
    }

    public void setMatchExpression(@Nullable Pattern expression) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.matchExpression = expression != null && !expression.pattern().isEmpty() ? expression : null;
    }

    public void setMetadataResolver(@Nullable MetadataResolver resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.metadataResolver = resolver;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.extContext = (ExternalAuthenticationContext)authenticationContext.getSubcontext(ExternalAuthenticationContext.class);
        if (this.extContext == null) {
            this.log.debug("{} No ExternalAuthenticationContext available within authentication context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            this.recordFailure(profileRequestContext);
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (this.extContext.getAuthnException() != null) {
            this.log.info("{} External authentication produced exception", (Object)this.getLogPrefix(), (Object)this.extContext.getAuthnException());
            this.handleError(profileRequestContext, authenticationContext, this.extContext.getAuthnException(), "AuthenticationException");
            this.recordFailure(profileRequestContext);
            return;
        }
        if (this.extContext.getAuthnError() != null) {
            this.log.info("{} External authentication produced error message: {}", (Object)this.getLogPrefix(), (Object)this.extContext.getAuthnError());
            this.handleError(profileRequestContext, authenticationContext, this.extContext.getAuthnError(), "AuthenticationException");
            this.recordFailure(profileRequestContext);
            return;
        }
        if (this.extContext.getSubject() != null) {
            this.log.info("{} External authentication succeeded for Subject", (Object)this.getLogPrefix());
        } else if (this.extContext.getPrincipal() != null) {
            this.log.info("{} External authentication succeeded for Principal: {}", (Object)this.getLogPrefix(), (Object)this.extContext.getPrincipal());
            this.extContext.setSubject(new Subject(false, Collections.singleton(this.extContext.getPrincipal()), Collections.emptySet(), Collections.emptySet()));
        } else if (this.extContext.getPrincipalName() != null) {
            this.log.info("{} External authentication succeeded for user: {}", (Object)this.getLogPrefix(), (Object)this.extContext.getPrincipalName());
            this.extContext.setSubject(new Subject(false, Collections.singleton(new UsernamePrincipal(this.extContext.getPrincipalName())), Collections.emptySet(), Collections.emptySet()));
        } else {
            this.log.info("{} External authentication failed, no user identity or error information returned", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return;
        }
        if (!this.checkUsername(this.extContext.getSubject())) {
            this.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
            this.recordFailure(profileRequestContext);
            return;
        }
        this.recordSuccess(profileRequestContext);
        if (!this.extContext.getAuthenticatingAuthorities().isEmpty()) {
            ProxyAuthenticationPrincipal proxied = new ProxyAuthenticationPrincipal(this.extContext.getAuthenticatingAuthorities());
            this.extContext.getSubject().getPrincipals().add((Principal)proxied);
        }
        if (this.extContext.doNotCache()) {
            this.log.debug("{} Disabling caching of authentication result", (Object)this.getLogPrefix());
            authenticationContext.setResultCacheable(false);
        }
        this.filterAttributes();
        this.buildAuthenticationResult(profileRequestContext, authenticationContext);
        if (authenticationContext.getAuthenticationResult() != null) {
            if (this.extContext.getAuthnInstant() != null) {
                authenticationContext.getAuthenticationResult().setAuthenticationInstant(this.extContext.getAuthnInstant());
            }
            if (this.extContext.isPreviousResult()) {
                authenticationContext.getAuthenticationResult().setPreviousResult(true);
            }
        }
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        this.extContext.getSubject().getPrincipals().addAll(subject.getPrincipals());
        if (this.attributeContext != null && !this.attributeContext.getIdPAttributes().isEmpty()) {
            this.log.debug("{} Adding filtered inbound attributes to Subject", (Object)this.getLogPrefix());
            this.extContext.getSubject().getPrincipals().addAll(this.attributeContext.getIdPAttributes().values().stream().map(a -> new IdPAttributePrincipal(a)).collect(Collectors.toList()));
        }
        return this.extContext.getSubject();
    }

    private boolean checkUsername(@Nonnull Subject subject) {
        if (this.matchExpression != null) {
            Set<UsernamePrincipal> princs = subject.getPrincipals(UsernamePrincipal.class);
            if (princs != null && !princs.isEmpty()) {
                if (this.matchExpression.matcher(princs.iterator().next().getName()).matches()) {
                    return true;
                }
                this.log.info("{} Username did not match expression", (Object)this.getLogPrefix());
                return false;
            }
            this.log.info("{} Match expression set, but not UsernamePrincipal found");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterAttributes() {
        this.attributeContext = (AttributeContext)this.extContext.getSubcontext(AttributeContext.class);
        if (this.attributeContext == null) {
            this.log.debug("{} No attribute context, no attributes to filter", (Object)this.getLogPrefix());
            return;
        }
        if (this.attributeContext.getIdPAttributes().isEmpty()) {
            this.log.debug("{} No attributes to filter", (Object)this.getLogPrefix());
            return;
        }
        if (this.attributeFilterService == null) {
            this.log.warn("{} No AttributeFilter service provided, clearing inbound attributes", (Object)this.getLogPrefix());
            this.attributeContext.setIdPAttributes(null);
            return;
        }
        AttributeFilterContext filterContext = (AttributeFilterContext)this.extContext.getSubcontext(AttributeFilterContext.class, true);
        this.populateFilterContext(filterContext);
        ServiceableComponent component = null;
        try {
            component = this.attributeFilterService.getServiceableComponent();
            if (null == component) {
                this.log.error("{} Error while filtering inbound attributes: Invalid Attribute Filter configuration", (Object)this.getLogPrefix());
                this.attributeContext.setIdPAttributes(null);
            } else {
                AttributeFilter filter = (AttributeFilter)component.getComponent();
                filter.filterAttributes(filterContext);
                filterContext.getParent().removeSubcontext((BaseContext)filterContext);
                this.attributeContext.setIdPAttributes(filterContext.getFilteredIdPAttributes().values());
            }
        }
        catch (AttributeFilterException e) {
            this.log.error("{} Error while filtering inbound attributes", (Object)this.getLogPrefix(), (Object)e);
            this.attributeContext.setIdPAttributes(null);
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
    }

    private void populateFilterContext(@Nonnull AttributeFilterContext filterContext) {
        filterContext.setDirection(AttributeFilterContext.Direction.INBOUND).setPrefilteredIdPAttributes(this.attributeContext.getIdPAttributes().values()).setMetadataResolver(this.metadataResolver).setRequesterMetadataContextLookupStrategy(null).setProxiedRequesterContextLookupStrategy(null);
        if (!this.extContext.getAuthenticatingAuthorities().isEmpty()) {
            filterContext.setAttributeIssuerID((String)this.extContext.getAuthenticatingAuthorities().iterator().next());
        }
    }
}

