/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.authn.AccountLockoutManager;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.LockoutManagerContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageCapabilities;
import org.opensaml.storage.StorageCapabilitiesEx;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageBackedAccountLockoutManager
extends AbstractIdentifiableInitializableComponent
implements AccountLockoutManager {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(StorageBackedAccountLockoutManager.class);
    @NonnullAfterInit
    private StorageService storageService;
    @Nullable
    private Function<ProfileRequestContext, String> lockoutKeyStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Integer> maxAttemptsLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Duration> counterIntervalLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Duration> lockoutDurationLookupStrategy;
    private boolean extendLockoutDuration;

    public StorageBackedAccountLockoutManager() {
        this.setMaxAttempts(5);
        this.setCounterInterval(Duration.ofMinutes(5L));
        this.setLockoutDuration(Duration.ofMinutes(5L));
    }

    public void setStorageService(@Nonnull StorageService storage) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.storageService = (StorageService)Constraint.isNotNull((Object)storage, (String)"StorageService cannot be null");
        StorageCapabilities caps = this.storageService.getCapabilities();
        if (caps instanceof StorageCapabilitiesEx) {
            Constraint.isTrue((boolean)((StorageCapabilitiesEx)caps).isServerSide(), (String)"StorageService cannot be client-side");
            if (!((StorageCapabilitiesEx)caps).isClustered()) {
                this.log.info("Use of non-clustered storage service will result in per-node lockout behavior");
            }
        }
    }

    public void setLockoutKeyStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.lockoutKeyStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lockout key strategy cannot be null");
    }

    public void setMaxAttempts(@Positive int attempts) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.maxAttemptsLookupStrategy = FunctionSupport.constant((Object)Constraint.isGreaterThan((int)0, (int)attempts, (String)"Attempts must be greater than zero"));
    }

    public void setMaxAttemptsLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.maxAttemptsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Max attempts lookup strategy cannot be null");
    }

    public void setCounterInterval(@Nonnull Duration window) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.counterIntervalLookupStrategy = FunctionSupport.constant((Object)((Duration)Constraint.isNotNull((Object)window, (String)"Counter interval cannot be null")));
    }

    public void setCounterIntervalLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.counterIntervalLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Counter interval lookup strategy cannot be null");
    }

    public void setLockoutDuration(@Nonnull Duration duration) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.lockoutDurationLookupStrategy = FunctionSupport.constant((Object)((Duration)Constraint.isNotNull((Object)duration, (String)"Lockout duration cannot be null")));
    }

    public void setLockoutDurationLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.lockoutDurationLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lockout duration lookup strategy cannot be null");
    }

    public void setExtendLockoutDuration(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.extendLockoutDuration = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.storageService == null) {
            throw new ComponentInitializationException("StorageService cannot be null");
        }
        if (this.lockoutKeyStrategy == null) {
            throw new ComponentInitializationException("Lockout key strategy cannot be null");
        }
    }

    public boolean check(@Nonnull ProfileRequestContext profileRequestContext) {
        String key = this.lockoutKeyStrategy.apply(profileRequestContext);
        if (key == null) {
            this.log.warn("No lockout key returned for request");
            return false;
        }
        StorageRecord sr = null;
        try {
            sr = this.storageService.read(this.getId(), key);
        }
        catch (IOException e) {
            sr = null;
            this.log.error("Error reading back account lockout state for '{}'", (Object)key, (Object)e);
        }
        if (sr == null) {
            this.log.debug("No lockout record available for '{}'", (Object)key);
            return false;
        }
        try {
            int counter = Integer.parseInt(sr.getValue());
            if (counter >= this.maxAttemptsLookupStrategy.apply(profileRequestContext)) {
                long lockoutDuration = this.lockoutDurationLookupStrategy.apply(profileRequestContext).toMillis();
                long counterInterval = this.counterIntervalLookupStrategy.apply(profileRequestContext).toMillis();
                long lastAttempt = sr.getExpiration() - Math.max(lockoutDuration, counterInterval);
                long timeDifference = System.currentTimeMillis() - lastAttempt;
                if (timeDifference <= lockoutDuration) {
                    this.log.info("Lockout threshold reached for '{}', invalid count is {}", (Object)key, (Object)counter);
                    if (this.extendLockoutDuration) {
                        this.doIncrement(profileRequestContext, key, 10);
                    }
                    return true;
                }
                this.log.debug("Lockout for '{}' has elapsed", (Object)key);
            } else {
                this.log.debug("Invalid attempts counter for '{}' has only reached {}", (Object)key, (Object)counter);
            }
        }
        catch (NumberFormatException e) {
            this.log.error("Error converting lockout data for '{}' into integer", (Object)key, (Object)e);
        }
        return false;
    }

    public boolean increment(@Nonnull ProfileRequestContext profileRequestContext) {
        String key = this.lockoutKeyStrategy.apply(profileRequestContext);
        if (key == null) {
            this.log.warn("No lockout key returned for request");
            return false;
        }
        return this.doIncrement(profileRequestContext, key, 10);
    }

    public boolean clear(@Nonnull ProfileRequestContext profileRequestContext) {
        try {
            String key = this.lockoutKeyStrategy.apply(profileRequestContext);
            if (key != null) {
                this.log.debug("Clearing lockout state for '{}'", (Object)key);
                this.storageService.delete(this.getId(), key);
                return true;
            }
            this.log.warn("No lockout key returned for request");
        }
        catch (IOException e) {
            this.log.error("Error deleting lockout entry", (Throwable)e);
        }
        return false;
    }

    protected boolean doIncrement(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NotEmpty String key, int retries) {
        if (retries <= 0) {
            this.log.error("Account lockout increment attempts for '{}' exceeded retry limit", (Object)key);
            return false;
        }
        this.log.debug("Reading account lockout data for '{}'", (Object)key);
        int counter = 0;
        StorageRecord sr = null;
        try {
            sr = this.storageService.read(this.getId(), key);
            if (sr != null) {
                counter = Integer.parseInt(sr.getValue());
            }
        }
        catch (IOException e) {
            sr = null;
            counter = 0;
            this.log.error("Error reading back account lockout state for '{}'", (Object)key, (Object)e);
        }
        catch (NumberFormatException e) {
            sr = null;
            counter = 0;
            this.log.error("Error converting lockout data for '{}' into integer", (Object)key, (Object)e);
        }
        long now = System.currentTimeMillis();
        long lockoutDuration = this.lockoutDurationLookupStrategy.apply(profileRequestContext).toMillis();
        long counterInterval = this.counterIntervalLookupStrategy.apply(profileRequestContext).toMillis();
        long lastAccess = now;
        if (sr != null) {
            lastAccess = sr.getExpiration() - Math.max(lockoutDuration, counterInterval);
        }
        if (now - lastAccess > counterInterval) {
            counter = 0;
        }
        long expiration = System.currentTimeMillis() + Math.max(lockoutDuration, counterInterval);
        this.log.debug("Invalid login count for '{}' will be {}, expiring at {}", new Object[]{key, ++counter, Instant.ofEpochMilli(expiration)});
        if (sr == null) {
            try {
                if (this.storageService.create(this.getId(), key, Integer.toString(counter), Long.valueOf(expiration))) {
                    return true;
                }
            }
            catch (IOException e) {
                this.log.error("Unable to create account lockout record for '{}'", (Object)key, (Object)e);
            }
        } else {
            try {
                if (this.storageService.update(this.getId(), key, Integer.toString(counter), Long.valueOf(expiration))) {
                    return true;
                }
            }
            catch (IOException e) {
                this.log.error("Unable to update account lockout record for '{}'", (Object)key, (Object)e);
            }
        }
        return this.doIncrement(profileRequestContext, key, retries - 1);
    }

    public static class UsernameIPLockoutKeyStrategy
    implements Function<ProfileRequestContext, String> {
        @Nullable
        private HttpServletRequest httpRequest;

        public void setHttpServletRequest(@Nonnull HttpServletRequest request) {
            this.httpRequest = (HttpServletRequest)Constraint.isNotNull((Object)request, (String)"HttpServletRequest cannot be null");
        }

        @Override
        @Nullable
        public String apply(@Nullable ProfileRequestContext profileRequestContext) {
            if (profileRequestContext == null) {
                return null;
            }
            LockoutManagerContext lockoutManagerContext = (LockoutManagerContext)profileRequestContext.getSubcontext(LockoutManagerContext.class);
            if (lockoutManagerContext != null) {
                return lockoutManagerContext.getKey();
            }
            if (this.httpRequest == null) {
                return null;
            }
            AuthenticationContext authenticationContext = (AuthenticationContext)profileRequestContext.getSubcontext(AuthenticationContext.class);
            if (authenticationContext == null) {
                return null;
            }
            UsernamePasswordContext upContext = (UsernamePasswordContext)authenticationContext.getSubcontext(UsernamePasswordContext.class);
            if (upContext == null) {
                return null;
            }
            String username = upContext.getUsername();
            String ipAddr = HttpServletSupport.getRemoteAddr((ServletRequest)this.httpRequest);
            if (username == null || username.isEmpty() || ipAddr == null || ipAddr.isEmpty()) {
                return null;
            }
            return username.toLowerCase() + "!" + ipAddr;
        }
    }
}

