/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizationAction;
import net.shibboleth.idp.authn.SubjectCanonicalizationException;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeSourcedSubjectCanonicalization
extends AbstractSubjectCanonicalizationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeSourcedSubjectCanonicalization.class);
    private char delimiter = (char)64;
    private boolean resolveFromSubject;
    @Nonnull
    @NonnullElements
    private Map<String, IdPAttribute> subjectSourcedAttributes;
    @Nonnull
    @NonnullElements
    private List<String> attributeSourceIds = Collections.emptyList();
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy;
    @Nullable
    private AttributeContext attributeCtx;

    public AttributeSourcedSubjectCanonicalization() {
        this.subjectSourcedAttributes = Collections.emptyMap();
        this.attributeContextLookupStrategy = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(SubjectCanonicalizationContext.class));
    }

    public void setScopedDelimiter(char ch) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.delimiter = ch;
    }

    public void setResolveFromSubject(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resolveFromSubject = flag;
    }

    public void setAttributeSourceIds(@Nonnull @NonnullElements List<String> ids) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeSourceIds = new ArrayList<String>(StringSupport.normalizeStringCollection(ids));
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.attributeSourceIds.isEmpty()) {
            throw new ComponentInitializationException("Attribute source ID list cannot be empty");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        Set<IdPAttributePrincipal> subjectSourced;
        if (!super.doPreExecute(profileRequestContext, c14nContext)) {
            return false;
        }
        if (this.resolveFromSubject && (subjectSourced = c14nContext.getSubject().getPrincipals(IdPAttributePrincipal.class)) != null && !subjectSourced.isEmpty()) {
            this.subjectSourcedAttributes = new HashMap<String, IdPAttribute>(subjectSourced.size());
            subjectSourced.forEach(a -> this.subjectSourcedAttributes.put(a.getAttribute().getId(), a.getAttribute()));
        }
        this.attributeCtx = this.attributeContextLookupStrategy.apply(profileRequestContext);
        if (this.subjectSourcedAttributes.isEmpty() && (this.attributeCtx == null || this.attributeCtx.getIdPAttributes().isEmpty())) {
            this.log.warn("{} No attributes found, canonicalization not possible", (Object)this.getLogPrefix());
            c14nContext.setException((Exception)new SubjectCanonicalizationException("No attributes were found"));
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        for (String id : this.attributeSourceIds) {
            String result;
            IdPAttribute attr = this.subjectSourcedAttributes.get(id);
            if (attr != null) {
                result = this.findValue(attr);
                if (result == null) continue;
                c14nContext.setPrincipalName(result);
                return;
            }
            if (this.attributeCtx == null || (attr = (IdPAttribute)this.attributeCtx.getIdPAttributes().get(id)) == null || (result = this.findValue(attr)) == null) continue;
            c14nContext.setPrincipalName(result);
            return;
        }
        this.log.info("{} Attribute sources {} did not produce a usable identifier", (Object)this.getLogPrefix(), this.attributeSourceIds);
        c14nContext.setException((Exception)new SubjectCanonicalizationException("No usable attribute values were found"));
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
    }

    @Nullable
    private String findValue(@Nonnull IdPAttribute attribute) {
        for (IdPAttributeValue val : attribute.getValues()) {
            if (val instanceof StringAttributeValue) {
                StringAttributeValue stringVal = (StringAttributeValue)val;
                if (stringVal.getValue() == null || stringVal.getValue().isEmpty()) {
                    this.log.debug("{} Ignoring null/empty string value", (Object)this.getLogPrefix());
                    continue;
                }
                this.log.debug("{} Using attribute {} string value {} as input to transforms", new Object[]{this.getLogPrefix(), attribute.getId(), stringVal.getValue()});
                return this.applyTransforms(stringVal.getValue());
            }
            if (val instanceof ScopedStringAttributeValue) {
                ScopedStringAttributeValue scoped = (ScopedStringAttributeValue)val;
                String withScope = scoped.getValue() + this.delimiter + scoped.getScope();
                this.log.debug("{} Using attribute {} scoped value {} as input to transforms", new Object[]{this.getLogPrefix(), attribute.getId(), withScope});
                return this.applyTransforms(withScope);
            }
            this.log.warn("{} Unsupported attribute value type: {}", (Object)this.getLogPrefix(), (Object)val.getClass().getName());
        }
        return null;
    }
}

