/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.duo.impl;

import com.duosecurity.duoweb.DuoWebException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.duo.DuoIntegration;
import net.shibboleth.idp.authn.duo.context.DuoAuthenticationContext;
import net.shibboleth.idp.authn.duo.impl.AbstractDuoAuthenticator;
import net.shibboleth.idp.authn.duo.impl.DuoAuthResponse;
import net.shibboleth.idp.authn.duo.impl.DuoResponseWrapper;
import net.shibboleth.idp.authn.duo.impl.DuoSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;

public class DuoAuthAuthenticator
extends AbstractDuoAuthenticator {
    @Nonnull
    private final Escaper paramEscaper;
    @Nonnull
    private final TypeReference<DuoResponseWrapper<DuoAuthResponse>> wrapperTypeRef = new TypeReference<DuoResponseWrapper<DuoAuthResponse>>(){};

    public DuoAuthAuthenticator() {
        this.paramEscaper = UrlEscapers.urlFormParameterEscaper();
    }

    public DuoAuthResponse authenticate(@Nonnull DuoAuthenticationContext duoContext, @Nonnull DuoIntegration duoIntegration) throws DuoWebException {
        try {
            URI uri = new URIBuilder().setScheme("https").setHost(duoIntegration.getAPIHost()).setPath("/auth/v2/auth").build();
            RequestBuilder rb = RequestBuilder.post().setUri(uri).addParameter("username", duoContext.getUsername());
            if (duoContext.getClientAddress() != null) {
                rb.addParameter("ipaddr", duoContext.getClientAddress());
            }
            if (duoContext.getFactor() != null) {
                rb.addParameter("factor", duoContext.getFactor());
            }
            if (duoContext.getDeviceID() != null) {
                rb.addParameter("device", duoContext.getDeviceID());
            }
            if (duoContext.getPasscode() != null) {
                rb.addParameter("passcode", duoContext.getPasscode());
            }
            if (!duoContext.getPushInfo().isEmpty()) {
                ArrayList<CallSite> pushinfo = new ArrayList<CallSite>(duoContext.getPushInfo().size());
                for (Map.Entry entry : duoContext.getPushInfo().entrySet()) {
                    pushinfo.add((CallSite)((Object)(this.paramEscaper.escape((String)entry.getKey()) + "=" + this.paramEscaper.escape((String)entry.getValue()))));
                }
                rb.addParameter("pushinfo", StringSupport.listToStringValue(pushinfo, (String)"&"));
            }
            DuoSupport.signRequest(rb, duoIntegration);
            HttpUriRequest request = rb.build();
            return this.doAPIRequest(request, this.wrapperTypeRef).getResponse();
        }
        catch (IOException | URISyntaxException | InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new DuoWebException("Duo AuthAPI auth request failed: " + ex.getMessage());
        }
    }
}

