/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.spnego.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class KerberosRealmSettings
extends AbstractInitializableComponent {
    @NonnullAfterInit
    private String servicePrincipal;
    @Nullable
    private String keytab;
    @Nullable
    private String password;

    public void setServicePrincipal(@Nonnull @NotEmpty String principal) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.servicePrincipal = Constraint.isNotEmpty((String)StringSupport.trim((String)principal), (String)"Principal cannot be null or empty");
    }

    @NonnullAfterInit
    @NotEmpty
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    public void setKeytab(@Nullable String newKeytab) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.keytab = StringSupport.trim((String)newKeytab);
    }

    @Nullable
    public String getKeytab() {
        return this.keytab;
    }

    public void setPassword(@Nullable String newPassword) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.password = newPassword;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.servicePrincipal == null) {
            throw new ComponentInitializationException("'servicePrincipal' must be set.");
        }
        if (this.keytab == null && this.password == null) {
            throw new ComponentInitializationException("One of 'keytab' or 'password' must be set.");
        }
        if (this.keytab != null && this.password != null) {
            throw new ComponentInitializationException("'keytab' and 'password' are mutually exclusive.");
        }
    }
}

