/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.stream.JsonGenerator;
import net.shibboleth.idp.authn.principal.AbstractPrincipalSerializer;
import net.shibboleth.idp.authn.principal.PasswordPrincipal;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PasswordPrincipalSerializer
extends AbstractPrincipalSerializer<String> {
    @Nonnull
    @NotEmpty
    private static final String PASSWORD_FIELD = "PW";
    private static final Pattern JSON_PATTERN = Pattern.compile("^\\{\"PW\":.*\\}$");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PasswordPrincipalSerializer.class);
    @Nullable
    private DataSealer sealer;
    @Nonnull
    private final JsonBuilderFactory objectBuilderFactory = Json.createBuilderFactory(null);

    public void setDataSealer(@Nullable DataSealer theSealer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sealer = theSealer;
    }

    public boolean supports(@Nonnull Principal principal) {
        if (principal instanceof PasswordPrincipal) {
            if (this.sealer == null) {
                this.log.error("No DataSealer was provided, unable to support PasswordPrincipal serialization");
                return false;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull Principal principal) throws IOException {
        if (this.sealer == null) {
            throw new IOException("No DataSealer was provided, unable to support PasswordPrincipal serialization");
        }
        StringWriter sink = new StringWriter(32);
        try (JsonGenerator gen = this.getJsonGenerator(sink);){
            gen.writeStartObject().write(PASSWORD_FIELD, this.sealer.wrap(principal.getName(), Instant.now().plus(Duration.ofDays(365L)))).writeEnd();
        }
        catch (DataSealerException e) {
            throw new IOException(e);
        }
        return sink.toString();
    }

    public boolean supports(@Nonnull @NotEmpty String value) {
        if (JSON_PATTERN.matcher(value).matches()) {
            if (this.sealer == null) {
                this.log.error("No DataSealer was provided, unable to support PasswordPrincipal deserialization");
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public PasswordPrincipal deserialize(@Nonnull @NotEmpty String value) throws IOException {
        if (this.sealer == null) {
            throw new IOException("No DataSealer was provided, unable to support PasswordPrincipal deserialization");
        }
        try (JsonReader reader = this.getJsonReader(new StringReader(value));){
            JsonStructure st = reader.read();
            if (!(st instanceof JsonObject)) {
                throw new IOException("Found invalid data structure while parsing PasswordPrincipal");
            }
            JsonObject obj = (JsonObject)st;
            JsonString str = obj.getJsonString(PASSWORD_FIELD);
            if (str != null) {
                if (!Strings.isNullOrEmpty((String)str.getString())) {
                    try {
                        PasswordPrincipal passwordPrincipal = new PasswordPrincipal(this.sealer.unwrap(str.getString()));
                        return passwordPrincipal;
                    }
                    catch (DataSealerException e) {
                        throw new IOException(e);
                    }
                }
                this.log.warn("Skipping null/empty PasswordPrincipal");
            }
            PasswordPrincipal passwordPrincipal = null;
            return passwordPrincipal;
        }
        catch (JsonException e) {
            throw new IOException("Found invalid data structure while parsing PasswordPincipal", e);
        }
    }

    @Nonnull
    private synchronized JsonObjectBuilder getJsonObjectBuilder() {
        return this.objectBuilderFactory.createObjectBuilder();
    }

    @Nonnull
    private synchronized JsonArrayBuilder getJsonArrayBuilder() {
        return this.objectBuilderFactory.createArrayBuilder();
    }
}

