/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.Principal;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import net.shibboleth.idp.authn.principal.AbstractPrincipalSerializer;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.jaas.LdapPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LDAPPrincipalSerializer
extends AbstractPrincipalSerializer<String> {
    @Nonnull
    @NotEmpty
    private static final String PRINCIPAL_NAME_FIELD = "LDAPN";
    @Nonnull
    @NotEmpty
    private static final String PRINCIPAL_ENTRY_FIELD = "LDAPE";
    private static final Pattern JSON_PATTERN = Pattern.compile("^\\{\"LDAPN\":.*,\"LDAPE\":.*\\}$");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LDAPPrincipalSerializer.class);
    @Nonnull
    private final JsonBuilderFactory objectBuilderFactory = Json.createBuilderFactory(null);

    public boolean supports(@Nonnull Principal principal) {
        return principal instanceof LdapPrincipal;
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull Principal principal) throws IOException {
        StringWriter sink = new StringWriter(32);
        try (JsonGenerator gen = this.getJsonGenerator(sink);){
            gen.writeStartObject().write(PRINCIPAL_NAME_FIELD, principal.getName());
            LdapEntry entry = ((LdapPrincipal)principal).getLdapEntry();
            if (entry != null) {
                JsonObjectBuilder objectBuilder = this.getJsonObjectBuilder();
                objectBuilder.add("dn", entry.getDn());
                for (LdapAttribute attr : entry.getAttributes()) {
                    JsonArrayBuilder arrayBuilder = this.getJsonArrayBuilder();
                    for (String value : attr.getStringValues()) {
                        arrayBuilder.add(value);
                    }
                    objectBuilder.add(attr.getName(), (JsonValue)arrayBuilder.build());
                }
                gen.write(PRINCIPAL_ENTRY_FIELD, (JsonValue)objectBuilder.build());
            }
            gen.writeEnd();
        }
        return sink.toString();
    }

    public boolean supports(@Nonnull @NotEmpty String value) {
        return JSON_PATTERN.matcher(value).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public LdapPrincipal deserialize(@Nonnull @NotEmpty String value) throws IOException {
        try {
            Object object;
            LdapEntry entry;
            JsonString str;
            block15: {
                block16: {
                    JsonReader reader;
                    block13: {
                        block14: {
                            reader = this.getJsonReader(new StringReader(value));
                            JsonStructure st = reader.read();
                            if (!(st instanceof JsonObject)) {
                                throw new IOException("Found invalid data structure while parsing LdapPrincipal");
                            }
                            JsonObject obj = (JsonObject)st;
                            str = obj.getJsonString(PRINCIPAL_NAME_FIELD);
                            if (str == null) break block13;
                            if (Strings.isNullOrEmpty((String)str.getString())) break block14;
                            entry = null;
                            JsonObject jsonEntry = obj.getJsonObject(PRINCIPAL_ENTRY_FIELD);
                            if (jsonEntry == null) break block15;
                            entry = new LdapEntry();
                            object = jsonEntry.entrySet().iterator();
                            break block16;
                        }
                        this.log.warn("Skipping null/empty LdapPrincipal");
                    }
                    LdapPrincipal ldapPrincipal = null;
                    return ldapPrincipal;
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                }
                while (object.hasNext()) {
                    Map.Entry e = (Map.Entry)object.next();
                    if ("dn".equalsIgnoreCase((String)e.getKey())) {
                        entry.setDn(((JsonString)e.getValue()).getString());
                        continue;
                    }
                    LdapAttribute attr = new LdapAttribute((String)e.getKey());
                    for (JsonValue v : (JsonArray)e.getValue()) {
                        attr.addStringValue(new String[]{((JsonString)v).getString()});
                    }
                    entry.addAttribute(new LdapAttribute[]{attr});
                }
            }
            object = new LdapPrincipal(str.getString(), entry);
            return object;
        }
        catch (JsonException e) {
            throw new IOException("Found invalid data structure while parsing LdapPrincipal", e);
        }
    }

    @Nonnull
    private synchronized JsonObjectBuilder getJsonObjectBuilder() {
        return this.objectBuilderFactory.createObjectBuilder();
    }

    @Nonnull
    private synchronized JsonArrayBuilder getJsonArrayBuilder() {
        return this.objectBuilderFactory.createArrayBuilder();
    }
}

