/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizationAction;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectSubjectCanonicalizationFlow
extends AbstractSubjectCanonicalizationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SelectSubjectCanonicalizationFlow.class);

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        if (c14nContext.getAttemptedFlow() != null) {
            this.log.info("{} Moving incomplete flow {} to intermediate set, reselecting a different one", (Object)this.getLogPrefix(), (Object)c14nContext.getAttemptedFlow().getId());
            c14nContext.getIntermediateFlows().put(c14nContext.getAttemptedFlow().getId(), c14nContext.getAttemptedFlow());
        }
        return super.doPreExecute(profileRequestContext, c14nContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        SubjectCanonicalizationFlowDescriptor flow = this.selectUnattemptedFlow(profileRequestContext, c14nContext);
        if (flow == null) {
            this.log.error("{} No potential flows left to choose from, canonicalization will fail", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoPotentialFlow");
            return;
        }
        this.log.debug("{} Selecting canonicalization flow {}", (Object)this.getLogPrefix(), (Object)flow.getId());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)flow.getId());
    }

    @Nullable
    private SubjectCanonicalizationFlowDescriptor selectUnattemptedFlow(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        for (SubjectCanonicalizationFlowDescriptor flow : c14nContext.getPotentialFlows().values()) {
            if (c14nContext.getIntermediateFlows().containsKey(flow.getId())) continue;
            this.log.debug("{} Checking canonicalization flow {} for applicability...", (Object)this.getLogPrefix(), (Object)flow.getId());
            c14nContext.setAttemptedFlow(flow);
            if (flow.test(profileRequestContext)) {
                return flow;
            }
            this.log.debug("{} Canonicalization flow {} was not applicable to this request", (Object)this.getLogPrefix(), (Object)flow.getId());
        }
        return null;
    }
}

