/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractUsernamePasswordCredentialValidator;
import net.shibboleth.idp.authn.CredentialValidator;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.LDAPResponseContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.velocity.VelocityContext;
import org.ldaptive.Credential;
import org.ldaptive.LdapException;
import org.ldaptive.ResultCode;
import org.ldaptive.auth.AccountState;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResultCode;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.User;
import org.ldaptive.jaas.LdapPrincipal;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LDAPCredentialValidator
extends AbstractUsernamePasswordCredentialValidator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LDAPCredentialValidator.class);
    @Nonnull
    private Authenticator authenticator;
    @Nullable
    private String[] returnAttributes;

    @NonnullAfterInit
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(@Nonnull Authenticator auth) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authenticator = (Authenticator)Constraint.isNotNull((Object)auth, (String)"Authenticator cannot be null");
    }

    @Nullable
    public String[] getReturnAttributes() {
        return this.returnAttributes;
    }

    public void setReturnAttributes(String ... attributes) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.returnAttributes = attributes;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.authenticator == null) {
            throw new ComponentInitializationException("Authenticator cannot be null");
        }
    }

    @Nullable
    protected Subject doValidate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull UsernamePasswordContext usernamePasswordContext, @Nullable CredentialValidator.WarningHandler warningHandler, @Nullable CredentialValidator.ErrorHandler errorHandler) throws Exception {
        String username = usernamePasswordContext.getTransformedUsername();
        String eventToSignal = "InvalidCredentials";
        try {
            this.log.debug("{} Attempting to authenticate user {}", (Object)this.getLogPrefix(), (Object)username);
            VelocityContext context = new VelocityContext();
            context.put("usernamePasswordContext", (Object)usernamePasswordContext);
            AuthenticationRequest request = new AuthenticationRequest(new User(username, (Object)context), new Credential(usernamePasswordContext.getPassword()), this.returnAttributes);
            AuthenticationResponse response = this.authenticator.authenticate(request);
            this.log.trace("{} Authentication response {}", (Object)this.getLogPrefix(), (Object)response);
            if (((Boolean)response.getResult()).booleanValue()) {
                this.log.info("{} Login by '{}' succeeded", (Object)this.getLogPrefix(), (Object)username);
                ((LDAPResponseContext)authenticationContext.getSubcontext(LDAPResponseContext.class, true)).setAuthenticationResponse(response);
                if (response.getAccountState() != null) {
                    AccountState.Error error = response.getAccountState().getError();
                    if (warningHandler != null) {
                        warningHandler.handleWarning(profileRequestContext, authenticationContext, String.format("%s:%s:%s", error != null ? error : "ACCOUNT_WARNING", response.getResultCode(), response.getMessage()), "AccountWarning");
                    }
                }
                return this.populateSubject(usernamePasswordContext, response);
            }
            this.log.info("{} Login by '{}' failed", (Object)this.getLogPrefix(), (Object)username);
            ((LDAPResponseContext)authenticationContext.getSubcontext(LDAPResponseContext.class, true)).setAuthenticationResponse(response);
            if (AuthenticationResultCode.DN_RESOLUTION_FAILURE == response.getAuthenticationResultCode() || AuthenticationResultCode.INVALID_CREDENTIAL == response.getAuthenticationResultCode()) {
                throw new LdapException(String.format("%s:%s", response.getAuthenticationResultCode(), response.getMessage()));
            }
            if (response.getAccountState() != null) {
                AccountState state = response.getAccountState();
                eventToSignal = "AccountError";
                throw new LdapException(String.format("%s:%s:%s", state.getError(), response.getResultCode(), response.getMessage()));
            }
            if (response.getResultCode() == ResultCode.INVALID_CREDENTIALS) {
                throw new LdapException(String.format("%s:%s", response.getResultCode(), response.getMessage()));
            }
            eventToSignal = "AuthenticationException";
            LdapException e = new LdapException(response.getMessage(), response.getResultCode(), response.getMatchedDn(), response.getControls(), response.getReferralURLs(), response.getMessageId());
            this.log.warn("{} Login by {} produced exception", new Object[]{this.getLogPrefix(), username, e});
            throw e;
        }
        catch (LdapException e) {
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, (Exception)((Object)e), eventToSignal);
            }
            throw e;
        }
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull UsernamePasswordContext usernamePasswordContext, @Nonnull AuthenticationResponse ldapResponse) {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new LdapPrincipal(usernamePasswordContext.getTransformedUsername(), ldapResponse.getLdapEntry()));
        return super.populateSubject(subject, usernamePasswordContext);
    }
}

