/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AbstractUsernamePasswordCredentialValidator;
import net.shibboleth.idp.authn.CredentialValidator;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.codec.StringDigester;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.commons.codec.digest.Crypt;
import org.apache.commons.codec.digest.Md5Crypt;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

@ThreadSafe
public class HTPasswdCredentialValidator
extends AbstractUsernamePasswordCredentialValidator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTPasswdCredentialValidator.class);
    @NonnullAfterInit
    private StringDigester digester;
    @Nullable
    private Resource htPasswdResource;
    @Nullable
    private long lastModified = 0L;
    @Nonnull
    @NonnullElements
    private final Map<String, String> credentialMap = new ConcurrentHashMap<String, String>();

    public void setResource(@Nonnull Resource resource) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.htPasswdResource = (Resource)Constraint.isNotNull((Object)resource, (String)"Resource cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        try {
            if (this.htPasswdResource == null) {
                throw new ComponentInitializationException("Resource cannot be null");
            }
            this.digester = new StringDigester("SHA1", StringDigester.OutputFormat.BASE64);
            try (InputStream is = this.htPasswdResource.getInputStream();){
                this.credentialMap.putAll(this.readCredentials(is));
            }
            if (this.htPasswdResource.isFile()) {
                this.lastModified = this.htPasswdResource.lastModified();
            } else {
                this.htPasswdResource = null;
            }
        }
        catch (IOException e) {
            throw new ComponentInitializationException("Error reading htpasswd resource", (Exception)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ComponentInitializationException("Error creating digester", (Exception)e);
        }
    }

    @Nullable
    protected Subject doValidate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull UsernamePasswordContext usernamePasswordContext, @Nullable CredentialValidator.WarningHandler warningHandler, @Nullable CredentialValidator.ErrorHandler errorHandler) throws Exception {
        String username = usernamePasswordContext.getTransformedUsername();
        String passwd = this.credentialMap.get(username);
        if (passwd == null) {
            this.log.debug("{} Username '{}' not found in password resource", (Object)this.getLogPrefix(), (Object)username);
            LoginException e = new LoginException("UnknownUsername");
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, (Exception)e, "UnknownUsername");
            }
            throw e;
        }
        this.log.debug("{} Attempting to authenticate user '{}' ", (Object)this.getLogPrefix(), (Object)username);
        if (this.authenticate(usernamePasswordContext, passwd)) {
            this.log.info("{} Login by '{}' succeeded", (Object)this.getLogPrefix(), (Object)username);
            return this.populateSubject(new Subject(), usernamePasswordContext);
        }
        this.log.info("{} Login by '{}' failed", (Object)this.getLogPrefix(), (Object)username);
        LoginException e = new LoginException("InvalidCredentials");
        if (errorHandler != null) {
            errorHandler.handleError(profileRequestContext, authenticationContext, (Exception)e, "InvalidCredentials");
        }
        throw e;
    }

    @Nonnull
    private boolean authenticate(@Nonnull UsernamePasswordContext usernamePasswordContext, @Nonnull String storedPassword) {
        this.refreshCredentials();
        return storedPassword.startsWith("$apr1$") ? storedPassword.equals(Md5Crypt.apr1Crypt((String)usernamePasswordContext.getPassword(), (String)storedPassword)) : (storedPassword.startsWith("{SHA}") ? storedPassword.substring("{SHA}".length()).equals(this.digester.apply(usernamePasswordContext.getPassword())) : storedPassword.equals(Crypt.crypt((String)usernamePasswordContext.getPassword(), (String)storedPassword)));
    }

    private void refreshCredentials() {
        block9: {
            if (this.htPasswdResource == null) {
                return;
            }
            try {
                if (!this.htPasswdResource.isFile() || !this.htPasswdResource.exists() || this.htPasswdResource.lastModified() <= this.lastModified) break block9;
                try (InputStream is = this.htPasswdResource.getInputStream();){
                    this.credentialMap.clear();
                    this.credentialMap.putAll(this.readCredentials(is));
                }
            }
            catch (IOException e) {
                this.log.error("{} Error reloading credentials", (Object)this.getLogPrefix(), (Object)e);
            }
        }
    }

    @Nonnull
    @NonnullElements
    private Map<String, String> readCredentials(@Nonnull InputStream is) {
        HashMap<String, String> credentials = new HashMap<String, String>();
        Pattern entry = Pattern.compile("^([^:]+):(.+)");
        try (Scanner scanner = new Scanner(is, StandardCharsets.UTF_8.name());){
            while (scanner.hasNextLine()) {
                Matcher m;
                String line = scanner.nextLine().trim();
                if (line.isEmpty() || line.startsWith("#") || !(m = entry.matcher(line)).matches()) continue;
                String username = m.group(1);
                String password = m.group(2);
                if (Strings.isNullOrEmpty((String)username)) {
                    this.log.warn("{} Skipping line with empty username", (Object)this.getLogPrefix());
                    continue;
                }
                if (Strings.isNullOrEmpty((String)password)) {
                    this.log.warn("{} Skipping '{}' user with blank password", (Object)this.getLogPrefix(), (Object)username);
                    continue;
                }
                credentials.put(username.trim(), password.trim());
            }
        }
        this.log.debug("{} Loaded {} password entries", (Object)this.getLogPrefix(), (Object)credentials.size());
        return credentials;
    }
}

