/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.authn.AbstractExtractionAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.CertificateContext;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractX509CertificateFromRequest
extends AbstractExtractionAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExtractX509CertificateFromRequest.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        CertificateContext certCtx = new CertificateContext();
        authenticationContext.addSubcontext((BaseContext)certCtx, true);
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            this.log.debug("{} Profile action does not contain an HttpServletRequest", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        this.log.debug("{} {} X.509 Certificate(s) found in request", (Object)this.getLogPrefix(), (Object)(certs != null ? certs.length : 0));
        if (certs == null || certs.length < 1) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        X509Certificate cert = certs[0];
        this.log.debug("{} End-entity X.509 certificate found with subject '{}', issued by '{}'", new Object[]{this.getLogPrefix(), cert.getSubjectDN().getName(), cert.getIssuerDN().getName()});
        certCtx.setCertificate((Certificate)cert);
        for (int i = 1; i < certs.length; ++i) {
            certCtx.getIntermediates().add(certs[i]);
        }
    }
}

