/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.authn.AbstractExtractionAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernameContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractRemoteUser
extends AbstractExtractionAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExtractRemoteUser.class);
    private boolean checkRemoteUser = true;
    @Nonnull
    @NonnullElements
    private Collection<String> checkAttributes = Collections.emptyList();
    @Nonnull
    @NonnullElements
    private Collection<String> checkHeaders = Collections.emptyList();

    public void setCheckRemoteUser(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.checkRemoteUser = flag;
    }

    public void setCheckAttributes(@Nonnull @NonnullElements Collection<String> attributes) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.checkAttributes = new ArrayList<String>(StringSupport.normalizeStringCollection(attributes));
    }

    public void setCheckHeaders(@Nonnull @NonnullElements Collection<String> headers) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.checkHeaders = new ArrayList<String>(StringSupport.normalizeStringCollection(headers));
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (!this.checkRemoteUser && this.checkAttributes.isEmpty() && this.checkHeaders.isEmpty()) {
            this.log.debug("{} Configuration contains no headers or attributes to check", (Object)this.getLogPrefix());
            throw new ComponentInitializationException("ExtractRemoteUser action configuration is invalid");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        String username;
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            this.log.debug("{} Profile action does not contain an HttpServletRequest", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        if (this.checkRemoteUser && (username = request.getRemoteUser()) != null && !username.isEmpty()) {
            this.log.debug("{} User identity extracted from REMOTE_USER: {}", (Object)this.getLogPrefix(), (Object)username);
            ((UsernameContext)authenticationContext.getSubcontext(UsernameContext.class, true)).setUsername(this.applyTransforms(username));
            return;
        }
        for (String s : this.checkAttributes) {
            Object attr = request.getAttribute(s);
            if (attr == null || attr.toString().isEmpty()) continue;
            this.log.debug("{} User identity extracted from attribute {}: {}", new Object[]{this.getLogPrefix(), s, attr});
            ((UsernameContext)authenticationContext.getSubcontext(UsernameContext.class, true)).setUsername(this.applyTransforms(attr.toString()));
            return;
        }
        for (String s : this.checkHeaders) {
            username = request.getHeader(s);
            if (username == null || username.isEmpty()) continue;
            this.log.debug("{} User identity extracted from header {}: {}", new Object[]{this.getLogPrefix(), s, username});
            ((UsernameContext)authenticationContext.getSubcontext(UsernameContext.class, true)).setUsername(this.applyTransforms(username));
            return;
        }
        this.log.debug("{} No user identity found in request", (Object)this.getLogPrefix());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
    }
}

