/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicate;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactoryRegistry;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;

public class RequestedPrincipalContext
extends BaseContext {
    @Nonnull
    private PrincipalEvalPredicateFactoryRegistry evalRegistry = new PrincipalEvalPredicateFactoryRegistry();
    @Nullable
    private String operatorString;
    @Nonnull
    @NonnullElements
    private List<Principal> requestedPrincipals = Collections.emptyList();
    @Nullable
    private Principal matchingPrincipal;

    @Nonnull
    public PrincipalEvalPredicateFactoryRegistry getPrincipalEvalPredicateFactoryRegistry() {
        return this.evalRegistry;
    }

    @Nonnull
    public RequestedPrincipalContext setPrincipalEvalPredicateFactoryRegistry(@Nonnull PrincipalEvalPredicateFactoryRegistry registry) {
        this.evalRegistry = (PrincipalEvalPredicateFactoryRegistry)Constraint.isNotNull((Object)registry, (String)"PrincipalEvalPredicateFactoryRegistry cannot be null");
        return this;
    }

    @Nonnull
    @NotEmpty
    public String getOperator() {
        return this.operatorString;
    }

    @Nonnull
    public RequestedPrincipalContext setOperator(@Nullable @NotEmpty String operator) {
        this.operatorString = StringSupport.trimOrNull((String)operator);
        return this;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<Principal> getRequestedPrincipals() {
        return ImmutableList.copyOf(this.requestedPrincipals);
    }

    @Nonnull
    public RequestedPrincipalContext setRequestedPrincipals(@Nonnull @NonnullElements List<Principal> principals) {
        Constraint.isNotNull(principals, (String)"Principal list cannot be null");
        this.requestedPrincipals = new ArrayList<Principal>(Collections2.filter(principals, (Predicate)Predicates.notNull()));
        return this;
    }

    @Nullable
    public Principal getMatchingPrincipal() {
        return this.matchingPrincipal;
    }

    @Nonnull
    public RequestedPrincipalContext setMatchingPrincipal(@Nullable Principal principal) {
        this.matchingPrincipal = principal;
        return this;
    }

    @Nullable
    public PrincipalEvalPredicate getPredicate(@Nonnull Principal principal) {
        PrincipalEvalPredicateFactory factory = this.evalRegistry.lookup(principal.getClass(), this.operatorString);
        return factory != null ? factory.getPredicate(principal) : null;
    }

    public boolean isAcceptable(@Nonnull PrincipalSupportingComponent component) {
        for (Principal requestedPrincipal : this.requestedPrincipals) {
            PrincipalEvalPredicate predicate = this.getPredicate(requestedPrincipal);
            if (predicate == null || !predicate.apply(component)) continue;
            return true;
        }
        return false;
    }

    public boolean isAcceptable(final @Nonnull @NonnullElements Collection<Principal> principals) {
        return this.isAcceptable(new PrincipalSupportingComponent(){

            @Override
            public <T extends Principal> Set<T> getSupportedPrincipals(Class<T> c) {
                HashSet<Principal> set = new HashSet<Principal>();
                for (Principal p : principals) {
                    if (!c.isAssignableFrom(p.getClass())) continue;
                    set.add(p);
                }
                return set;
            }
        });
    }

    public <T extends Principal> boolean isAcceptable(final @Nonnull T principal) {
        return this.isAcceptable(new PrincipalSupportingComponent(){

            public <TT extends Principal> Set<TT> getSupportedPrincipals(Class<TT> c) {
                if (c.isAssignableFrom(principal.getClass())) {
                    return Collections.singleton(principal);
                }
                return Collections.emptySet();
            }
        });
    }
}

