/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.MultiFactorAuthenticationTransition;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;

public class MultiFactorAuthenticationContext
extends BaseContext {
    @Nonnull
    @NonnullElements
    private Map<String, MultiFactorAuthenticationTransition> transitionMap = new HashMap<String, MultiFactorAuthenticationTransition>();
    @Nonnull
    @NonnullElements
    private final Map<String, AuthenticationResult> activeResults = new HashMap<String, AuthenticationResult>();
    @Nullable
    private AuthenticationFlowDescriptor mfaFlowDescriptor;
    @Nullable
    @NotEmpty
    private String nextFlowId;
    @Nullable
    @NotEmpty
    private String event;

    @Nonnull
    @NonnullElements
    @Live
    public Map<String, MultiFactorAuthenticationTransition> getTransitionMap() {
        return this.transitionMap;
    }

    @Nonnull
    public MultiFactorAuthenticationContext setTransitionMap(@Nonnull Map<String, MultiFactorAuthenticationTransition> map) {
        Constraint.isNotNull(map, (String)"Map cannot be null");
        this.transitionMap.clear();
        for (Map.Entry<String, MultiFactorAuthenticationTransition> entry : map.entrySet()) {
            String trimmed = StringSupport.trimOrNull((String)entry.getKey());
            if (entry.getValue() == null) continue;
            this.transitionMap.put(trimmed, entry.getValue());
        }
        return this;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Map<String, AuthenticationResult> getActiveResults() {
        return this.activeResults;
    }

    @Nullable
    public AuthenticationFlowDescriptor getAuthenticationFlowDescriptor() {
        return this.mfaFlowDescriptor;
    }

    @Nonnull
    public MultiFactorAuthenticationContext setAuthenticationFlowDescriptor(@Nullable AuthenticationFlowDescriptor descriptor) {
        this.mfaFlowDescriptor = descriptor;
        return this;
    }

    @Nullable
    @NotEmpty
    public String getNextFlowId() {
        return this.nextFlowId;
    }

    @Nonnull
    public MultiFactorAuthenticationContext setNextFlowId(@Nullable @NotEmpty String id) {
        this.nextFlowId = StringSupport.trimOrNull((String)id);
        return this;
    }

    @Nullable
    @NotEmpty
    public String getEvent() {
        return this.event;
    }

    @Nonnull
    public MultiFactorAuthenticationContext setEvent(@Nullable @NotEmpty String e) {
        this.event = StringSupport.trimOrNull((String)e);
        return this;
    }

    public boolean isAcceptable() {
        AuthenticationContext authnContext = (AuthenticationContext)this.getParent();
        if (authnContext != null) {
            for (AuthenticationResult result : this.activeResults.values()) {
                if (authnContext.isForceAuthn() && result.isPreviousResult() || !authnContext.isAcceptable(result)) continue;
                return true;
            }
        }
        return false;
    }
}

