/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver;

import com.google.common.base.Predicates;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.MultipleResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.NoResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolverAttributeDefinitionDependency;
import net.shibboleth.idp.attribute.resolver.ResolverDataConnectorDependency;
import net.shibboleth.idp.attribute.resolver.ResolverPlugin;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.messaging.context.navigate.ParentContextLookup;
import org.opensaml.profile.context.MetricContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@ThreadSafe
public abstract class AbstractResolverPlugin<ResolvedType>
extends AbstractIdentifiableInitializableComponent
implements ResolverPlugin<ResolvedType>,
DisposableBean {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractResolverPlugin.class);
    private boolean propagateResolutionExceptions = true;
    private boolean suppressDisplayInformation;
    @Nonnull
    private Function<AttributeResolutionContext, ProfileRequestContext> profileContextStrategy = new ParentContextLookup(ProfileRequestContext.class);
    @Nullable
    private Predicate<ProfileRequestContext> activationCondition;
    @Nonnull
    @NonnullElements
    private Set<ResolverAttributeDefinitionDependency> attributeDependencies = Collections.emptySet();
    @Nonnull
    @NonnullElements
    private Set<ResolverDataConnectorDependency> dataConnectorDependencies = Collections.emptySet();

    public boolean isSuppressDisplayInformation() {
        return this.suppressDisplayInformation;
    }

    public void setSuppressDisplayInformation(boolean what) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.suppressDisplayInformation = what;
    }

    @Override
    public boolean isPropagateResolutionExceptions() {
        return this.propagateResolutionExceptions;
    }

    public void setPropagateResolutionExceptions(boolean propagate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.propagateResolutionExceptions = propagate;
    }

    public Function<AttributeResolutionContext, ProfileRequestContext> getProfileContextStrategy() {
        return this.profileContextStrategy;
    }

    public void setProfileContextStrategy(Function<AttributeResolutionContext, ProfileRequestContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.profileContextStrategy = (Function)Constraint.isNotNull(strategy, (String)"Profile Context Strategy cannot be null");
    }

    @Override
    @Nullable
    public Predicate<ProfileRequestContext> getActivationCondition() {
        return this.activationCondition;
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> pred) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.activationCondition = (Predicate)Constraint.isNotNull(pred, (String)"Activation condition cannot be null");
    }

    @Override
    @NonnullAfterInit
    @NonnullElements
    @Unmodifiable
    public Set<ResolverAttributeDefinitionDependency> getAttributeDependencies() {
        return this.attributeDependencies;
    }

    @Override
    @NonnullAfterInit
    @NonnullElements
    @Unmodifiable
    public Set<ResolverDataConnectorDependency> getDataConnectorDependencies() {
        return this.dataConnectorDependencies;
    }

    public void setAttributeDependencies(@Nonnull @NonnullElements Set<ResolverAttributeDefinitionDependency> dependencies) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull(dependencies, (String)"Attribute Dependencies cannot be null");
        this.attributeDependencies = Set.copyOf(dependencies);
    }

    public void setDataConnectorDependencies(@Nonnull @NonnullElements Set<ResolverDataConnectorDependency> dependencies) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull(dependencies, (String)"DataConnector Dependencies cannot be null");
        this.dataConnectorDependencies = Set.copyOf(dependencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final ResolvedType resolve(@Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)((Object)resolutionContext), (String)"AttributeResolutionContext cannot be null");
        boolean timerStarted = this.startTimer(resolutionContext);
        try {
            ResolvedType ResolvedType;
            ProfileRequestContext profileRequestContext;
            if (null != this.activationCondition && !this.activationCondition.test(profileRequestContext = this.profileContextStrategy.apply(resolutionContext))) {
                this.log.debug("Resolver plugin '{}': activation criteria not met, nothing to do", (Object)this.getId());
                ResolvedType ResolvedType2 = null;
                return ResolvedType2;
            }
            AttributeResolverWorkContext workContext = (AttributeResolverWorkContext)resolutionContext.getSubcontext(AttributeResolverWorkContext.class, false);
            Constraint.isNotNull((Object)((Object)workContext), (String)"AttributeResolverWorkContext cannot be null");
            try {
                ResolvedType result = this.doResolve(resolutionContext, workContext);
                if (null == result) {
                    this.log.debug("Resolver plugin '{}' produced no value.", (Object)this.getId());
                }
                ResolvedType = result;
            }
            catch (ResolutionException e) {
                ResolvedType ResolvedType3;
                block13: {
                    if (this.propagateResolutionExceptions) {
                        throw e;
                    }
                    if (e instanceof NoResultAnErrorResolutionException || e instanceof MultipleResultAnErrorResolutionException) {
                        this.log.debug("Resolver plugin '{}' produced the following error but was configured not to propagate", (Object)this.getId(), (Object)e);
                    } else {
                        this.log.warn("Resolver plugin '{}' produced the following error but was configured not to propagate", (Object)this.getId(), (Object)e);
                    }
                    ResolvedType3 = null;
                    if (!timerStarted) break block13;
                    this.stopTimer(resolutionContext);
                }
                return ResolvedType3;
            }
            return ResolvedType;
        }
        finally {
            if (timerStarted) {
                this.stopTimer(resolutionContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addDisplayInformation(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull IdPAttribute attribute) {
        if (this.isSuppressDisplayInformation()) {
            this.log.trace("{} no display information added", (Object)this.getLogPrefix());
            return;
        } else if (resolutionContext.getTranscoderRegistry() != null) {
            ServiceableComponent component = null;
            try {
                component = resolutionContext.getTranscoderRegistry().getServiceableComponent();
                if (component != null) {
                    if (attribute.getDisplayNames().isEmpty()) {
                        attribute.setDisplayNames(((AttributeTranscoderRegistry)component.getComponent()).getDisplayNames(attribute));
                        this.log.trace("{} associated display names with the resolved attribute: {}", (Object)this.getLogPrefix(), (Object)attribute.getDisplayNames());
                    }
                    if (!attribute.getDisplayDescriptions().isEmpty()) return;
                    attribute.setDisplayDescriptions(((AttributeTranscoderRegistry)component.getComponent()).getDescriptions(attribute));
                    this.log.trace("{} associated descriptions with the resolved attribute: {}", (Object)this.getLogPrefix(), (Object)attribute.getDisplayDescriptions());
                    return;
                }
                this.log.warn("No transcoder registry available, unable to attach displayName/description metadata");
                return;
            }
            finally {
                if (component != null) {
                    component.unpinComponent();
                }
            }
        } else {
            this.log.debug("No transcoder registry supplied, unable to attach displayName/description metadata");
        }
    }

    protected void doDestroy() {
        this.activationCondition = Predicates.alwaysFalse();
        this.attributeDependencies = Collections.emptySet();
        this.dataConnectorDependencies = Collections.emptySet();
        super.doDestroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractResolverPlugin)) {
            return false;
        }
        AbstractResolverPlugin other = (AbstractResolverPlugin)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    @Nullable
    protected abstract ResolvedType doResolve(@Nonnull AttributeResolutionContext var1, @Nonnull AttributeResolverWorkContext var2) throws ResolutionException;

    private boolean startTimer(@Nonnull AttributeResolutionContext resolutionContext) {
        MetricContext timerCtx;
        ProfileRequestContext prc = this.profileContextStrategy.apply(resolutionContext);
        if (prc != null && (timerCtx = (MetricContext)prc.getSubcontext(MetricContext.class)) != null) {
            timerCtx.start(this.getId());
            return true;
        }
        return false;
    }

    private void stopTimer(@Nonnull AttributeResolutionContext resolutionContext) {
        MetricContext timerCtx;
        ProfileRequestContext prc = this.profileContextStrategy.apply(resolutionContext);
        if (prc != null && (timerCtx = (MetricContext)prc.getSubcontext(MetricContext.class)) != null) {
            timerCtx.stop(this.getId());
        }
    }

    @Nonnull
    @NotEmpty
    protected abstract String getLogPrefix();
}

