/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractResolverPlugin;
import net.shibboleth.idp.attribute.resolver.DataConnector;
import net.shibboleth.idp.attribute.resolver.MultipleResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.NoResultAnErrorResolutionException;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractDataConnector
extends AbstractResolverPlugin<Map<String, IdPAttribute>>
implements DataConnector {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractDataConnector.class);
    @Nullable
    private String failoverDataConnectorId;
    @Nullable
    private String logPrefix;
    @Nullable
    private Instant lastSuccess;
    @Nullable
    private Instant lastFail;
    @Nonnull
    private Duration noRetryDelay = Duration.ZERO;
    @Deprecated(since="4.1.0", forRemoval=true)
    private boolean exportAllAttributes;
    @Nonnull
    @NonnullElements
    @Unmodifiable
    private Collection<String> exportAttributes = Collections.emptySet();

    @Override
    @Nullable
    public String getFailoverDataConnectorId() {
        return this.failoverDataConnectorId;
    }

    public void setFailoverDataConnectorId(@Nullable String id) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.failoverDataConnectorId = StringSupport.trimOrNull((String)id);
    }

    public void setLastSuccess(@Nullable Instant time) {
        this.lastSuccess = time;
    }

    @Override
    @Nullable
    public Instant getLastSuccess() {
        return this.lastSuccess;
    }

    public void setLastFail(@Nullable Instant time) {
        this.lastFail = time;
    }

    @Override
    @Nullable
    public Instant getLastFail() {
        return this.lastFail;
    }

    public void setNoRetryDelay(@Nonnull Duration delay) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.noRetryDelay = delay;
    }

    @Override
    @Nonnull
    public Duration getNoRetryDelay() {
        return this.noRetryDelay;
    }

    @Deprecated(since="4.1.0", forRemoval=true)
    public void setExportAllAttributes(boolean what) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.exportAllAttributes = what;
    }

    @Override
    @Deprecated(since="4.1.0", forRemoval=true)
    public boolean isExportAllAttributes() {
        return this.exportAllAttributes;
    }

    public void setExportAttributes(@Nonnull @NonnullElements Collection<String> what) {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.exportAttributes = Set.copyOf(what);
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Collection<String> getExportAttributes() {
        return this.exportAttributes;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = null;
    }

    @Override
    @Nullable
    public final Map<String, IdPAttribute> doResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        Map<String, IdPAttribute> result;
        try {
            result = this.doDataConnectorResolve(resolutionContext, workContext);
            this.setLastSuccess(Instant.now());
        }
        catch (MultipleResultAnErrorResolutionException | NoResultAnErrorResolutionException e) {
            throw e;
        }
        catch (Exception e) {
            this.setLastFail(Instant.now());
            throw e;
        }
        if (null == result) {
            this.log.debug("{} no attributes were produced during resolution", (Object)this.getId());
            return result;
        }
        this.log.debug("{} produced the following {} attributes during resolution {}", new Object[]{this.getLogPrefix(), result.size(), result.keySet()});
        for (String attrName : result.keySet()) {
            IdPAttribute attr = result.get(attrName);
            this.log.debug("{} Attribute '{}': Values '{}'", new Object[]{this.getLogPrefix(), attrName, attr.getValues()});
        }
        return result;
    }

    @Nullable
    protected abstract Map<String, IdPAttribute> doDataConnectorResolve(@Nonnull AttributeResolutionContext var1, @Nonnull AttributeResolverWorkContext var2) throws ResolutionException;

    @Override
    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Data Connector '").append(this.getId()).append("':");
            prefix = builder.toString();
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        return prefix;
    }
}

