/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.rdbms;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.rdbms.AbstractExecutableStatementBuilder;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class FormatExecutableStatementBuilder
extends AbstractExecutableStatementBuilder {
    @NonnullAfterInit
    private String sqlQuery;

    public void setQuery(@Nonnull String query) {
        this.sqlQuery = (String)Constraint.isNotNull((Object)query, (String)"SQL query cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.sqlQuery) {
            throw new ComponentInitializationException("FormatExecutableStatementBuilder: SQL query cannot be null");
        }
    }

    @Override
    protected String getSQLQuery(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) {
        ArrayList<Object> args = new ArrayList<Object>();
        if (dependencyAttributes != null && !dependencyAttributes.isEmpty()) {
            for (Map.Entry<String, List<IdPAttributeValue>> entry : dependencyAttributes.entrySet()) {
                for (IdPAttributeValue value : entry.getValue()) {
                    if (value.getNativeValue() instanceof String) {
                        args.add(((String)value.getNativeValue()).replace("'", "''"));
                        continue;
                    }
                    args.add(value.getNativeValue());
                }
            }
        } else if (resolutionContext.getPrincipal() != null) {
            args.add(resolutionContext.getPrincipal().replace("'", "''"));
        } else {
            args.add(null);
        }
        return String.format(this.sqlQuery, args.toArray());
    }
}

