/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc.ldap;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.dc.ldap.AbstractExecutableSearchFilterBuilder;
import net.shibboleth.idp.attribute.resolver.dc.ldap.ExecutableSearchFilter;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.ldaptive.SearchFilter;

public class ParameterizedExecutableSearchFilterBuilder
extends AbstractExecutableSearchFilterBuilder {
    @NonnullAfterInit
    private String searchFilter;

    public void setSearchFilter(@Nonnull String filter) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.searchFilter = (String)Constraint.isNotNull((Object)filter, (String)"Search filter can not be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        Constraint.isNotNull((Object)this.searchFilter, (String)"Search filter can not be null");
        super.doInitialize();
    }

    @Override
    public ExecutableSearchFilter build(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull Map<String, List<IdPAttributeValue>> dependencyAttributes) throws ResolutionException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        SearchFilter sf = new SearchFilter(this.searchFilter);
        sf.setParameter("principalName", (Object)resolutionContext.getPrincipal());
        if (dependencyAttributes != null && !dependencyAttributes.isEmpty()) {
            for (Map.Entry<String, List<IdPAttributeValue>> entry : dependencyAttributes.entrySet()) {
                int i = 0;
                for (IdPAttributeValue value : entry.getValue()) {
                    if (i == 0) {
                        sf.setParameter(String.format("%s", entry.getKey(), i), value.getNativeValue());
                    }
                    sf.setParameter(String.format("%s[%s]", entry.getKey(), i++), value.getNativeValue());
                }
            }
        }
        return super.build(sf);
    }
}

