/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.dc;

import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.resolver.dc.ValidationException;
import net.shibboleth.idp.attribute.resolver.dc.Validator;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import org.slf4j.LoggerFactory;

public class NonFailFastValidator
implements Validator {
    @Nullable
    private final Validator embeddedValidator;

    public NonFailFastValidator() {
        this(null);
    }

    public NonFailFastValidator(@Nullable Validator validator) {
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CLASS, (String)"NonFailFastValidator", null, (String)"failFastInitialize on DataConnector or p:throwValidateError on the contained Validator");
        this.embeddedValidator = validator;
        if (this.embeddedValidator != null) {
            this.embeddedValidator.setThrowValidateError(false);
        }
    }

    @Override
    public void validate() throws ValidationException {
        if (this.embeddedValidator != null) {
            try {
                this.embeddedValidator.validate();
            }
            catch (ValidationException e) {
                LoggerFactory.getLogger(NonFailFastValidator.class).warn("Non-fail-fast validator trapped an error from its embedded validator", (Throwable)e);
            }
        }
    }

    @Override
    public void setThrowValidateError(boolean what) {
        LoggerFactory.getLogger(NonFailFastValidator.class).error("setThrowValidateError ignored");
    }

    @Override
    public boolean isThrowValidateError() {
        return false;
    }
}

