/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class AttributeResolutionContext
extends BaseContext {
    @Nullable
    private ReloadableService<AttributeTranscoderRegistry> registryService;
    @Nonnull
    @NonnullElements
    private Set<String> requestedAttributeNames = new HashSet<String>();
    @Nullable
    private String principal;
    @Nullable
    private String attributeIssuerID;
    @Nullable
    private String attributeRecipientID;
    @Nullable
    private String attributeRecipientGroupID;
    private boolean allowCachedResults = true;
    @Nullable
    private String resolutionLabel;
    @Nonnull
    @NonnullElements
    private Map<String, IdPAttribute> resolvedAttributes = Collections.emptyMap();

    @Nullable
    public ReloadableService<AttributeTranscoderRegistry> getTranscoderRegistry() {
        return this.registryService;
    }

    @Nonnull
    public AttributeResolutionContext setTranscoderRegistry(@Nullable ReloadableService<AttributeTranscoderRegistry> service) {
        this.registryService = service;
        return this;
    }

    public boolean getAllowCachedResults() {
        return this.allowCachedResults;
    }

    @Nonnull
    public AttributeResolutionContext setAllowCachedResults(boolean flag) {
        this.allowCachedResults = flag;
        return this;
    }

    @Nullable
    public String getResolutionLabel() {
        return this.resolutionLabel;
    }

    @Nonnull
    public AttributeResolutionContext setResolutionLabel(@Nullable String label) {
        this.resolutionLabel = StringSupport.trimOrNull((String)label);
        return this;
    }

    @Nullable
    public String getAttributeIssuerID() {
        return this.attributeIssuerID;
    }

    @Nullable
    public AttributeResolutionContext setAttributeIssuerID(@Nullable String value) {
        this.attributeIssuerID = value;
        return this;
    }

    @Nullable
    public String getAttributeRecipientID() {
        return this.attributeRecipientID;
    }

    @Nullable
    public AttributeResolutionContext setAttributeRecipientID(@Nullable String value) {
        this.attributeRecipientID = value;
        return this;
    }

    @Nullable
    public String getAttributeRecipientGroupID() {
        return this.attributeRecipientGroupID;
    }

    @Nullable
    public AttributeResolutionContext setAttributeRecipientGroupID(@Nullable String value) {
        this.attributeRecipientGroupID = value;
        return this;
    }

    @Nullable
    public String getPrincipal() {
        return this.principal;
    }

    @Nullable
    public AttributeResolutionContext setPrincipal(@Nullable String who) {
        this.principal = who;
        return this;
    }

    @Nonnull
    @NonnullElements
    @Live
    public Collection<String> getRequestedIdPAttributeNames() {
        return this.requestedAttributeNames;
    }

    @Nullable
    public AttributeResolutionContext setRequestedIdPAttributeNames(@Nonnull @NonnullElements Collection<String> names) {
        this.requestedAttributeNames = ((Collection)Constraint.isNotNull(names, (String)"Requested IdPAttribute collection cannot be null")).stream().filter(n -> n != null).collect(Collectors.toCollection(HashSet::new));
        return this;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Map<String, IdPAttribute> getResolvedIdPAttributes() {
        return this.resolvedAttributes;
    }

    @Nullable
    public AttributeResolutionContext setResolvedIdPAttributes(@Nonnull @NonnullElements Collection<IdPAttribute> attributes) {
        Constraint.isNotNull(attributes, (String)"Null attribute set cannot be inserted into a context");
        this.resolvedAttributes = attributes.stream().collect(Collectors.toUnmodifiableMap(IdPAttribute::getId, a -> a));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveAttributes(@Nonnull ReloadableService<AttributeResolver> attributeResolverService) {
        Logger log = LoggerFactory.getLogger(AttributeResolutionContext.class);
        ServiceableComponent component = null;
        try {
            component = attributeResolverService.getServiceableComponent();
            if (null == component) {
                log.error("Error resolving attributes: Invalid Attribute resolver configuration");
            } else {
                AttributeResolver attributeResolver = (AttributeResolver)component.getComponent();
                attributeResolver.resolveAttributes(this);
            }
        }
        catch (ResolutionException e) {
            log.error("Error resolving attributes", (Throwable)e);
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
    }
}

