/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolvedAttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolvedDataConnector;
import net.shibboleth.idp.attribute.resolver.ResolverAttributeDefinitionDependency;
import net.shibboleth.idp.attribute.resolver.ResolverDataConnectorDependency;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginDependencySupport {
    private static final Logger LOG = LoggerFactory.getLogger(PluginDependencySupport.class);

    private PluginDependencySupport() {
    }

    @Nonnull
    @NonnullElements
    public static List<IdPAttributeValue> getMergedAttributeValues(@Nonnull AttributeResolverWorkContext workContext, @Nonnull @NonnullElements Collection<ResolverAttributeDefinitionDependency> attributeDependencies, @Nonnull @NonnullElements Collection<ResolverDataConnectorDependency> dataConnectorDependencies, @Nonnull String attributeDefinitionId) {
        Constraint.isNotNull((Object)((Object)workContext), (String)"Attribute resolution context cannot be null");
        Constraint.isNotNull(attributeDependencies, (String)"Resolver dependency collection cannot be null");
        ArrayList<IdPAttributeValue> values = new ArrayList<IdPAttributeValue>();
        if (LOG.isTraceEnabled()) {
            LOG.trace("GetMergedAttribute Values for {}", (Object)attributeDefinitionId);
        }
        for (ResolverAttributeDefinitionDependency attributeDependency : attributeDependencies) {
            Constraint.isNotNull((Object)attributeDependency, (String)"Resolver attribute dependency cannot be null");
            String attributeId = attributeDependency.getDependencyPluginId();
            ResolvedAttributeDefinition attributeDefinition = workContext.getResolvedIdPAttributeDefinitions().get(attributeId);
            IdPAttribute resolvedAttribute = attributeDefinition.getResolvedAttribute();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Merging Attribute Values from Attribute {}", (Object)attributeId);
            }
            PluginDependencySupport.mergeAttributeValues(resolvedAttribute, values);
        }
        for (ResolverDataConnectorDependency dataConnectorDependency : dataConnectorDependencies) {
            Map<String, IdPAttribute> resolvedAttrs;
            Constraint.isNotNull((Object)dataConnectorDependency, (String)"Resolver data connector dependency cannot be null");
            String dataConnectorId = dataConnectorDependency.getDependencyPluginId();
            ResolvedDataConnector dataConnector = workContext.getResolvedDataConnectors().get(dataConnectorId);
            if (dataConnector == null || null == (resolvedAttrs = dataConnector.getResolvedAttributes())) continue;
            for (Map.Entry<String, IdPAttribute> entry : resolvedAttrs.entrySet()) {
                if (dataConnectorDependency.isAllAttributes() || dataConnectorDependency.getAttributeNames().contains(entry.getKey())) {
                    PluginDependencySupport.mergeAttributeValues(entry.getValue(), values);
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Merging Attribute {} from DataConnecteor {}", (Object)entry.getValue(), (Object)dataConnectorId);
            }
        }
        return values;
    }

    public static Map<String, List<IdPAttributeValue>> getAllAttributeValues(@Nonnull AttributeResolverWorkContext workContext, @Nonnull Collection<ResolverAttributeDefinitionDependency> attributeDependencies, @Nonnull @NonnullElements Collection<ResolverDataConnectorDependency> dataConnectorDependencies) {
        HashMap<String, List<IdPAttributeValue>> result = new HashMap<String, List<IdPAttributeValue>>();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Getting all Attribute Values");
        }
        for (ResolverAttributeDefinitionDependency dependency : attributeDependencies) {
            Constraint.isNotNull((Object)dependency, (String)"Attribute Definition dependency cannot be null");
            String attributeId = dependency.getDependencyPluginId();
            ResolvedAttributeDefinition attributeDefinition = workContext.getResolvedIdPAttributeDefinitions().get(attributeId);
            if (attributeDefinition == null) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Adding Attribute {}", (Object)attributeId);
            }
            PluginDependencySupport.addAttribute(attributeDefinition.getResolvedAttribute(), result);
        }
        for (ResolverDataConnectorDependency dataConnectorDependency : dataConnectorDependencies) {
            Map<String, IdPAttribute> resolvedAttrs;
            Constraint.isNotNull((Object)dataConnectorDependency, (String)"Data Connector dependency cannot be null");
            String dataConnectorId = dataConnectorDependency.getDependencyPluginId();
            ResolvedDataConnector dataConnector = workContext.getResolvedDataConnectors().get(dataConnectorId);
            if (dataConnector == null || null == (resolvedAttrs = dataConnector.getResolvedAttributes())) continue;
            for (Map.Entry<String, IdPAttribute> entry : resolvedAttrs.entrySet()) {
                if (!dataConnectorDependency.isAllAttributes() && !dataConnectorDependency.getAttributeNames().contains(entry.getKey())) continue;
                PluginDependencySupport.addAttribute(entry.getValue(), result);
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Adding Attribute {} from Data Connector {}", (Object)entry.getValue(), (Object)dataConnectorId);
            }
        }
        return result;
    }

    @Nonnull
    private static void mergeAttributes(@Nonnull Map<String, IdPAttribute> sources, @Nullable Map<String, List<IdPAttributeValue>> target) {
        for (IdPAttribute source : sources.values()) {
            if (source == null) continue;
            PluginDependencySupport.addAttribute(source, target);
        }
    }

    @Nonnull
    private static void addAttribute(@Nullable IdPAttribute source, @Nullable Map<String, List<IdPAttributeValue>> target) {
        if (source == null) {
            return;
        }
        List<IdPAttributeValue> attributeValues = target.get(source.getId());
        if (attributeValues == null) {
            attributeValues = new ArrayList<IdPAttributeValue>();
            target.put(source.getId(), attributeValues);
        }
        PluginDependencySupport.mergeAttributeValues(source, attributeValues);
    }

    @Nonnull
    private static void mergeAttributeValues(@Nullable IdPAttribute source, @Nonnull List<IdPAttributeValue> target) {
        if (source != null) {
            target.addAll(source.getValues());
        }
    }
}

