/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.transcoding.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.PredicateSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class TranscodingRuleLoader {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(TranscodingRuleLoader.class);
    @Nonnull
    @NonnullElements
    private final Collection<TranscodingRule> rules;

    public TranscodingRuleLoader(@Nonnull @ParameterName(name="dir") Path dir, @Nullable @ParameterName(name="extensions") @NonnullElements Collection<String> extensions) throws IOException {
        this.log.debug("Loading rules from directory ({})", (Object)dir);
        this.rules = new ArrayList<TranscodingRule>();
        try (DirectoryStream<Path> dirstream = Files.newDirectoryStream(dir);){
            for (Path child : dirstream) {
                File file = child.toFile();
                if (file.isDirectory()) {
                    try {
                        this.rules.addAll(new TranscodingRuleLoader(child, extensions).getRules());
                    }
                    catch (IOException e) {
                        this.log.error("Failed to load rules from directory ({})", (Object)file, (Object)e);
                    }
                    continue;
                }
                if (extensions == null || extensions.isEmpty() || PredicateSupport.anyMatch(ext -> file.getName().endsWith((String)ext)).test(extensions)) {
                    this.log.debug("Loading rule from property set in file ({})", (Object)file);
                    try {
                        TranscodingRule rule = TranscodingRule.fromResource((Resource)new FileSystemResource(file));
                        if (rule.getMap().isEmpty()) {
                            this.log.info("Transcoding file {} contained no rules", (Object)child);
                            continue;
                        }
                        this.rules.add(rule);
                    }
                    catch (IOException e) {
                        this.log.error("Failed to load rule from file ({})", (Object)file, (Object)e);
                    }
                    continue;
                }
                this.log.debug("Ignoring file ({}) with non-matching extension", (Object)file);
            }
        }
    }

    public TranscodingRuleLoader(@Nonnull @ParameterName(name="dir") Path dir) throws IOException {
        this(dir, null);
    }

    public TranscodingRuleLoader(@Nonnull @ParameterName(name="maps") @NonnullElements Collection<Map<String, Object>> maps) {
        Constraint.isNotNull(maps, (String)"Input collection cannot be null");
        this.rules = maps.stream().map(m -> new TranscodingRule(m)).collect(Collectors.toList());
    }

    @Nonnull
    @NonnullElements
    public Collection<TranscodingRule> getRules() {
        return this.rules;
    }
}

