/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.transcoding.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.ext.spring.service.AbstractServiceableComponent;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.profile.logic.RelyingPartyIdPredicate;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class AttributeTranscoderRegistryImpl
extends AbstractServiceableComponent<AttributeTranscoderRegistry>
implements AttributeTranscoderRegistry {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeTranscoderRegistryImpl.class);
    @Nonnull
    @NonnullElements
    private final Map<String, Multimap<Class<?>, TranscodingRule>> transcodingRegistry = new HashMap();
    @Nonnull
    @NonnullElements
    private final Map<String, Map<Locale, String>> displayNameRegistry;
    @Nonnull
    @NonnullElements
    private final Map<String, Map<Locale, String>> descriptionRegistry;
    @Nonnull
    @NonnullElements
    private final Map<Class<?>, Function<?, String>> namingFunctionRegistry = new HashMap();

    public AttributeTranscoderRegistryImpl() {
        this.displayNameRegistry = new HashMap<String, Map<Locale, String>>();
        this.descriptionRegistry = new HashMap<String, Map<Locale, String>>();
    }

    @Nonnull
    public AttributeTranscoderRegistry getComponent() {
        return this;
    }

    public void setNamingRegistry(@Nullable @NonnullElements Collection<AttributeTranscoderRegistry.NamingFunction<?>> registry) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.namingFunctionRegistry.clear();
        if (registry != null) {
            registry.forEach(nf -> this.namingFunctionRegistry.put(nf.getType(), nf.getFunction()));
        }
    }

    public void setTranscoderRegistry(@Nonnull @NonnullElements Collection<TranscodingRule> mappings) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(mappings, (String)"Mappings cannot be null");
        this.transcodingRegistry.clear();
        for (TranscodingRule mapping : mappings) {
            String internalId = StringSupport.trimOrNull((String)((String)mapping.get("id", String.class)));
            if (internalId != null && !IdPAttribute.isInvalidId((String)internalId)) {
                Predicate<ProfileRequestContext> activationCondition;
                if (IdPAttribute.isDeprecatedId((String)internalId)) {
                    DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"TranscodingRule", (String)"TranscodingRule id with special characters ('\"%{})", null);
                }
                if ((activationCondition = this.buildActivationCondition(mapping.getMap())) != null) {
                    mapping.getMap().put("activationCondition", activationCondition);
                } else {
                    mapping.getMap().remove("activationCondition");
                }
                Collection<AttributeTranscoder<?>> transcoders = this.getAttributeTranscoders(mapping);
                for (AttributeTranscoder<?> transcoder : transcoders) {
                    this.addMapping(internalId, transcoder, mapping.getMap());
                }
                continue;
            }
            this.log.warn("Ignoring TranscodingRule with invalid id property: {}", (Object)internalId);
        }
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Map<Locale, String> getDisplayNames(@Nonnull IdPAttribute attribute) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)attribute, (String)"IdPAttribute cannot be null");
        if (this.displayNameRegistry.containsKey(attribute.getId())) {
            return this.displayNameRegistry.get(attribute.getId());
        }
        return Collections.emptyMap();
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Map<Locale, String> getDescriptions(@Nonnull IdPAttribute attribute) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)attribute, (String)"IdPAttribute cannot be null");
        if (this.descriptionRegistry.containsKey(attribute.getId())) {
            return this.descriptionRegistry.get(attribute.getId());
        }
        return Collections.emptyMap();
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Collection<TranscodingRule> getTranscodingRules(@Nonnull IdPAttribute from, @Nonnull Class<?> to) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)from, (String)"IdPAttribute cannot be null");
        Constraint.isNotNull(to, (String)"Target type cannot be null");
        Multimap<Class<?>, TranscodingRule> propertyCollections = this.transcodingRegistry.get(from.getId());
        if (propertyCollections == null) {
            return Collections.emptyList();
        }
        Class<?> effectiveType = this.getEffectiveType(to);
        if (effectiveType == null) {
            this.log.warn("Unsupported object type: {}", (Object)to.getClass().getName());
            return Collections.emptyList();
        }
        this.log.trace("Using rules for effective type {}", (Object)effectiveType.getName());
        return List.copyOf(propertyCollections.get(effectiveType));
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public <T> Collection<TranscodingRule> getTranscodingRules(@Nonnull T from) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Constraint.isNotNull(from, (String)"Input object cannot be null");
        Class<?> effectiveType = this.getEffectiveType(from.getClass());
        if (effectiveType == null) {
            this.log.warn("Unsupported object type: {}", (Object)from.getClass().getName());
            return Collections.emptyList();
        }
        this.log.trace("Using rules for effective type {}", (Object)effectiveType.getName());
        Function<?, String> namingFunction = this.namingFunctionRegistry.get(effectiveType);
        String id = namingFunction.apply(from);
        if (id != null) {
            Multimap<Class<?>, TranscodingRule> propertyCollections = this.transcodingRegistry.get(id);
            return propertyCollections != null ? List.copyOf(propertyCollections.get(effectiveType)) : Collections.emptyList();
        }
        this.log.warn("Object of type {} did not have a canonical name", (Object)from.getClass().getName());
        return Collections.emptyList();
    }

    @Nonnull
    @NonnullElements
    private Collection<AttributeTranscoder<?>> getAttributeTranscoders(@Nonnull TranscodingRule rule) {
        AttributeTranscoder transcoder = (AttributeTranscoder)rule.get("transcoder", AttributeTranscoder.class);
        if (transcoder != null) {
            return Collections.singletonList(transcoder);
        }
        String beanNames = (String)rule.get("transcoder", String.class);
        if (beanNames == null) {
            this.log.error("{} property is missing or of incorrect type", (Object)"transcoder");
            return Collections.emptyList();
        }
        ArrayList transcoders = new ArrayList();
        for (String id : StringSupport.stringToList((String)beanNames, (String)" ")) {
            try {
                transcoder = (AttributeTranscoder)this.getApplicationContext().getBean(id, AttributeTranscoder.class);
                transcoder.initialize();
                transcoders.add(transcoder);
            }
            catch (Exception e) {
                this.log.error("Unable to locate AttributeTranscoder bean named {}", (Object)id, (Object)e);
            }
        }
        return transcoders;
    }

    private void addMapping(@Nonnull @NotEmpty String id, @Nonnull AttributeTranscoder<?> transcoder, @Nonnull Map<String, Object> ruleset) {
        TranscodingRule copy = new TranscodingRule(ruleset);
        copy.getMap().put("transcoder", transcoder);
        Class type = transcoder.getEncodedType();
        String targetName = transcoder.getEncodedName(copy);
        if (targetName != null) {
            boolean encoder = (Boolean)copy.getOrDefault("encoder", Boolean.class, (Object)true);
            boolean decoder = (Boolean)copy.getOrDefault("decoder", Boolean.class, (Object)true);
            if (!encoder && !decoder) {
                this.log.warn("Transcoding rule for {} and type {} was disabled in both directions, ignoring", (Object)id, (Object)type.getName());
                return;
            }
            this.log.debug("Attribute mapping: {} {}-{} {} via {}", new Object[]{id, targetName, decoder ? "<" : "", encoder ? ">" : "", transcoder.getClass().getSimpleName()});
            copy.getMap().put("id", id);
            if (encoder) {
                ArrayListMultimap rulesetsForIdPName = this.transcodingRegistry.get(id);
                if (rulesetsForIdPName == null) {
                    rulesetsForIdPName = ArrayListMultimap.create();
                    this.transcodingRegistry.put(id, (Multimap<Class<?>, TranscodingRule>)rulesetsForIdPName);
                }
                rulesetsForIdPName.put((Object)type, (Object)copy);
            }
            if (decoder) {
                ArrayListMultimap rulesetsForEncodedName = this.transcodingRegistry.get(targetName);
                if (rulesetsForEncodedName == null) {
                    rulesetsForEncodedName = ArrayListMultimap.create();
                    this.transcodingRegistry.put(targetName, (Multimap<Class<?>, TranscodingRule>)rulesetsForEncodedName);
                }
                rulesetsForEncodedName.put((Object)type, (Object)copy);
            }
            if (this.displayNameRegistry.containsKey(id)) {
                this.displayNameRegistry.get(id).putAll(copy.getDisplayNames());
            } else {
                this.displayNameRegistry.put(id, new HashMap(copy.getDisplayNames()));
            }
            if (this.descriptionRegistry.containsKey(id)) {
                this.descriptionRegistry.get(id).putAll(copy.getDescriptions());
            } else {
                this.descriptionRegistry.put(id, new HashMap(copy.getDescriptions()));
            }
        } else {
            this.log.warn("Transcoding rule for {} and type {} did not produce an encoded name", (Object)id, (Object)type.getName());
        }
    }

    @Nullable
    private Predicate<ProfileRequestContext> buildActivationCondition(@Nonnull Map<String, Object> ruleset) {
        Predicate effectiveCondition = null;
        Object baseCondition = ruleset.get("activationCondition");
        if (baseCondition instanceof Predicate) {
            effectiveCondition = (Predicate)baseCondition;
        } else if (baseCondition instanceof String) {
            try {
                effectiveCondition = (Predicate)this.getApplicationContext().getBean((String)baseCondition, Predicate.class);
            }
            catch (Exception e) {
                this.log.error("Unable to locate Predicate bean named {}", baseCondition, (Object)e);
            }
        } else if (baseCondition != null) {
            this.log.error("{} property did not contain a Predicate object, ignored", (Object)"activationCondition");
        }
        RelyingPartyIdPredicate relyingPartyCondition = null;
        Object relyingParties = ruleset.get("relyingParties");
        if (relyingParties instanceof Collection) {
            relyingPartyCondition = new RelyingPartyIdPredicate((Collection)relyingParties);
        } else if (relyingParties instanceof String) {
            Collection parsed = StringSupport.normalizeStringCollection((Collection)StringSupport.stringToList((String)((String)relyingParties), (String)" "));
            relyingPartyCondition = new RelyingPartyIdPredicate(parsed);
        } else if (relyingParties != null) {
            this.log.error("{} property did not contain a Collection or String, ignored", (Object)"relyingParties");
        }
        if (effectiveCondition == null) {
            return relyingPartyCondition;
        }
        if (relyingPartyCondition != null) {
            return effectiveCondition.and(relyingPartyCondition);
        }
        return effectiveCondition;
    }

    @Nullable
    private Class<?> getEffectiveType(@Nonnull Class<?> inputType) {
        if (this.namingFunctionRegistry.containsKey(inputType)) {
            return inputType;
        }
        for (Class<?> candidate : this.namingFunctionRegistry.keySet()) {
            if (!candidate.isAssignableFrom(inputType)) continue;
            return candidate;
        }
        return null;
    }
}

