/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.transcoding.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.attribute.transcoding.impl.AttributeTranscoderRegistryImpl;
import net.shibboleth.idp.attribute.transcoding.impl.TranscodingRuleLoader;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.service.ServiceException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class AttributeRegistryServiceStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<ApplicationContext, ServiceableComponent<AttributeTranscoderRegistry>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeRegistryServiceStrategy.class);
    @Nullable
    @NonnullElements
    private Collection<AttributeTranscoderRegistry.NamingFunction<?>> namingRegistry;

    @Autowired
    public void setNamingRegistry(@Nullable @NonnullElements Collection<AttributeTranscoderRegistry.NamingFunction<?>> namingFunctions) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.namingRegistry = namingFunctions != null ? List.copyOf(namingFunctions) : Collections.emptyList();
    }

    @Override
    @Nullable
    public ServiceableComponent<AttributeTranscoderRegistry> apply(@Nullable ApplicationContext appContext) {
        Collection mappingBeans = appContext.getBeansOfType(TranscodingRule.class).values();
        Collection loaderBeans = appContext.getBeansOfType(TranscodingRuleLoader.class).values();
        ArrayList<TranscodingRule> holder = new ArrayList<TranscodingRule>();
        if (mappingBeans != null) {
            holder.addAll(mappingBeans);
        }
        if (loaderBeans != null) {
            loaderBeans.forEach(loader -> holder.addAll(loader.getRules()));
        }
        AttributeTranscoderRegistryImpl registry = new AttributeTranscoderRegistryImpl();
        registry.setId(this.getId());
        registry.setApplicationContext(appContext);
        registry.setNamingRegistry(this.namingRegistry);
        registry.setTranscoderRegistry(holder);
        try {
            registry.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new ServiceException("Unable to initialize attribute transcoder registry for " + appContext.getDisplayName(), (Exception)((Object)e));
        }
        return registry;
    }
}

