/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.transcoding.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.attribute.transcoding.impl.AttributeTranscoderRegistryImpl;
import net.shibboleth.idp.attribute.transcoding.impl.TranscodingRuleLoader;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.service.ServiceException;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class AttributeRegistryServiceStrategy
extends AbstractIdentifiableInitializableComponent
implements Function<ApplicationContext, ServiceableComponent<AttributeTranscoderRegistry>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeRegistryServiceStrategy.class);
    @Nullable
    @NotEmpty
    private String namingRegistry;

    public void setNamingRegistry(@Nullable @NotEmpty String beanName) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.namingRegistry = StringSupport.trimOrNull((String)beanName);
    }

    @Override
    @Nullable
    public ServiceableComponent<AttributeTranscoderRegistry> apply(@Nullable ApplicationContext appContext) {
        Map namingRegistryBean = (Map)appContext.getBean(this.namingRegistry, Map.class);
        Collection mappingBeans = appContext.getBeansOfType(TranscodingRule.class).values();
        Collection loaderBeans = appContext.getBeansOfType(TranscodingRuleLoader.class).values();
        ArrayList<TranscodingRule> holder = new ArrayList<TranscodingRule>();
        if (mappingBeans != null) {
            holder.addAll(mappingBeans);
        }
        if (loaderBeans != null) {
            loaderBeans.forEach(loader -> holder.addAll(loader.getRules()));
        }
        AttributeTranscoderRegistryImpl registry = new AttributeTranscoderRegistryImpl();
        registry.setId(this.getId());
        registry.setApplicationContext(appContext);
        registry.setNamingRegistry(namingRegistryBean);
        registry.setTranscoderRegistry(holder);
        try {
            registry.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new ServiceException("Unable to initialize attribute transcoder registry for " + appContext.getDisplayName(), (Exception)((Object)e));
        }
        return registry;
    }
}

