/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.impl;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.shibboleth.idp.attribute.DurablePairwiseIdStore;
import net.shibboleth.idp.attribute.PairwiseId;
import net.shibboleth.idp.attribute.PairwiseIdStore;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCPairwiseIdStore
extends AbstractInitializableComponent
implements DurablePairwiseIdStore {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JDBCPairwiseIdStore.class);
    @NonnullAfterInit
    private DataSource dataSource;
    @Nonnull
    private Duration queryTimeout;
    @NonNegative
    private int transactionRetry = 3;
    @Nonnull
    @NonnullElements
    private Collection<String> retryableErrors = Arrays.asList("23000", "23505");
    private boolean verifyDatabase = true;
    @Nonnull
    @NotEmpty
    private String tableName = "shibpid";
    @Nonnull
    @NotEmpty
    private String issuerColumn = "localEntity";
    @Nonnull
    @NotEmpty
    private String recipientColumn = "peerEntity";
    @Nonnull
    @NotEmpty
    private String principalNameColumn = "principalName";
    @Nonnull
    @NotEmpty
    private String sourceIdColumn = "localId";
    @Nonnull
    @NotEmpty
    private String persistentIdColumn = "persistentId";
    @Nonnull
    @NotEmpty
    private String peerProvidedIdColumn = "peerProvidedId";
    @Nonnull
    @NotEmpty
    private String creationTimeColumn = "creationDate";
    @Nonnull
    @NotEmpty
    private String deactivationTimeColumn = "deactivationDate";
    @NonnullAfterInit
    private String getByIssuedSelectSQL;
    @NonnullAfterInit
    private String getBySourceSelectSQL;
    @NonnullAfterInit
    private String insertSQL;
    @NonnullAfterInit
    private String deactivateSQL;
    @NonnullAfterInit
    private String attachSQL;
    @NonnullAfterInit
    private String deleteSQL;
    @Nullable
    private PairwiseIdStore initialValueStore;

    public JDBCPairwiseIdStore() {
        this.queryTimeout = Duration.ofSeconds(5L);
    }

    @NonnullAfterInit
    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(@Nonnull DataSource source) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSource = (DataSource)Constraint.isNotNull((Object)source, (String)"DataSource cannot be null");
    }

    @Nonnull
    public Duration getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(@Nonnull Duration timeout) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)timeout, (String)"Timeout cannot be null");
        Constraint.isFalse((boolean)timeout.isNegative(), (String)"Timeout cannot be negative");
        this.queryTimeout = timeout;
    }

    public int getTransactionRetries() {
        return this.transactionRetry;
    }

    public void setTransactionRetries(@NonNegative int retries) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.transactionRetry = Constraint.isGreaterThanOrEqual((int)0, (int)retries, (String)"Timeout must be greater than or equal to 0");
    }

    @Nonnull
    @NonnullElements
    public Collection<String> getRetryableErrors() {
        return this.retryableErrors;
    }

    public void setRetryableErrors(@Nullable @NonnullElements Collection<String> errors) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.retryableErrors = new ArrayList<String>(StringSupport.normalizeStringCollection(errors));
    }

    public boolean getVerifyDatabase() {
        return this.verifyDatabase;
    }

    public void setVerifyDatabase(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.verifyDatabase = flag;
    }

    public void setTableName(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.tableName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Table name cannot be null or empty");
    }

    public void setLocalEntityColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setPeerEntityColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.recipientColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setPrincipalNameColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.principalNameColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setSourceIdColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.sourceIdColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setPersistentIdColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.persistentIdColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setPeerProvidedIdColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.peerProvidedIdColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setCreateTimeColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.creationTimeColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setDeactivationTimeColumn(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.deactivationTimeColumn = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Column name cannot be null or empty");
    }

    public void setGetByIssuedSelectSQL(@Nonnull @NotEmpty String sql) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.getByIssuedSelectSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    public void setGetBySourceSelectSQL(@Nonnull @NotEmpty String sql) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.getBySourceSelectSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    public void setInsertSQL(@Nonnull @NotEmpty String sql) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.insertSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    public void setDeactivateSQL(@Nonnull @NotEmpty String sql) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.deactivateSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    public void setAttachSQL(@Nonnull @NotEmpty String sql) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attachSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    public void setDeleteSQL(@Nonnull @NotEmpty String sql) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.deleteSQL = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)sql), (String)"SQL statement cannot be null or empty");
    }

    @Nullable
    public PairwiseIdStore getInitialValueStore() {
        return this.initialValueStore;
    }

    public void setInitialValueStore(@Nullable PairwiseIdStore store) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.initialValueStore = store;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.dataSource) {
            throw new ComponentInitializationException("DataSource cannot be null");
        }
        if (this.getByIssuedSelectSQL == null) {
            this.getByIssuedSelectSQL = "SELECT * FROM " + this.tableName + " WHERE " + this.issuerColumn + "= ? AND " + this.recipientColumn + "= ? AND " + this.persistentIdColumn + "= ?";
        }
        if (this.getBySourceSelectSQL == null) {
            this.getBySourceSelectSQL = "SELECT * FROM " + this.tableName + " WHERE " + this.issuerColumn + "= ? AND " + this.recipientColumn + "= ? AND " + this.sourceIdColumn + "= ? AND (" + this.deactivationTimeColumn + " IS NULL OR " + this.deactivationTimeColumn + " = (SELECT MAX(" + this.deactivationTimeColumn + ") FROM " + this.tableName + " WHERE " + this.issuerColumn + "= ? AND " + this.recipientColumn + "= ? AND " + this.sourceIdColumn + "= ?)) ORDER BY " + this.creationTimeColumn + " DESC";
        }
        if (this.insertSQL == null) {
            this.insertSQL = "INSERT INTO " + this.tableName + " (" + this.issuerColumn + ", " + this.recipientColumn + ", " + this.persistentIdColumn + ", " + this.principalNameColumn + ", " + this.sourceIdColumn + ", " + this.peerProvidedIdColumn + ", " + this.creationTimeColumn + ", " + this.deactivationTimeColumn + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        }
        if (this.deactivateSQL == null) {
            this.deactivateSQL = "UPDATE " + this.tableName + " SET " + this.deactivationTimeColumn + "= ? WHERE " + this.issuerColumn + "= ? AND " + this.recipientColumn + "= ? AND " + this.persistentIdColumn + "= ?";
        }
        if (this.attachSQL == null) {
            this.attachSQL = "UPDATE " + this.tableName + " SET " + this.peerProvidedIdColumn + "= ? WHERE " + this.issuerColumn + "= ? AND " + this.recipientColumn + "= ? AND " + this.persistentIdColumn + "= ?";
        }
        if (this.deleteSQL == null) {
            this.deleteSQL = "DELETE FROM " + this.tableName + " WHERE " + this.issuerColumn + "= ?";
        }
        try {
            this.verifyDatabase();
            this.log.info("DataSource successfully verified");
        }
        catch (SQLException e) {
            if (this.verifyDatabase) {
                this.log.error("Exception verifying database", (Throwable)e);
                throw new ComponentInitializationException("The database was not reachable or was not defined with an appropriate table + primary key");
            }
            this.log.warn("The database was not reachable or was not defined with an appropriate table + primary key", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public PairwiseId getBySourceValue(@Nonnull PairwiseId pid, boolean allowCreate) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)pid, (String)"Input PairwiseId object cannot be null");
        Constraint.isNotEmpty((String)pid.getIssuerEntityID(), (String)"Issuer entityID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getRecipientEntityID(), (String)"Recipient entityID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getPrincipalName(), (String)"Principal name cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getSourceSystemId(), (String)"Source system ID cannot be null or empty");
        this.log.debug("Obtaining pairwise ID for source ID: {}", (Object)pid.getSourceSystemId());
        this.log.trace("Prepared statement: {}", (Object)this.getBySourceSelectSQL);
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)1, (Object)pid.getIssuerEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)2, (Object)pid.getRecipientEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)3, (Object)pid.getSourceSystemId());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)4, (Object)pid.getIssuerEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)5, (Object)pid.getRecipientEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)6, (Object)pid.getSourceSystemId());
        int retries = this.transactionRetry;
        while (true) {
            try (Connection dbConn = this.getConnection(false);){
                PairwiseId pairwiseId;
                PreparedStatement statement = dbConn.prepareStatement(this.getBySourceSelectSQL);
                statement.setQueryTimeout((int)this.queryTimeout.toSeconds());
                statement.setString(1, pid.getIssuerEntityID());
                statement.setString(2, pid.getRecipientEntityID());
                statement.setString(3, pid.getSourceSystemId());
                statement.setString(4, pid.getIssuerEntityID());
                statement.setString(5, pid.getRecipientEntityID());
                statement.setString(6, pid.getSourceSystemId());
                this.log.debug("Getting active and/or last inactive pairwise ID entry");
                List<PairwiseId> entries = this.buildIdentifierEntries(statement.executeQuery());
                if (entries != null && entries.size() > 0 && (entries.get(0).getDeactivationTime() == null || entries.get(0).getDeactivationTime().isAfter(Instant.now()))) {
                    dbConn.commit();
                    this.log.debug("Returning existing active pairwise ID: {}", (Object)entries.get(0).getPairwiseId());
                    pairwiseId = entries.get(0);
                    return pairwiseId;
                }
                if (!allowCreate) {
                    dbConn.commit();
                    this.log.debug("No existing pairwise ID and creation is not permitted by caller");
                    pairwiseId = null;
                    return pairwiseId;
                }
                pid.setCreationTime(Instant.now());
                PairwiseId retValue = pid;
                if ((entries == null || entries.size() == 0) && this.initialValueStore != null) {
                    this.log.debug("Issuing new pairwise ID using initial value store");
                    retValue = this.initialValueStore.getBySourceValue(pid, allowCreate);
                } else {
                    this.log.debug("Issuing new random pairwise ID");
                    retValue.setPairwiseId(UUID.randomUUID().toString());
                    if (entries != null && entries.size() > 0) {
                        retValue.setPeerProvidedId(entries.get(0).getPeerProvidedId());
                    }
                }
                this.store(retValue, dbConn);
                dbConn.commit();
                PairwiseId pairwiseId2 = retValue;
                return pairwiseId2;
            }
            catch (SQLException e) {
                boolean retry = false;
                for (String msg : this.retryableErrors) {
                    if (e.getSQLState() == null || !e.getSQLState().contains(msg)) continue;
                    this.log.warn("Caught retryable SQL exception", (Throwable)e);
                    retry = true;
                    break;
                }
                if (!retry) throw new IOException(e);
                if (--retries < 0) {
                    this.log.warn("Error retryable, but retry limit exceeded");
                    throw new IOException(e);
                }
                this.log.info("Retrying pairwise ID lookup/create operation");
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public PairwiseId getByIssuedValue(@Nonnull PairwiseId pid) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)pid, (String)"Input PairwiseId object cannot be null");
        Constraint.isNotEmpty((String)pid.getIssuerEntityID(), (String)"Issuer entityID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getRecipientEntityID(), (String)"Recipient entityID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getPairwiseId(), (String)"Pairwise ID cannot be null or empty");
        this.log.debug("Selecting previously issued pairwise ID entry", (Object)this.getByIssuedSelectSQL);
        this.log.trace("Prepared statement: {}", (Object)this.getByIssuedSelectSQL);
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)1, (Object)pid.getIssuerEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)2, (Object)pid.getRecipientEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)3, (Object)pid.getPairwiseId());
        try (Connection dbConn = this.getConnection(true);){
            PreparedStatement statement = dbConn.prepareStatement(this.getByIssuedSelectSQL);
            statement.setQueryTimeout((int)this.queryTimeout.toSeconds());
            statement.setString(1, pid.getIssuerEntityID());
            statement.setString(2, pid.getRecipientEntityID());
            statement.setString(3, pid.getPairwiseId());
            List<PairwiseId> entries = this.buildIdentifierEntries(statement.executeQuery());
            if (entries == null || entries.size() == 0) {
                PairwiseId pairwiseId = null;
                return pairwiseId;
            }
            if (entries.size() > 1) {
                this.log.error("More than one record found for a single persistent ID value");
            }
            if (entries.get(0).getDeactivationTime() != null && !entries.get(0).getDeactivationTime().isAfter(Instant.now())) {
                PairwiseId pairwiseId = null;
                return pairwiseId;
            }
            PairwiseId pairwiseId = entries.get(0);
            return pairwiseId;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public void deactivate(@Nonnull PairwiseId pid) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)pid, (String)"Input PairwiseId object cannot be null");
        Constraint.isNotEmpty((String)pid.getIssuerEntityID(), (String)"Issuer entityID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getRecipientEntityID(), (String)"Recipient entityID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getPairwiseId(), (String)"Pairwise ID cannot be null or empty");
        Timestamp deactivationTime = pid.getDeactivationTime() == null ? new Timestamp(System.currentTimeMillis()) : new Timestamp(pid.getDeactivationTime().toEpochMilli());
        this.log.debug("Deactivating pairwise ID {} as of {}", (Object)pid.getPairwiseId(), (Object)deactivationTime);
        this.log.trace("Prepared statement: {}", (Object)this.deactivateSQL);
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)1, (Object)deactivationTime);
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)2, (Object)pid.getIssuerEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)3, (Object)pid.getRecipientEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)4, (Object)pid.getPairwiseId());
        try (Connection dbConn = this.getConnection(true);){
            PreparedStatement statement = dbConn.prepareStatement(this.deactivateSQL);
            statement.setQueryTimeout((int)this.queryTimeout.toSeconds());
            statement.setTimestamp(1, deactivationTime);
            statement.setString(2, pid.getIssuerEntityID());
            statement.setString(3, pid.getRecipientEntityID());
            statement.setString(4, pid.getPairwiseId());
            int rowCount = statement.executeUpdate();
            if (rowCount != 1) {
                this.log.warn("Unexpected result, statement affected {} rows", (Object)rowCount);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public void attach(@Nonnull PairwiseId pid) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)pid, (String)"Input PairwiseId object cannot be null");
        Constraint.isNotEmpty((String)pid.getIssuerEntityID(), (String)"Issuer entityID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getRecipientEntityID(), (String)"Recipient entityID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getPairwiseId(), (String)"Pairwise ID cannot be null or empty");
        Constraint.isNotEmpty((String)pid.getPeerProvidedId(), (String)"Peer-provided ID cannot be null or empty");
        this.log.debug("Attaching peer-provided ID {} to pairwise id {}", (Object)pid.getPeerProvidedId(), (Object)pid.getPairwiseId());
        this.log.trace("Prepared statement: {}", (Object)this.attachSQL);
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)1, (Object)pid.getPeerProvidedId());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)2, (Object)pid.getIssuerEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)3, (Object)pid.getRecipientEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)4, (Object)pid.getPairwiseId());
        try (Connection dbConn = this.getConnection(true);){
            PreparedStatement statement = dbConn.prepareStatement(this.attachSQL);
            statement.setQueryTimeout((int)this.queryTimeout.toSeconds());
            statement.setString(1, pid.getPeerProvidedId());
            statement.setString(2, pid.getIssuerEntityID());
            statement.setString(3, pid.getRecipientEntityID());
            statement.setString(4, pid.getPairwiseId());
            int rowCount = statement.executeUpdate();
            if (rowCount != 1) {
                this.log.warn("Unexpected result, statement affected {} rows", (Object)rowCount);
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    void store(@Nonnull PairwiseId entry, @Nonnull Connection dbConn) throws SQLException {
        this.log.debug("Storing new pairwise ID entry");
        if (StringSupport.trimOrNull((String)entry.getIssuerEntityID()) == null || StringSupport.trimOrNull((String)entry.getRecipientEntityID()) == null || StringSupport.trimOrNull((String)entry.getPairwiseId()) == null || StringSupport.trimOrNull((String)entry.getPrincipalName()) == null || StringSupport.trimOrNull((String)entry.getSourceSystemId()) == null || entry.getCreationTime() == null) {
            throw new SQLException("Required field was empty/null, store operation not possible");
        }
        this.log.trace("Prepared statement: {}", (Object)this.insertSQL);
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)1, (Object)entry.getIssuerEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)2, (Object)entry.getRecipientEntityID());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)3, (Object)entry.getPairwiseId());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)4, (Object)entry.getPrincipalName());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)5, (Object)entry.getSourceSystemId());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)6, (Object)entry.getPeerProvidedId());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)7, (Object)entry.getCreationTime());
        this.log.trace("Setting prepared statement parameter {}: {}", (Object)8, (Object)entry.getDeactivationTime());
        PreparedStatement statement = dbConn.prepareStatement(this.insertSQL);
        statement.setQueryTimeout((int)this.queryTimeout.toSeconds());
        statement.setString(1, entry.getIssuerEntityID());
        statement.setString(2, entry.getRecipientEntityID());
        statement.setString(3, entry.getPairwiseId());
        statement.setString(4, entry.getPrincipalName());
        statement.setString(5, entry.getSourceSystemId());
        if (entry.getPeerProvidedId() != null) {
            statement.setString(6, entry.getPeerProvidedId());
        } else {
            statement.setNull(6, 12);
        }
        statement.setTimestamp(7, new Timestamp(entry.getCreationTime().toEpochMilli()));
        if (entry.getDeactivationTime() != null) {
            statement.setTimestamp(8, new Timestamp(entry.getDeactivationTime().toEpochMilli()));
        } else {
            statement.setNull(8, 93);
        }
        statement.executeUpdate();
    }

    @Nonnull
    private Connection getConnection(boolean autoCommit) throws SQLException {
        Connection conn = this.dataSource.getConnection();
        conn.setAutoCommit(autoCommit);
        conn.setTransactionIsolation(8);
        return conn;
    }

    private void verifyDatabase() throws SQLException {
        Connection conn;
        boolean keyMissing;
        String uuid;
        block22: {
            uuid = UUID.randomUUID().toString();
            PairwiseId newEntry = new PairwiseId();
            newEntry.setIssuerEntityID("http://dummy.com/idp/" + uuid);
            newEntry.setRecipientEntityID("http://dummy.com/sp/" + uuid);
            newEntry.setSourceSystemId("dummy");
            newEntry.setPrincipalName("dummy");
            newEntry.setCreationTime(Instant.now());
            newEntry.setPairwiseId(uuid);
            try (Connection conn2 = this.getConnection(true);){
                this.store(newEntry, conn2);
            }
            keyMissing = false;
            try {
                conn = this.getConnection(true);
                try {
                    this.store(newEntry, conn);
                    keyMissing = true;
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
            catch (SQLException e) {
                if (e.getSQLState() == null || this.retryableErrors.contains(e.getSQLState())) break block22;
                this.log.warn("Duplicate insert failed as required with SQL State '{}', ensure this value is configured as a retryable error", (Object)e.getSQLState());
            }
        }
        conn = this.getConnection(true);
        try {
            PreparedStatement statement = conn.prepareStatement(this.deleteSQL);
            statement.setQueryTimeout((int)this.queryTimeout.toSeconds());
            statement.setString(1, "http://dummy.com/idp/" + uuid);
            statement.executeUpdate();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        if (keyMissing) {
            throw new SQLException("Duplicate insertion succeeded, primary key missing from table");
        }
    }

    @Nonnull
    @NonnullElements
    @Live
    private List<PairwiseId> buildIdentifierEntries(@Nonnull ResultSet resultSet) throws SQLException {
        ArrayList<PairwiseId> entries = new ArrayList<PairwiseId>();
        while (resultSet.next()) {
            PairwiseId entry = new PairwiseId();
            entry.setIssuerEntityID(resultSet.getString(this.issuerColumn));
            entry.setRecipientEntityID(resultSet.getString(this.recipientColumn));
            entry.setPrincipalName(resultSet.getString(this.principalNameColumn));
            entry.setPairwiseId(resultSet.getString(this.persistentIdColumn));
            entry.setSourceSystemId(resultSet.getString(this.sourceIdColumn));
            entry.setPeerProvidedId(resultSet.getString(this.peerProvidedIdColumn));
            Timestamp ts = resultSet.getTimestamp(this.creationTimeColumn);
            if (ts != null) {
                entry.setCreationTime(Instant.ofEpochMilli(ts.getTime()));
            }
            if ((ts = resultSet.getTimestamp(this.deactivationTimeColumn)) != null) {
                entry.setDeactivationTime(Instant.ofEpochMilli(ts.getTime()));
            }
            entries.add(entry);
            this.log.trace("Entry {} added to results", (Object)entry.toString());
        }
        return entries;
    }
}

