/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.impl;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.PairwiseId;
import net.shibboleth.idp.attribute.PairwiseIdStore;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.codec.Base32Support;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.DecodingException;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputedPairwiseIdStore
extends AbstractInitializableComponent
implements PairwiseIdStore {
    @Nonnull
    @NotEmpty
    public static final String WILDCARD_OVERRIDE = "*";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ComputedPairwiseIdStore.class);
    @NonnullAfterInit
    private byte[] salt;
    @Nonnull
    @NotEmpty
    private String algorithm = "SHA";
    @Nonnull
    private Encoding encoding = Encoding.BASE64;
    @Nonnull
    private Map<String, Map<String, String>> exceptionMap = Collections.emptyMap();

    @NonnullAfterInit
    public byte[] getSalt() {
        return this.salt;
    }

    public void setSalt(@Nullable byte[] newValue) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (newValue != null && newValue.length > 0) {
            this.salt = newValue;
        }
    }

    public void setSalt(@Nullable String newValue) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (newValue != null && !newValue.isEmpty()) {
            this.salt = newValue.getBytes();
        }
    }

    public void setEncodedSalt(@Nullable String newValue) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (newValue != null && !newValue.isEmpty()) {
            try {
                this.salt = Base64Support.decode((String)newValue);
            }
            catch (DecodingException e) {
                throw new IllegalArgumentException("Can not decode base64 encoded salt value", e);
            }
        }
    }

    @Nonnull
    @NotEmpty
    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(@Nonnull @NotEmpty String alg) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.algorithm = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)alg), (String)"Digest algorithm cannot be null or empty");
    }

    @Nonnull
    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(@Nonnull Encoding enc) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.encoding = (Encoding)((Object)Constraint.isNotNull((Object)((Object)enc), (String)"Encoding cannot be null"));
    }

    public void setExceptionMap(@Nullable @NotEmpty Map<String, Map<String, String>> map) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (map == null) {
            this.exceptionMap = Collections.emptyMap();
        } else {
            this.exceptionMap = new HashMap<String, Map<String, String>>(map.size());
            for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
                String principal = StringSupport.trimOrNull((String)entry.getKey());
                if (principal == null || entry.getValue() == null) continue;
                HashMap<String, String> overrides = new HashMap<String, String>(entry.getValue().size());
                for (Map.Entry<String, String> subentry : entry.getValue().entrySet()) {
                    String rpname = StringSupport.trimOrNull((String)subentry.getKey());
                    if (rpname == null) continue;
                    String override = StringSupport.trimOrNull((String)subentry.getValue());
                    overrides.put(rpname, override);
                }
                this.exceptionMap.put(principal, overrides);
            }
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.getSalt()) {
            throw new ComponentInitializationException("Salt cannot be null");
        }
        if (this.getSalt().length < 16) {
            throw new ComponentInitializationException("Salt must be at least 16 bytes in size");
        }
    }

    @Nullable
    public PairwiseId getBySourceValue(@Nonnull PairwiseId pid, boolean allowCreate) throws IOException {
        block6: {
            ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
            Constraint.isNotNull((Object)pid, (String)"Input PairwiseId object cannot be null");
            Constraint.isNotEmpty((String)pid.getRecipientEntityID(), (String)"Recipient entityID cannot be null or empty");
            Constraint.isNotEmpty((String)pid.getPrincipalName(), (String)"Principal name cannot be null or empty");
            Constraint.isNotEmpty((String)pid.getSourceSystemId(), (String)"Source system ID cannot be null or empty");
            byte[] effectiveSalt = this.getEffectiveSalt(pid.getPrincipalName(), pid.getRecipientEntityID());
            if (effectiveSalt == null) {
                this.log.warn("Pairwise ID generation blocked for relying party ({})", (Object)pid.getRecipientEntityID());
                throw new IOException("Pairwise ID generation blocked by exception rule");
            }
            try {
                MessageDigest md = MessageDigest.getInstance(this.algorithm);
                md.update(pid.getRecipientEntityID().getBytes());
                md.update((byte)33);
                md.update(pid.getSourceSystemId().getBytes());
                md.update((byte)33);
                if (this.encoding == Encoding.BASE32) {
                    pid.setPairwiseId(Base32Support.encode((byte[])md.digest(effectiveSalt), (boolean)false));
                    break block6;
                }
                if (this.encoding == Encoding.BASE64) {
                    pid.setPairwiseId(Base64Support.encode((byte[])md.digest(effectiveSalt), (boolean)false));
                    break block6;
                }
                throw new IOException("Desired encoding was not recognized, unable to compute ID");
            }
            catch (NoSuchAlgorithmException e) {
                this.log.error("Digest algorithm {} is not supported", (Object)this.algorithm);
                throw new IOException("Digest algorithm was not supported, unable to compute ID", e);
            }
            catch (EncodingException e) {
                this.log.error("Unable to {} encode digest", (Object)this.encoding);
                throw new IOException("Unable to either base64 or base32 encode digest, unable to compute ID", e);
            }
        }
        return pid;
    }

    @Nullable
    private byte[] getEffectiveSalt(@Nonnull @NotEmpty String principalName, @Nonnull @NotEmpty String relyingPartyId) {
        Map<String, String> override = this.exceptionMap.get(principalName);
        if (override == null) {
            override = this.exceptionMap.get(WILDCARD_OVERRIDE);
        }
        if (override != null) {
            if (override.containsKey(relyingPartyId)) {
                String s = override.get(relyingPartyId);
                if (s != null) {
                    this.log.debug("Overriding salt for principal '{}' and relying party '{}'", (Object)principalName, (Object)relyingPartyId);
                    return s.getBytes();
                }
                this.log.debug("Blocked generation of ID for principal '{}' for relying party '{}'", (Object)principalName, (Object)relyingPartyId);
                return null;
            }
            if (override.containsKey(WILDCARD_OVERRIDE)) {
                String s = override.get(WILDCARD_OVERRIDE);
                if (s != null) {
                    this.log.debug("Overriding salt for principal '{}' and relying party '{}'", (Object)principalName, (Object)relyingPartyId);
                    return s.getBytes();
                }
                this.log.debug("Blocked generation of ID for principal '{}' for relying party '{}'", (Object)principalName, (Object)relyingPartyId);
                return null;
            }
        }
        return this.salt;
    }

    public static enum Encoding {
        BASE64,
        BASE32;

    }
}

