/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.filter.AttributeFilter;
import net.shibboleth.idp.attribute.filter.AttributeFilterException;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.collection.CollectionSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProxiedRequesterContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class AttributeFilterContext
extends BaseContext {
    @Nonnull
    private Direction direction;
    @Nonnull
    private Map<String, IdPAttribute> prefilteredAttributes = new HashMap<String, IdPAttribute>();
    @Nonnull
    private Map<String, IdPAttribute> filteredAttributes = new HashMap<String, IdPAttribute>();
    @Nullable
    private MetadataResolver metadataResolver;
    @Nullable
    private String principal;
    @Nullable
    private String attributeIssuerID;
    @Nullable
    private String attributeRecipientID;
    @Nullable
    private String attributeRecipientGroupID;
    @Nullable
    private SAMLMetadataContext issuerMetadataContext;
    @Nullable
    private SAMLMetadataContext requesterMetadataContext;
    @Nullable
    private ProxiedRequesterContext proxiedRequesterContext;
    @Nullable
    private Function<AttributeFilterContext, SAMLMetadataContext> issuerMetadataContextLookupStrategy;
    @Nullable
    private Function<AttributeFilterContext, SAMLMetadataContext> requesterMetadataContextLookupStrategy;
    @Nullable
    private Function<AttributeFilterContext, ProxiedRequesterContext> proxiedRequesterContextLookupStrategy;

    public AttributeFilterContext() {
        this.direction = Direction.OUTBOUND;
    }

    @Nonnull
    public Direction getDirection() {
        return this.direction;
    }

    @Nonnull
    public AttributeFilterContext setDirection(@Nonnull Direction dir) {
        this.direction = (Direction)((Object)Constraint.isNotNull((Object)((Object)dir), (String)"Direction cannot be null"));
        return this;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Map<String, IdPAttribute> getPrefilteredIdPAttributes() {
        return this.prefilteredAttributes;
    }

    @Nonnull
    public AttributeFilterContext setPrefilteredIdPAttributes(@Nullable @NonnullElements Collection<IdPAttribute> attributes) {
        this.prefilteredAttributes = attributes != null ? attributes.stream().collect(Collectors.toUnmodifiableMap(IdPAttribute::getId, e -> e, CollectionSupport.warningMergeFunction((String)"AttrtibuteFilterContextPrefiltered", (boolean)true))) : Collections.emptyMap();
        return this;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Map<String, IdPAttribute> getFilteredIdPAttributes() {
        return this.filteredAttributes;
    }

    @Nonnull
    public AttributeFilterContext setFilteredIdPAttributes(@Nullable @NonnullElements Collection<IdPAttribute> attributes) {
        this.filteredAttributes = attributes != null ? attributes.stream().collect(Collectors.toUnmodifiableMap(IdPAttribute::getId, e -> e, CollectionSupport.warningMergeFunction((String)"AttrtibuteFilterContextFiltered", (boolean)true))) : Collections.emptyMap();
        return this;
    }

    @Nullable
    public MetadataResolver getMetadataResolver() {
        return this.metadataResolver;
    }

    @Nonnull
    public AttributeFilterContext setMetadataResolver(@Nullable MetadataResolver resolver) {
        this.metadataResolver = resolver;
        return this;
    }

    @Nullable
    public String getPrincipal() {
        return this.principal;
    }

    @Nonnull
    public AttributeFilterContext setPrincipal(@Nullable String who) {
        this.principal = who;
        return this;
    }

    @Nullable
    public String getAttributeIssuerID() {
        return this.attributeIssuerID;
    }

    @Nonnull
    public AttributeFilterContext setAttributeIssuerID(@Nullable String value) {
        this.attributeIssuerID = value;
        return this;
    }

    @Nullable
    public String getAttributeRecipientID() {
        return this.attributeRecipientID;
    }

    @Nonnull
    public AttributeFilterContext setAttributeRecipientID(@Nullable String value) {
        this.attributeRecipientID = value;
        return this;
    }

    @Nullable
    public String getAttributeRecipientGroupID() {
        return this.attributeRecipientGroupID;
    }

    @Nonnull
    public AttributeFilterContext setAttributeRecipientGroupID(@Nullable String value) {
        this.attributeRecipientGroupID = value;
        return this;
    }

    @Nullable
    public Function<AttributeFilterContext, SAMLMetadataContext> getRequesterMetadataContextLookupStrategy() {
        return this.requesterMetadataContextLookupStrategy;
    }

    @Nonnull
    public AttributeFilterContext setIssuerMetadataContextLookupStrategy(@Nullable Function<AttributeFilterContext, SAMLMetadataContext> strategy) {
        this.issuerMetadataContextLookupStrategy = strategy;
        return this;
    }

    @Nullable
    public Function<AttributeFilterContext, SAMLMetadataContext> getIssuerMetadataContextLookupStrategy() {
        return this.issuerMetadataContextLookupStrategy;
    }

    @Nonnull
    public AttributeFilterContext setRequesterMetadataContextLookupStrategy(@Nullable Function<AttributeFilterContext, SAMLMetadataContext> strategy) {
        this.requesterMetadataContextLookupStrategy = strategy;
        return this;
    }

    @Nullable
    public Function<AttributeFilterContext, ProxiedRequesterContext> getProxiedRequesterContextLookupStrategy() {
        return this.proxiedRequesterContextLookupStrategy;
    }

    @Nonnull
    public AttributeFilterContext setProxiedRequesterContextLookupStrategy(@Nullable Function<AttributeFilterContext, ProxiedRequesterContext> strategy) {
        this.proxiedRequesterContextLookupStrategy = strategy;
        return this;
    }

    @Nullable
    public SAMLMetadataContext getIssuerMetadataContext() {
        if (null == this.issuerMetadataContext && null != this.issuerMetadataContextLookupStrategy) {
            this.issuerMetadataContext = this.issuerMetadataContextLookupStrategy.apply(this);
        }
        return this.issuerMetadataContext;
    }

    @Nullable
    public SAMLMetadataContext getRequesterMetadataContext() {
        if (null == this.requesterMetadataContext && null != this.requesterMetadataContextLookupStrategy) {
            this.requesterMetadataContext = this.requesterMetadataContextLookupStrategy.apply(this);
        }
        return this.requesterMetadataContext;
    }

    @Nullable
    public ProxiedRequesterContext getProxiedRequesterContext() {
        if (null == this.proxiedRequesterContext && null != this.proxiedRequesterContextLookupStrategy) {
            this.proxiedRequesterContext = this.proxiedRequesterContextLookupStrategy.apply(this);
        }
        return this.proxiedRequesterContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterAttributes(@Nonnull ReloadableService<AttributeFilter> attributeFilterService) {
        Logger log = LoggerFactory.getLogger(AttributeFilterContext.class);
        ServiceableComponent component = null;
        try {
            component = attributeFilterService.getServiceableComponent();
            if (null == component) {
                log.error("Error filtering attributes: Invalid Attribute filter configuration");
            } else {
                ((AttributeFilter)component.getComponent()).filterAttributes(this);
            }
        }
        catch (AttributeFilterException e) {
            log.error("Error filtering attributes", (Throwable)((Object)e));
        }
        finally {
            if (null != component) {
                component.unpinComponent();
            }
        }
    }

    public static enum Direction {
        INBOUND,
        OUTBOUND;

    }
}

