/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.filter.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;

@NotThreadSafe
public final class AttributeFilterWorkContext
extends BaseContext {
    private final Map<String, Set<IdPAttributeValue>> permittedValues = new HashMap<String, Set<IdPAttributeValue>>();
    private final Map<String, Set<IdPAttributeValue>> deniedValues = new HashMap<String, Set<IdPAttributeValue>>();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, Set<IdPAttributeValue>> getPermittedIdPAttributeValues() {
        return Collections.unmodifiableMap(this.permittedValues);
    }

    public void addPermittedIdPAttributeValues(@Nonnull @NotEmpty String attributeId, @Nullable @NonnullElements Collection<IdPAttributeValue> attributeValues) {
        AttributeFilterContext parent = (AttributeFilterContext)this.getParent();
        Map<String, IdPAttribute> prefilteredAttributes = parent.getPrefilteredIdPAttributes();
        String trimmedAttributeId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)attributeId), (String)"Attribute ID can not be null or empty");
        Constraint.isTrue((boolean)prefilteredAttributes.containsKey(trimmedAttributeId), (String)("no attribute with ID " + trimmedAttributeId + " exists in the pre-filtered attribute set"));
        if (attributeValues == null || attributeValues.isEmpty()) {
            return;
        }
        Set<IdPAttributeValue> permittedAttributeValues = this.permittedValues.get(trimmedAttributeId);
        if (permittedAttributeValues == null) {
            permittedAttributeValues = new LinkedHashSet<IdPAttributeValue>();
            this.permittedValues.put(trimmedAttributeId, permittedAttributeValues);
        }
        for (IdPAttributeValue value : attributeValues) {
            Constraint.isNotNull((Object)value, (String)"non null value cannot be added to permitted list");
            if (!prefilteredAttributes.get(trimmedAttributeId).getValues().contains(value)) {
                throw new IllegalArgumentException("permitted value is not a current value of attribute " + trimmedAttributeId);
            }
            if (permittedAttributeValues.contains(value)) continue;
            permittedAttributeValues.add(value);
        }
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, Set<IdPAttributeValue>> getDeniedAttributeValues() {
        return Collections.unmodifiableMap(this.deniedValues);
    }

    public void addDeniedIdPAttributeValues(@Nonnull @NotEmpty String attributeId, @Nullable @NonnullElements Collection<IdPAttributeValue> attributeValues) {
        AttributeFilterContext parent = (AttributeFilterContext)this.getParent();
        Map<String, IdPAttribute> prefilteredAttributes = parent.getPrefilteredIdPAttributes();
        String trimmedAttributeId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)attributeId), (String)"Attribute ID can not be null or empty");
        Constraint.isTrue((boolean)prefilteredAttributes.containsKey(trimmedAttributeId), (String)("No attribute with ID " + trimmedAttributeId + " exists in the pre-filtered attribute set"));
        if (attributeValues == null || attributeValues.isEmpty()) {
            return;
        }
        Set<IdPAttributeValue> deniedAttributeValues = this.deniedValues.get(trimmedAttributeId);
        if (deniedAttributeValues == null) {
            deniedAttributeValues = new LinkedHashSet<IdPAttributeValue>();
            this.deniedValues.put(trimmedAttributeId, deniedAttributeValues);
        }
        for (IdPAttributeValue value : attributeValues) {
            Constraint.isNotNull((Object)value, (String)"non null value cannot be added to denied list");
            if (!prefilteredAttributes.get(trimmedAttributeId).getValues().contains(value)) {
                throw new IllegalArgumentException("denied value is not a current value of attribute " + trimmedAttributeId);
            }
            if (deniedAttributeValues.contains(value)) continue;
            deniedAttributeValues.add(value);
        }
    }
}

