/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.transcoding;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.springframework.core.io.Resource;

public final class TranscodingRule {
    @Nonnull
    @NonnullElements
    private final Map<String, Object> rule;
    @Nonnull
    @NonnullElements
    private Map<Locale, String> displayNames;
    @Nonnull
    @NonnullElements
    private Map<Locale, String> descriptions;

    public TranscodingRule(@Nonnull @ParameterName(name="map") @NonnullElements Map<String, Object> map) {
        this.rule = new HashMap<String, Object>(map);
        this.processDisplayNames();
        this.processDescriptions();
    }

    public TranscodingRule(@Nonnull @ParameterName(name="properties") @NonnullElements Properties properties) {
        this.rule = new HashMap<String, Object>(properties.size());
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            if (k instanceof String && v != null) {
                this.rule.put((String)k, v);
            }
        }));
        this.processDisplayNames();
        this.processDescriptions();
    }

    @Nonnull
    @NonnullElements
    @Live
    public Map<String, Object> getMap() {
        return this.rule;
    }

    @Nullable
    public <T> T get(@Nonnull @NotEmpty String key, @Nonnull Class<T> type) {
        Object value = this.rule.get(key);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        if (type == Boolean.class && value instanceof String) {
            return type.cast(Boolean.valueOf((String)value));
        }
        return null;
    }

    @Nullable
    public <T> T getOrDefault(@Nonnull @NotEmpty String key, @Nonnull Class<T> type, @Nullable T defValue) {
        T value = this.get(key, type);
        if (value != null) {
            return value;
        }
        return defValue;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Map<Locale, String> getDisplayNames() {
        return this.displayNames;
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public Map<Locale, String> getDescriptions() {
        return this.descriptions;
    }

    private void processDisplayNames() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet<Locale> inserted = new HashSet<Locale>();
        for (Map.Entry<String, Object> entry : this.rule.entrySet()) {
            if (!(entry.getValue() instanceof String) || !entry.getKey().startsWith("displayName")) continue;
            String lang = StringSupport.trimOrNull((String)entry.getKey().substring("displayName".length()));
            Locale locale = null;
            if (lang == null) {
                locale = Locale.getDefault();
            } else if (lang.startsWith(".")) {
                locale = Locale.forLanguageTag(lang.substring(1));
            }
            if (locale == null || !inserted.add(locale)) continue;
            builder.put((Object)locale, (Object)((String)entry.getValue()));
        }
        this.displayNames = builder.build();
    }

    private void processDescriptions() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashSet<Locale> inserted = new HashSet<Locale>();
        for (Map.Entry<String, Object> entry : this.rule.entrySet()) {
            if (!(entry.getValue() instanceof String) || !entry.getKey().startsWith("description")) continue;
            String lang = StringSupport.trimOrNull((String)entry.getKey().substring("description".length()));
            Locale locale = null;
            if (lang == null) {
                locale = Locale.getDefault();
            } else if (lang.startsWith(".")) {
                locale = Locale.forLanguageTag(lang.substring(1));
            }
            if (locale == null || !inserted.add(locale)) continue;
            builder.put((Object)locale, (Object)((String)entry.getValue()));
        }
        this.descriptions = builder.build();
    }

    @Nonnull
    public static TranscodingRule fromResource(@Nonnull @ParameterName(name="resource") Resource resource) throws IOException {
        Properties props = new Properties();
        try (InputStream is = resource.getInputStream();){
            props.load(is);
        }
        return new TranscodingRule(props);
    }
}

