/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.transcoding;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAttributeTranscoder<T>
extends AbstractInitializableComponent
implements AttributeTranscoder<T> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractAttributeTranscoder.class);
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = Predicates.alwaysTrue();

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition cannot be null");
    }

    @Override
    @Nullable
    public T encode(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull Class<? extends T> to, @Nonnull TranscodingRule rule) throws AttributeEncodingException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Constraint.isNotNull((Object)attribute, (String)"Attribute to encode cannot be null");
        if (!this.checkActivation(profileRequestContext, rule)) {
            return null;
        }
        return this.doEncode(profileRequestContext, attribute, to, rule);
    }

    @Override
    @Nullable
    public IdPAttribute decode(@Nullable ProfileRequestContext profileRequestContext, @Nonnull T input, @Nonnull TranscodingRule rule) throws AttributeDecodingException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Constraint.isNotNull(input, (String)"Attribute to decode cannot be null");
        if (!this.checkActivation(profileRequestContext, rule)) {
            return null;
        }
        IdPAttribute attribute = this.doDecode(profileRequestContext, input, rule);
        attribute.setDisplayNames(rule.getDisplayNames());
        attribute.setDisplayDescriptions(rule.getDescriptions());
        return attribute;
    }

    @Nullable
    protected abstract T doEncode(@Nullable ProfileRequestContext var1, @Nonnull IdPAttribute var2, @Nonnull Class<? extends T> var3, @Nonnull TranscodingRule var4) throws AttributeEncodingException;

    @Nullable
    protected abstract IdPAttribute doDecode(@Nullable ProfileRequestContext var1, @Nonnull T var2, @Nonnull TranscodingRule var3) throws AttributeDecodingException;

    private boolean checkActivation(@Nullable ProfileRequestContext profileRequestContext, @Nonnull TranscodingRule rule) {
        if (!this.activationCondition.test(profileRequestContext)) {
            this.log.debug("Transcoder inactive");
            return false;
        }
        Predicate condition = rule.get("activationCondition", Predicate.class);
        if (condition != null && !condition.test(profileRequestContext)) {
            this.log.debug("Transcoder inactive");
            return false;
        }
        return true;
    }
}

