/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

@ThreadSafe
public final class ScopedStringAttributeValue
extends StringAttributeValue {
    private final String scope;

    public ScopedStringAttributeValue(@Nonnull @ParameterName(name="attributeValue") @NotEmpty String attributeValue, @Nonnull @ParameterName(name="valueScope") @NotEmpty String valueScope) {
        super(attributeValue);
        this.scope = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)valueScope), (String)"Scope cannot be null or empty");
    }

    @Override
    public Object getNativeValue() {
        return new Pair((Object)this.getValue(), (Object)this.scope);
    }

    @Nonnull
    @NotEmpty
    public final String getScope() {
        return this.scope;
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getDisplayValue() {
        return this.getValue() + "@" + this.scope;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScopedStringAttributeValue)) {
            return false;
        }
        ScopedStringAttributeValue otherValue = (ScopedStringAttributeValue)obj;
        return Objects.equals(this.getValue(), otherValue.getValue()) && Objects.equals(this.scope, otherValue.scope);
    }

    @Override
    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getValue(), this.scope});
    }

    @Override
    @Nonnull
    @NotEmpty
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.getValue()).add("scope", (Object)this.scope).toString();
    }

    public static IdPAttributeValue valueOf(@Nullable String value, @Nonnull @NotEmpty String scope) {
        if (value == null) {
            return EmptyAttributeValue.NULL;
        }
        if (value.length() == 0) {
            return EmptyAttributeValue.ZERO_LENGTH;
        }
        return new ScopedStringAttributeValue(value, scope);
    }
}

