/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.commons.codec.binary.Hex;

public final class ByteAttributeValue
implements IdPAttributeValue {
    private final byte[] value;

    public ByteAttributeValue(@Nonnull @ParameterName(name="attributeValue") byte[] attributeValue) {
        this.value = Constraint.isNotEmpty((byte[])attributeValue, (String)"Attribute value cannot be null or empty");
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public Object getNativeValue() {
        return this.value;
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getDisplayValue() {
        return this.toHex();
    }

    @Nonnull
    public String toHex() {
        return Hex.encodeHexString((byte[])this.value);
    }

    @Nonnull
    public String toBase64() throws EncodingException {
        return Base64Support.encode((byte[])this.value, (boolean)false);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ByteAttributeValue)) {
            return false;
        }
        ByteAttributeValue other = (ByteAttributeValue)obj;
        return Arrays.equals(other.value, this.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
    }

    @Nonnull
    public static IdPAttributeValue valueOf(@Nullable byte[] value) {
        if (value == null) {
            return EmptyAttributeValue.NULL;
        }
        if (value.length == 0) {
            return EmptyAttributeValue.ZERO_LENGTH;
        }
        return new ByteAttributeValue(value);
    }
}

