/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.EmptyAttributeValue;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class IdPAttribute
implements Comparable<IdPAttribute>,
Cloneable {
    private static final Predicate<String> SPACE_CONTAINING = Pattern.compile("\\S*").asMatchPredicate();
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(IdPAttribute.class);
    @Nonnull
    private static Function<Map.Entry<Locale, String>, Map.Entry<Locale, String>> filterEntry = new Function<Map.Entry<Locale, String>, Map.Entry<Locale, String>>(){

        @Override
        public Map.Entry<Locale, String> apply(final Map.Entry<Locale, String> t) {
            return new Map.Entry<Locale, String>(){
                private String val;
                private Locale key;
                {
                    this.val = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)((String)t.getValue())), (String)"Values must not be null");
                    this.key = (Locale)Constraint.isNotNull((Object)((Locale)t.getKey()), (String)"Key must not be null");
                }

                @Override
                public Locale getKey() {
                    return this.key;
                }

                @Override
                public String getValue() {
                    return this.val;
                }

                @Override
                public String setValue(String value) {
                    throw new ConstraintViolationException("Unmodifable map modified");
                }
            };
        }
    };
    @Nonnull
    private final String id;
    @Nonnull
    private Map<Locale, String> displayNames;
    @Nonnull
    private Map<Locale, String> displayDescriptions;
    @Nonnull
    private List<IdPAttributeValue> values;

    public IdPAttribute(@Nonnull @ParameterName(name="attributeId") @NotEmpty String attributeId) {
        this.id = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)attributeId), (String)"Attribute ID may not be null");
        Constraint.isFalse((boolean)IdPAttribute.isInvalidId(this.id), (String)"Attribute ID must not have spaces");
        if (IdPAttribute.isDeprecatedId(this.id)) {
            DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"IdPAttribute", (String)"IdPAttribute id with special characters ('\"%{})", null);
            LOG.debug("{} - deprecated character in attribute name", (Object)this.id);
            LOG.trace("Stack", (Throwable)new Exception("Stack Trace, not a thrown exception:"));
        }
        this.displayNames = Collections.emptyMap();
        this.displayDescriptions = Collections.emptyMap();
        this.values = Collections.emptyList();
    }

    public static boolean isDeprecatedId(@Nonnull @NotEmpty String id) {
        return id.indexOf(39) >= 0 || id.indexOf(37) >= 0 || id.indexOf(123) >= 0 || id.indexOf(125) >= 0;
    }

    public static boolean isInvalidId(@Nullable String id) {
        return null == StringSupport.trimOrNull((String)id) || !SPACE_CONTAINING.test(id);
    }

    @Nonnull
    @NotEmpty
    public String getId() {
        return this.id;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<Locale, String> getDisplayNames() {
        return this.displayNames;
    }

    @Nonnull
    @Unmodifiable
    private final Map<Locale, String> checkedNamesFrom(@Nonnull @NonnullElements Map<Locale, String> inputMap) {
        return Map.ofEntries((Map.Entry[])inputMap.entrySet().stream().map(filterEntry).toArray(Map.Entry[]::new));
    }

    public void setDisplayNames(@Nonnull @NonnullElements Map<Locale, String> newNames) {
        this.displayNames = this.checkedNamesFrom((Map)Constraint.isNotNull(newNames, (String)"Display Names should not be null"));
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<Locale, String> getDisplayDescriptions() {
        return this.displayDescriptions;
    }

    public void setDisplayDescriptions(@Nonnull @NonnullElements Map<Locale, String> newDescriptions) {
        this.displayDescriptions = this.checkedNamesFrom((Map)Constraint.isNotNull(newDescriptions, (String)"Display Descriptions should not be null"));
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public List<IdPAttributeValue> getValues() {
        return this.values;
    }

    public void setValues(@Nullable @NullableElements Collection<IdPAttributeValue> newValues) {
        this.values = newValues != null ? newValues.stream().map(e -> e == null ? new EmptyAttributeValue(EmptyAttributeValue.EmptyType.NULL_VALUE) : e).collect(Collectors.toUnmodifiableList()) : Collections.emptyList();
    }

    @Override
    public int compareTo(IdPAttribute other) {
        return this.getId().compareTo(other.getId());
    }

    @Nonnull
    public IdPAttribute clone() throws CloneNotSupportedException {
        IdPAttribute clone = (IdPAttribute)super.clone();
        clone.setDisplayDescriptions(this.getDisplayDescriptions());
        clone.setDisplayNames(this.getDisplayNames());
        clone.setValues(this.getValues());
        return clone;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.id, this.values});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdPAttribute)) {
            return false;
        }
        IdPAttribute other = (IdPAttribute)obj;
        return Objects.equals(this.id, other.getId());
    }

    @Nonnull
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("displayNames", this.displayNames).add("displayDescriptions", this.displayDescriptions).add("values", this.values).toString();
    }
}

