/*
 * Decompiled with CFR 0.152.
 */
package net.nicholaswilliams.java.licensing.encryption;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.nicholaswilliams.java.licensing.encryption.PrivateKeyDataProvider;
import net.nicholaswilliams.java.licensing.exception.KeyNotFoundException;
import org.apache.commons.io.FileUtils;

public class FilePrivateKeyDataProvider
implements PrivateKeyDataProvider {
    private final File privateKeyFile;

    public FilePrivateKeyDataProvider(File file) {
        this.privateKeyFile = file.getAbsoluteFile();
    }

    public FilePrivateKeyDataProvider(String string) {
        this.privateKeyFile = new File(string).getAbsoluteFile();
    }

    @Override
    public byte[] getEncryptedPrivateKeyData() throws KeyNotFoundException {
        try {
            return FileUtils.readFileToByteArray((File)this.privateKeyFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyNotFoundException("The private key file [" + this.privateKeyFile.getPath() + "] does not exist.");
        }
        catch (IOException iOException) {
            throw new KeyNotFoundException("Could not read from the private key file [" + this.privateKeyFile.getPath() + "].", (Throwable)iOException);
        }
    }

    public File getPrivateKeyFile() {
        return this.privateKeyFile;
    }
}

