/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.jackson;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.jackson.AbstractModelConverter;
import io.swagger.v3.core.jackson.JAXBAnnotationsHelper;
import io.swagger.v3.core.jackson.TypeNameResolver;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.core.util.RefUtils;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.annotations.media.DiscriminatorMapping;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import io.swagger.v3.oas.models.media.XML;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelResolver
extends AbstractModelConverter
implements ModelConverter {
    Logger LOGGER = LoggerFactory.getLogger(ModelResolver.class);

    public ModelResolver(ObjectMapper mapper) {
        super(mapper);
    }

    public ObjectMapper objectMapper() {
        return this._mapper;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Schema resolve(AnnotatedType annotatedType, ModelConverterContext context, Iterator<ModelConverter> next) {
        Schema items;
        Discriminator discriminator;
        XML xml;
        boolean isComposedSchema;
        PrimitiveType primitiveType;
        io.swagger.v3.oas.annotations.media.Schema resolvedSchemaAnnotation;
        boolean isPrimitive = false;
        StringSchema model = null;
        if (annotatedType == null) {
            return null;
        }
        if (this.shouldIgnoreClass(annotatedType.getType())) {
            return null;
        }
        JavaType type = annotatedType.getType() instanceof JavaType ? (JavaType)annotatedType.getType() : this._mapper.constructType(annotatedType.getType());
        Annotation resolvedSchemaOrArrayAnnotation = AnnotationsUtils.mergeSchemaAnnotations(annotatedType.getCtxAnnotations(), type);
        io.swagger.v3.oas.annotations.media.Schema schema = resolvedSchemaOrArrayAnnotation == null ? null : (resolvedSchemaAnnotation = resolvedSchemaOrArrayAnnotation instanceof io.swagger.v3.oas.annotations.media.ArraySchema ? ((io.swagger.v3.oas.annotations.media.ArraySchema)resolvedSchemaOrArrayAnnotation).schema() : (io.swagger.v3.oas.annotations.media.Schema)resolvedSchemaOrArrayAnnotation);
        io.swagger.v3.oas.annotations.media.ArraySchema resolvedArrayAnnotation = resolvedSchemaOrArrayAnnotation == null ? null : (resolvedSchemaOrArrayAnnotation instanceof io.swagger.v3.oas.annotations.media.ArraySchema ? (io.swagger.v3.oas.annotations.media.ArraySchema)resolvedSchemaOrArrayAnnotation : null);
        BeanDescription beanDesc = this._mapper.getSerializationConfig().introspect(type);
        String name = annotatedType.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            if (!annotatedType.isSkipSchemaName() && resolvedSchemaAnnotation != null && !resolvedSchemaAnnotation.name().isEmpty()) {
                name = resolvedSchemaAnnotation.name();
            }
            if (StringUtils.isBlank((CharSequence)name) && !ReflectionUtils.isSystemType(type)) {
                name = this._typeName(type, beanDesc);
            }
        }
        name = this.decorateModelName(annotatedType, name);
        if (resolvedSchemaAnnotation != null && StringUtils.isNotEmpty((CharSequence)resolvedSchemaAnnotation.ref())) {
            return new Schema().$ref(resolvedSchemaAnnotation.ref()).name(name);
        }
        if (!annotatedType.isSkipOverride() && resolvedSchemaAnnotation != null && !Void.class.equals((Object)resolvedSchemaAnnotation.implementation())) {
            Class cls = resolvedSchemaAnnotation.implementation();
            this.LOGGER.debug("overriding datatype from {} to {}", (Object)type, (Object)cls.getName());
            Annotation[] ctxAnnotation = null;
            if (resolvedArrayAnnotation != null && annotatedType.getCtxAnnotations() != null) {
                ArrayList<Annotation> annList = new ArrayList<Annotation>();
                for (Annotation a : annotatedType.getCtxAnnotations()) {
                    if (a instanceof ArraySchema) continue;
                    annList.add(a);
                }
                annList.add((Annotation)resolvedSchemaAnnotation);
                ctxAnnotation = annList.toArray(new Annotation[annList.size()]);
            } else {
                ctxAnnotation = annotatedType.getCtxAnnotations();
            }
            AnnotatedType aType = new AnnotatedType().type(cls).ctxAnnotations(ctxAnnotation).parent(annotatedType.getParent()).name(annotatedType.getName()).resolveAsRef(annotatedType.isResolveAsRef()).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()).skipOverride(true);
            if (resolvedArrayAnnotation != null) {
                ArraySchema schema2 = new ArraySchema();
                Schema innerSchema = null;
                Schema primitive = PrimitiveType.createProperty(cls);
                if (primitive != null) {
                    innerSchema = primitive;
                } else {
                    innerSchema = context.resolve(aType);
                    if (innerSchema != null && "object".equals(innerSchema.getType()) && StringUtils.isNotBlank((CharSequence)innerSchema.getName())) {
                        if (context.getDefinedModels().containsKey(innerSchema.getName())) {
                            innerSchema = new Schema().$ref(RefUtils.constructRef(innerSchema.getName()));
                        }
                    } else if (innerSchema != null && innerSchema.get$ref() != null) {
                        innerSchema = new Schema().$ref(StringUtils.isNotEmpty((CharSequence)innerSchema.get$ref()) ? innerSchema.get$ref() : innerSchema.getName());
                    }
                }
                schema2.setItems(innerSchema);
                return schema2;
            }
            Schema implSchema = context.resolve(aType);
            if (implSchema != null && aType.isResolveAsRef() && "object".equals(implSchema.getType()) && StringUtils.isNotBlank((CharSequence)implSchema.getName())) {
                if (context.getDefinedModels().containsKey(implSchema.getName())) {
                    implSchema = new Schema().$ref(RefUtils.constructRef(implSchema.getName()));
                }
            } else if (implSchema != null && implSchema.get$ref() != null) {
                implSchema = new Schema().$ref(StringUtils.isNotEmpty((CharSequence)implSchema.get$ref()) ? implSchema.get$ref() : implSchema.getName());
            }
            return implSchema;
        }
        if (model == null && !annotatedType.isSkipOverride() && resolvedSchemaAnnotation != null && StringUtils.isNotEmpty((CharSequence)resolvedSchemaAnnotation.type()) && !resolvedSchemaAnnotation.type().equals("object")) {
            primitiveType = PrimitiveType.fromTypeAndFormat(resolvedSchemaAnnotation.type(), resolvedSchemaAnnotation.format());
            if (primitiveType == null) {
                primitiveType = PrimitiveType.fromType((Type)type);
            }
            if (primitiveType == null) {
                primitiveType = PrimitiveType.fromName(resolvedSchemaAnnotation.type());
            }
            if (primitiveType != null) {
                Schema primitive = primitiveType.createProperty();
                model = primitive;
                isPrimitive = true;
            }
        }
        if (model == null && type.isEnumType()) {
            model = new StringSchema();
            this._addEnumProps(type.getRawClass(), (Schema)model);
            isPrimitive = true;
        }
        if (model == null && (primitiveType = PrimitiveType.fromType((Type)type)) != null) {
            model = PrimitiveType.fromType((Type)type).createProperty();
            isPrimitive = true;
        }
        if (!annotatedType.isSkipJsonIdentity()) {
            JsonIdentityInfo jsonIdentityInfo = AnnotationsUtils.getAnnotation(JsonIdentityInfo.class, annotatedType.getCtxAnnotations());
            if (jsonIdentityInfo == null) {
                jsonIdentityInfo = type.getRawClass().getAnnotation(JsonIdentityInfo.class);
            }
            if (model == null && jsonIdentityInfo != null) {
                JsonIdentityReference jsonIdentityReference = AnnotationsUtils.getAnnotation(JsonIdentityReference.class, annotatedType.getCtxAnnotations());
                if (jsonIdentityReference == null) {
                    jsonIdentityReference = type.getRawClass().getAnnotation(JsonIdentityReference.class);
                }
                if ((model = GeneratorWrapper.processJsonIdentity(annotatedType, context, this._mapper, jsonIdentityInfo, jsonIdentityReference)) != null) {
                    return model;
                }
            }
        }
        if (model == null && annotatedType.getJsonUnwrappedHandler() != null && (model = annotatedType.getJsonUnwrappedHandler().apply(annotatedType)) == null) {
            return null;
        }
        if ("Object".equals(name)) {
            return new Schema();
        }
        if (isPrimitive) {
            XML xml2;
            if (annotatedType.isSchemaProperty()) {
                // empty if block
            }
            if ((xml2 = this.resolveXml((Annotated)beanDesc.getClassInfo(), annotatedType.getCtxAnnotations(), resolvedSchemaAnnotation)) != null) {
                model.xml(xml2);
            }
            this.resolveSchemaMembers((Schema)model, annotatedType);
            return model;
        }
        Schema resolvedModel = context.resolve(annotatedType);
        if (resolvedModel != null && name.equals(resolvedModel.getName())) {
            return resolvedModel;
        }
        AnnotatedMethod jsonValueMethod = beanDesc.findJsonValueMethod();
        if (jsonValueMethod != null) {
            AnnotatedType aType = new AnnotatedType().type((Type)jsonValueMethod.getType()).parent(annotatedType.getParent()).name(annotatedType.getName()).schemaProperty(annotatedType.isSchemaProperty()).resolveAsRef(annotatedType.isResolveAsRef()).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()).skipOverride(true);
            return context.resolve(aType);
        }
        List<Class<?>> composedSchemaReferencedClasses = this.getComposedSchemaReferencedClasses(type.getRawClass(), annotatedType.getCtxAnnotations());
        boolean bl = isComposedSchema = composedSchemaReferencedClasses != null;
        if (type.isContainerType()) {
            JavaType keyType = type.getKeyType();
            JavaType valueType = type.getContentType();
            String pName = null;
            if (valueType != null) {
                BeanDescription valueTypeBeanDesc = this._mapper.getSerializationConfig().introspect(valueType);
                pName = this._typeName(valueType, valueTypeBeanDesc);
            }
            Annotation[] schemaAnnotations = null;
            if (resolvedSchemaAnnotation != null) {
                schemaAnnotations = new Annotation[]{resolvedSchemaAnnotation};
            }
            if (keyType != null && valueType != null) {
                if (ReflectionUtils.isSystemType(type) && !annotatedType.isSchemaProperty() && !annotatedType.isResolveAsRef()) {
                    context.resolve(new AnnotatedType().type((Type)valueType).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()));
                    return null;
                }
                Schema addPropertiesSchema = context.resolve(new AnnotatedType().type((Type)valueType).schemaProperty(annotatedType.isSchemaProperty()).ctxAnnotations(schemaAnnotations).skipSchemaName(true).resolveAsRef(annotatedType.isResolveAsRef()).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()).parent(annotatedType.getParent()));
                if (StringUtils.isNotBlank((CharSequence)addPropertiesSchema.getName())) {
                    pName = addPropertiesSchema.getName();
                }
                if ("object".equals(addPropertiesSchema.getType()) && pName != null) {
                    if (context.getDefinedModels().containsKey(pName)) {
                        addPropertiesSchema = new Schema().$ref(RefUtils.constructRef(pName));
                    }
                } else if (addPropertiesSchema.get$ref() != null) {
                    addPropertiesSchema = new Schema().$ref(StringUtils.isNotEmpty((CharSequence)addPropertiesSchema.get$ref()) ? addPropertiesSchema.get$ref() : addPropertiesSchema.getName());
                }
                Schema mapModel = new MapSchema().additionalProperties((Object)addPropertiesSchema);
                mapModel.name(name);
                model = mapModel;
            } else if (valueType != null) {
                if (ReflectionUtils.isSystemType(type) && !annotatedType.isSchemaProperty() && !annotatedType.isResolveAsRef()) {
                    context.resolve(new AnnotatedType().type((Type)valueType).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()));
                    return null;
                }
                Schema items2 = context.resolve(new AnnotatedType().type((Type)valueType).schemaProperty(annotatedType.isSchemaProperty()).ctxAnnotations(schemaAnnotations).skipSchemaName(true).resolveAsRef(annotatedType.isResolveAsRef()).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()).parent(annotatedType.getParent()));
                if (items2 == null) {
                    return null;
                }
                if (annotatedType.isSchemaProperty() && annotatedType.getCtxAnnotations() != null && annotatedType.getCtxAnnotations().length > 0) {
                    for (Object annotation : annotatedType.getCtxAnnotations()) {
                        XmlElement xmlElement;
                        if (!(annotation instanceof XmlElement) || (xmlElement = (XmlElement)annotation) == null || xmlElement.name() == null || "".equals(xmlElement.name()) || "##default".equals(xmlElement.name())) continue;
                        XML xml3 = items2.getXml() != null ? items2.getXml() : new XML();
                        xml3.setName(xmlElement.name());
                        items2.setXml(xml3);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)items2.getName())) {
                    pName = items2.getName();
                }
                if ("object".equals(items2.getType()) && pName != null) {
                    if (context.getDefinedModels().containsKey(pName)) {
                        items2 = new Schema().$ref(RefUtils.constructRef(pName));
                    }
                } else if (items2.get$ref() != null) {
                    items2 = new Schema().$ref(StringUtils.isNotEmpty((CharSequence)items2.get$ref()) ? items2.get$ref() : items2.getName());
                }
                ArraySchema arrayModel = new ArraySchema().items(items2);
                if (this._isSetType(type.getRawClass())) {
                    arrayModel.setUniqueItems(Boolean.valueOf(true));
                }
                arrayModel.name(name);
                model = arrayModel;
            } else if (ReflectionUtils.isSystemType(type) && !annotatedType.isSchemaProperty() && !annotatedType.isResolveAsRef()) {
                return null;
            }
        } else if (isComposedSchema) {
            model = new ComposedSchema().type("object").name(name);
        } else {
            if (this._isOptionalType(type)) {
                AnnotatedType aType = new AnnotatedType().type((Type)type.containedType(0)).ctxAnnotations(annotatedType.getCtxAnnotations()).parent(annotatedType.getParent()).schemaProperty(annotatedType.isSchemaProperty()).name(annotatedType.getName()).resolveAsRef(annotatedType.isResolveAsRef()).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()).skipOverride(true);
                model = context.resolve(aType);
                return model;
            }
            model = new Schema().type("object").name(name);
        }
        if (!type.isContainerType() && StringUtils.isNotBlank((CharSequence)name)) {
            context.defineModel(name, (Schema)model, annotatedType, null);
        }
        if ((xml = this.resolveXml((Annotated)beanDesc.getClassInfo(), annotatedType.getCtxAnnotations(), resolvedSchemaAnnotation)) != null) {
            model.xml(xml);
        }
        this.resolveSchemaMembers((Schema)model, annotatedType);
        XmlAccessorType xmlAccessorTypeAnnotation = (XmlAccessorType)beanDesc.getClassAnnotations().get(XmlAccessorType.class);
        HashSet<String> propertiesToIgnore = new HashSet<String>();
        JsonIgnoreProperties ignoreProperties = (JsonIgnoreProperties)beanDesc.getClassAnnotations().get(JsonIgnoreProperties.class);
        if (ignoreProperties != null) {
            propertiesToIgnore.addAll(Arrays.asList(ignoreProperties.value()));
        }
        ArrayList<Schema> props = new ArrayList<Schema>();
        LinkedHashMap<String, Schema> modelProps = new LinkedHashMap<String, Schema>();
        List properties = beanDesc.findProperties();
        List<String> ignoredProps = this.getIgnoredProperties(beanDesc);
        properties.removeIf(p -> ignoredProps.contains(p.getName()));
        for (BeanPropertyDefinition propDef : properties) {
            void var27_40;
            io.swagger.v3.oas.annotations.media.Schema propResolvedSchemaAnnotation;
            Annotation propSchemaOrArray;
            void var27_43;
            String altName;
            Member innerMember;
            Schema property = null;
            String string = propDef.getName();
            Annotation[] annotations = null;
            AnnotatedMember member = propDef.getPrimaryMember();
            if (member == null) {
                BeanDescription deserBeanDesc = Json.mapper().getDeserializationConfig().introspect(type);
                List deserProperties = deserBeanDesc.findProperties();
                for (Object prop : deserProperties) {
                    if (!StringUtils.isNotBlank((CharSequence)prop.getInternalName()) || !prop.getInternalName().equals(propDef.getInternalName())) continue;
                    member = prop.getPrimaryMember();
                    break;
                }
            }
            if (member != null && (innerMember = member.getMember()) != null && (altName = innerMember.getName()) != null) {
                Object prop;
                int length = altName.length();
                prop = Arrays.asList("get", "is").iterator();
                while (prop.hasNext()) {
                    String prefix = (String)prop.next();
                    int offset = prefix.length();
                    if (!altName.startsWith(prefix) || length <= offset || Character.isUpperCase(altName.charAt(offset))) continue;
                    String string2 = altName;
                    break;
                }
            }
            PropertyMetadata md = propDef.getMetadata();
            if (member == null || this.ignore((Annotated)member, xmlAccessorTypeAnnotation, (String)var27_43, propertiesToIgnore)) continue;
            ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
            for (Annotation a : member.annotations()) {
                annotationList.add(a);
            }
            annotations = annotationList.toArray(new Annotation[annotationList.size()]);
            if (this.hiddenByJsonView(annotations, annotatedType)) continue;
            JavaType propType = member.getType();
            if (propType != null && "void".equals(propType.getRawClass().getName()) && member instanceof AnnotatedMethod) {
                propType = ((AnnotatedMethod)member).getParameterType(0);
            }
            io.swagger.v3.oas.annotations.media.Schema schema2 = (propSchemaOrArray = AnnotationsUtils.mergeSchemaAnnotations(annotations, propType)) == null ? null : (propResolvedSchemaAnnotation = propSchemaOrArray instanceof io.swagger.v3.oas.annotations.media.ArraySchema ? ((io.swagger.v3.oas.annotations.media.ArraySchema)propSchemaOrArray).schema() : (io.swagger.v3.oas.annotations.media.Schema)propSchemaOrArray);
            if (propResolvedSchemaAnnotation != null && !propResolvedSchemaAnnotation.name().isEmpty()) {
                String string3 = propResolvedSchemaAnnotation.name();
            }
            Schema.AccessMode accessMode = this.resolveAccessMode(propDef, type, propResolvedSchemaAnnotation);
            AnnotatedType aType = new AnnotatedType().type((Type)propType).ctxAnnotations(annotations).parent((Schema)model).resolveAsRef(annotatedType.isResolveAsRef()).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()).skipSchemaName(true).schemaProperty(true);
            AnnotatedMember propMember = member;
            aType.jsonUnwrappedHandler(t -> {
                JsonUnwrapped uw = (JsonUnwrapped)propMember.getAnnotation(JsonUnwrapped.class);
                if (uw != null && uw.enabled()) {
                    t.ctxAnnotations(null).jsonUnwrappedHandler(null).resolveAsRef(false);
                    this.handleUnwrapped(props, context.resolve((AnnotatedType)t), uw.prefix(), uw.suffix());
                    return null;
                }
                return new Schema();
            });
            property = context.resolve(aType);
            if (property == null) continue;
            if (property.get$ref() == null) {
                Boolean required = md.getRequired();
                if (required != null && !Boolean.FALSE.equals(required)) {
                    this.addRequiredItem((Schema)model, (String)var27_40);
                } else if (propDef.isRequired()) {
                    this.addRequiredItem((Schema)model, (String)var27_40);
                }
                if (accessMode != null) {
                    switch (accessMode) {
                        case AUTO: {
                            break;
                        }
                        case READ_ONLY: {
                            property.readOnly(Boolean.valueOf(true));
                            break;
                        }
                        case READ_WRITE: {
                            break;
                        }
                        case WRITE_ONLY: {
                            property.writeOnly(Boolean.valueOf(true));
                            break;
                        }
                    }
                }
            }
            BeanDescription propBeanDesc = this._mapper.getSerializationConfig().introspect(propType);
            if (property != null && !propType.isContainerType()) {
                if ("object".equals(property.getType())) {
                    String pName = this._typeName(propType, propBeanDesc);
                    if (StringUtils.isNotBlank((CharSequence)property.getName())) {
                        pName = property.getName();
                    }
                    if (context.getDefinedModels().containsKey(pName)) {
                        property = new Schema().$ref(RefUtils.constructRef(pName));
                    }
                } else if (property.get$ref() != null) {
                    property = new Schema().$ref(StringUtils.isNotEmpty((CharSequence)property.get$ref()) ? property.get$ref() : property.getName());
                }
            }
            property.setName((String)var27_40);
            JAXBAnnotationsHelper.apply((Annotated)propBeanDesc.getClassInfo(), annotations, property);
            this.applyBeanValidatorAnnotations(property, annotations, (Schema)model);
            props.add(property);
        }
        for (Schema prop : props) {
            modelProps.put(prop.getName(), prop);
        }
        if (modelProps.size() > 0) {
            model.setProperties(modelProps);
        }
        if (!type.isContainerType() && StringUtils.isNotBlank((CharSequence)name)) {
            context.defineModel(name, (Schema)model, annotatedType, null);
        }
        if (!this.resolveSubtypes((Schema)model, beanDesc, context)) {
            model.setDiscriminator(null);
        }
        if ((discriminator = this.resolveDiscriminator(type, context)) != null) {
            model.setDiscriminator(discriminator);
        }
        if (resolvedSchemaAnnotation != null) {
            Class not;
            String ref = resolvedSchemaAnnotation.ref();
            if (!StringUtils.isBlank((CharSequence)ref)) {
                model.$ref(ref);
            }
            if (!Void.class.equals((Object)(not = resolvedSchemaAnnotation.not()))) {
                model.not(new Schema().$ref(context.resolve(new AnnotatedType().type(not).jsonViewAnnotation(annotatedType.getJsonViewAnnotation())).getName()));
            }
            if (resolvedSchemaAnnotation.requiredProperties() != null && resolvedSchemaAnnotation.requiredProperties().length > 0 && StringUtils.isNotBlank((CharSequence)resolvedSchemaAnnotation.requiredProperties()[0])) {
                for (String prop : resolvedSchemaAnnotation.requiredProperties()) {
                    this.addRequiredItem((Schema)model, prop);
                }
            }
        }
        if (isComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)model;
            Class[] allOf = resolvedSchemaAnnotation.allOf();
            Class[] classArray = resolvedSchemaAnnotation.anyOf();
            Class[] oneOf = resolvedSchemaAnnotation.oneOf();
            List<Class> allOfFiltered = Stream.of(allOf).distinct().filter(c -> !this.shouldIgnoreClass((Type)c)).filter(c -> !c.equals(Void.class)).collect(Collectors.toList());
            allOfFiltered.forEach(c -> {
                Schema allOfRef = context.resolve(new AnnotatedType().type((Type)c).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()));
                Schema refSchema = new Schema().$ref(allOfRef.getName());
                if (composedSchema.getAllOf() == null || !composedSchema.getAllOf().contains(refSchema)) {
                    composedSchema.addAllOfItem(refSchema);
                }
                if (this.isSubtype(beanDesc.getClassInfo(), (Class<?>)c)) {
                    this.removeParentProperties((Schema)composedSchema, allOfRef);
                }
            });
            List<Class> anyOfFiltered = Stream.of(classArray).distinct().filter(c -> !this.shouldIgnoreClass((Type)c)).filter(c -> !c.equals(Void.class)).collect(Collectors.toList());
            anyOfFiltered.forEach(c -> {
                Schema anyOfRef = context.resolve(new AnnotatedType().type((Type)c).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()));
                composedSchema.addAnyOfItem(new Schema().$ref(anyOfRef.getName()));
                if (this.isSubtype(beanDesc.getClassInfo(), (Class<?>)c)) {
                    this.removeParentProperties((Schema)composedSchema, anyOfRef);
                }
            });
            List<Class> oneOfFiltered = Stream.of(oneOf).distinct().filter(c -> !this.shouldIgnoreClass((Type)c)).filter(c -> !c.equals(Void.class)).collect(Collectors.toList());
            oneOfFiltered.forEach(c -> {
                Schema oneOfRef = context.resolve(new AnnotatedType().type((Type)c).jsonViewAnnotation(annotatedType.getJsonViewAnnotation()));
                composedSchema.addOneOfItem(new Schema().$ref(oneOfRef.getName()));
                if (this.isSubtype(beanDesc.getClassInfo(), (Class<?>)c)) {
                    this.removeParentProperties((Schema)composedSchema, oneOfRef);
                }
            });
        }
        if (model != null && annotatedType.isResolveAsRef() && "object".equals(model.getType()) && StringUtils.isNotBlank((CharSequence)model.getName())) {
            if (context.getDefinedModels().containsKey(model.getName())) {
                model = new Schema().$ref(RefUtils.constructRef(model.getName()));
            }
        } else if (model != null && model.get$ref() != null) {
            model = new Schema().$ref(StringUtils.isNotEmpty((CharSequence)model.get$ref()) ? model.get$ref() : model.getName());
        }
        if (model != null && !"array".equals(model.getType()) && resolvedArrayAnnotation != null) {
            Map<String, Object> extensions;
            Boolean uniqueItems;
            Integer n;
            ArraySchema schema4 = new ArraySchema();
            schema4.setItems((Schema)model);
            Integer minItems = this.resolveMinItems(annotatedType, resolvedArrayAnnotation);
            if (minItems != null) {
                schema4.minItems(minItems);
            }
            if ((n = this.resolveMaxItems(annotatedType, resolvedArrayAnnotation)) != null) {
                schema4.maxItems(n);
            }
            if ((uniqueItems = this.resolveUniqueItems(annotatedType, resolvedArrayAnnotation)) != null) {
                schema4.uniqueItems(uniqueItems);
            }
            if ((extensions = this.resolveExtensions(annotatedType, resolvedArrayAnnotation)) != null) {
                schema4.extensions(extensions);
            }
            return schema4;
        }
        if (model != null && model instanceof ArraySchema && (items = ((ArraySchema)model).getItems()) != null && items.getExample() != null && model.getExample() != null) {
            items.setExample(null);
        }
        return model;
    }

    private boolean isSubtype(AnnotatedClass childClass, Class<?> parentClass) {
        BeanDescription parentDesc = this._mapper.getSerializationConfig().introspectClassAnnotations(parentClass);
        List subTypes = this._intr.findSubtypes((Annotated)parentDesc.getClassInfo());
        if (subTypes == null) {
            return false;
        }
        for (NamedType subtype : subTypes) {
            Class subtypeType = subtype.getType();
            if (!childClass.getRawType().isAssignableFrom(subtypeType)) continue;
            return true;
        }
        return false;
    }

    private boolean _isOptionalType(JavaType propType) {
        return Arrays.asList("com.google.common.base.Optional", "java.util.Optional").contains(propType.getRawClass().getCanonicalName());
    }

    protected void _addEnumProps(Class<?> propClass, Schema property) {
        boolean useIndex = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
        boolean useToString = this._mapper.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        Class<?> enumClass = propClass;
        for (Enum en : (Enum[])enumClass.getEnumConstants()) {
            String n = useIndex ? String.valueOf(en.ordinal()) : (useToString ? en.toString() : this._intr.findEnumValue(en));
            if (!(property instanceof StringSchema)) continue;
            StringSchema sp = (StringSchema)property;
            sp.addEnumItem(n);
        }
    }

    protected boolean ignore(Annotated member, XmlAccessorType xmlAccessorTypeAnnotation, String propName, Set<String> propertiesToIgnore) {
        if (propertiesToIgnore.contains(propName)) {
            return true;
        }
        if (xmlAccessorTypeAnnotation == null) {
            return false;
        }
        return xmlAccessorTypeAnnotation.value().equals((Object)XmlAccessType.NONE) && !member.hasAnnotation(XmlElement.class);
    }

    private void handleUnwrapped(List<Schema> props, Schema innerModel, String prefix, String suffix) {
        if (StringUtils.isBlank((CharSequence)suffix) && StringUtils.isBlank((CharSequence)prefix)) {
            props.addAll(innerModel.getProperties().values());
        } else {
            if (prefix == null) {
                prefix = "";
            }
            if (suffix == null) {
                suffix = "";
            }
            for (Schema prop : innerModel.getProperties().values()) {
                try {
                    Schema clonedProp = (Schema)Json.mapper().readValue(Json.pretty(prop), Schema.class);
                    clonedProp.setName(prefix + prop.getName() + suffix);
                    props.add(clonedProp);
                }
                catch (IOException e) {
                    this.LOGGER.error("Exception cloning property", (Throwable)e);
                    return;
                }
            }
        }
    }

    protected void applyBeanValidatorAnnotations(Schema property, Annotation[] annotations, Schema parent) {
        Max max;
        Min min;
        HashMap<String, Annotation> annos = new HashMap<String, Annotation>();
        if (annotations != null) {
            for (Annotation anno : annotations) {
                annos.put(anno.annotationType().getName(), anno);
            }
        }
        if (parent != null && annos.containsKey("javax.validation.constraints.NotNull")) {
            this.addRequiredItem(parent, property.getName());
        }
        if (annos.containsKey("javax.validation.constraints.Min") && ("integer".equals(property.getType()) || "number".equals(property.getType()))) {
            min = (Min)annos.get("javax.validation.constraints.Min");
            property.setMinimum(new BigDecimal(min.value()));
        }
        if (annos.containsKey("javax.validation.constraints.Max") && ("integer".equals(property.getType()) || "number".equals(property.getType()))) {
            max = (Max)annos.get("javax.validation.constraints.Max");
            property.setMaximum(new BigDecimal(max.value()));
        }
        if (annos.containsKey("javax.validation.constraints.Size")) {
            Size size = (Size)annos.get("javax.validation.constraints.Size");
            if ("integer".equals(property.getType()) || "number".equals(property.getType())) {
                property.setMinimum(new BigDecimal(size.min()));
                property.setMaximum(new BigDecimal(size.max()));
            } else if (property instanceof StringSchema) {
                StringSchema sp = (StringSchema)property;
                sp.minLength(new Integer(size.min()));
                sp.maxLength(new Integer(size.max()));
            } else if (property instanceof ArraySchema) {
                ArraySchema sp = (ArraySchema)property;
                sp.setMinItems(Integer.valueOf(size.min()));
                sp.setMaxItems(Integer.valueOf(size.max()));
            }
        }
        if (annos.containsKey("javax.validation.constraints.DecimalMin")) {
            min = (DecimalMin)annos.get("javax.validation.constraints.DecimalMin");
            if (property instanceof NumberSchema) {
                NumberSchema ap = (NumberSchema)property;
                ap.setMinimum(new BigDecimal(min.value()));
                ap.setExclusiveMinimum(Boolean.valueOf(!min.inclusive()));
            }
        }
        if (annos.containsKey("javax.validation.constraints.DecimalMax")) {
            max = (DecimalMax)annos.get("javax.validation.constraints.DecimalMax");
            if (property instanceof NumberSchema) {
                NumberSchema ap = (NumberSchema)property;
                ap.setMaximum(new BigDecimal(max.value()));
                ap.setExclusiveMaximum(Boolean.valueOf(!max.inclusive()));
            }
        }
        if (annos.containsKey("javax.validation.constraints.Pattern")) {
            Pattern pattern = (Pattern)annos.get("javax.validation.constraints.Pattern");
            if (property instanceof StringSchema) {
                property.setPattern(pattern.regexp());
            }
        }
    }

    private boolean resolveSubtypes(Schema model, BeanDescription bean, ModelConverterContext context) {
        List types = this._intr.findSubtypes((Annotated)bean.getClassInfo());
        if (types == null) {
            return false;
        }
        this.removeSuperClassAndInterfaceSubTypes(types, bean);
        boolean count = false;
        Class beanClass = bean.getClassInfo().getAnnotated();
        for (NamedType subtype : types) {
            Class subtypeType = subtype.getType();
            if (!beanClass.isAssignableFrom(subtypeType)) continue;
            Schema subtypeModel = context.resolve(new AnnotatedType().type(subtypeType));
            if (subtypeModel.getName().equals(model.getName())) {
                subtypeModel.setName(this._typeNameResolver.nameForType(this._mapper.constructType((Type)subtypeType), TypeNameResolver.Options.SKIP_API_MODEL));
            }
            ComposedSchema composedSchema = null;
            composedSchema = !(subtypeModel instanceof ComposedSchema) ? (ComposedSchema)new ComposedSchema().title(subtypeModel.getTitle()).name(subtypeModel.getName()).deprecated(subtypeModel.getDeprecated()).additionalProperties(subtypeModel.getAdditionalProperties()).description(subtypeModel.getDescription()).discriminator(subtypeModel.getDiscriminator()).example(subtypeModel.getExample()).exclusiveMaximum(subtypeModel.getExclusiveMaximum()).exclusiveMinimum(subtypeModel.getExclusiveMinimum()).externalDocs(subtypeModel.getExternalDocs()).format(subtypeModel.getFormat()).maximum(subtypeModel.getMaximum()).maxItems(subtypeModel.getMaxItems()).maxLength(subtypeModel.getMaxLength()).maxProperties(subtypeModel.getMaxProperties()).minimum(subtypeModel.getMinimum()).minItems(subtypeModel.getMinItems()).minLength(subtypeModel.getMinLength()).minProperties(subtypeModel.getMinProperties()).multipleOf(subtypeModel.getMultipleOf()).not(subtypeModel.getNot()).nullable(subtypeModel.getNullable()).pattern(subtypeModel.getPattern()).properties(subtypeModel.getProperties()).readOnly(subtypeModel.getReadOnly()).required(subtypeModel.getRequired()).type(subtypeModel.getType()).uniqueItems(subtypeModel.getUniqueItems()).writeOnly(subtypeModel.getWriteOnly()).xml(subtypeModel.getXml()).extensions(subtypeModel.getExtensions()) : (ComposedSchema)subtypeModel;
            Schema refSchema = new Schema().$ref(model.getName());
            if (composedSchema.getAllOf() == null || !composedSchema.getAllOf().contains(refSchema)) {
                composedSchema.addAllOfItem(refSchema);
            }
            this.removeParentProperties((Schema)composedSchema, model);
            Class currentType = subtype.getType();
            if (!StringUtils.isNotBlank((CharSequence)composedSchema.getName())) continue;
            context.defineModel(composedSchema.getName(), (Schema)composedSchema, new AnnotatedType().type(currentType), null);
        }
        return count;
    }

    private void removeSuperClassAndInterfaceSubTypes(List<NamedType> types, BeanDescription bean) {
        Class beanClass = bean.getType().getRawClass();
        Class superClass = beanClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.removeSuperSubTypes(types, superClass);
        }
        if (!types.isEmpty()) {
            Class<?>[] superInterfaces;
            for (Class<?> superInterface : superInterfaces = beanClass.getInterfaces()) {
                this.removeSuperSubTypes(types, superInterface);
                if (types.isEmpty()) break;
            }
        }
    }

    private void removeSuperSubTypes(List<NamedType> resultTypes, Class<?> superClass) {
        JavaType superType = this._mapper.constructType(superClass);
        BeanDescription superBean = this._mapper.getSerializationConfig().introspect(superType);
        List superTypes = this._intr.findSubtypes((Annotated)superBean.getClassInfo());
        if (superTypes != null) {
            resultTypes.removeAll(superTypes);
        }
    }

    private void removeParentProperties(Schema child, Schema parent) {
        Map baseProps = parent.getProperties();
        Map subtypeProps = child.getProperties();
        if (baseProps != null && subtypeProps != null) {
            for (Map.Entry entry : baseProps.entrySet()) {
                if (!((Schema)entry.getValue()).equals(subtypeProps.get(entry.getKey()))) continue;
                subtypeProps.remove(entry.getKey());
            }
        }
        if (subtypeProps == null || subtypeProps.isEmpty()) {
            child.setProperties(null);
        }
    }

    protected List<Class<?>> getComposedSchemaReferencedClasses(Class<?> clazz, Annotation[] ctxAnnotations) {
        io.swagger.v3.oas.annotations.media.Schema schemaAnnotation = AnnotationsUtils.getSchemaAnnotation(ctxAnnotations);
        if (schemaAnnotation == null) {
            schemaAnnotation = AnnotationsUtils.getSchemaDeclaredAnnotation(clazz);
        }
        if (schemaAnnotation != null) {
            Class[] allOf = schemaAnnotation.allOf();
            Class[] anyOf = schemaAnnotation.anyOf();
            Class[] oneOf = schemaAnnotation.oneOf();
            List<Class<?>> parentClasses = Stream.of(allOf, anyOf, oneOf).flatMap(Stream::of).distinct().filter(c -> !this.shouldIgnoreClass((Type)c)).filter(c -> !c.equals(Void.class)).collect(Collectors.toList());
            if (!parentClasses.isEmpty()) {
                return parentClasses;
            }
        }
        return null;
    }

    protected String resolveDescription(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && !"".equals(schema.description())) {
            return schema.description();
        }
        return null;
    }

    protected String resolveTitle(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && StringUtils.isNotBlank((CharSequence)schema.title())) {
            return schema.title();
        }
        return null;
    }

    protected String resolveFormat(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && StringUtils.isNotBlank((CharSequence)schema.format())) {
            return schema.format();
        }
        return null;
    }

    protected String resolveDefaultValue(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && !schema.defaultValue().isEmpty()) {
            return schema.defaultValue();
        }
        XmlElement elem = (XmlElement)a.getAnnotation(XmlElement.class);
        if (elem == null && annotations != null) {
            for (Annotation ann : annotations) {
                if (!(ann instanceof XmlElement)) continue;
                elem = (XmlElement)ann;
                break;
            }
        }
        if (elem != null && !elem.defaultValue().isEmpty() && !"\u0000".equals(elem.defaultValue())) {
            return elem.defaultValue();
        }
        return null;
    }

    protected Object resolveExample(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && !schema.example().isEmpty()) {
            try {
                return Json.mapper().readTree(schema.example());
            }
            catch (IOException e) {
                return schema.example();
            }
        }
        return null;
    }

    protected Schema.AccessMode resolveAccessMode(BeanPropertyDefinition propDef, JavaType type, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && !schema.accessMode().equals((Object)Schema.AccessMode.AUTO)) {
            return schema.accessMode();
        }
        if (schema != null && schema.readOnly()) {
            return Schema.AccessMode.READ_ONLY;
        }
        if (schema != null && schema.writeOnly()) {
            return Schema.AccessMode.WRITE_ONLY;
        }
        JsonProperty.Access access = null;
        if (propDef instanceof POJOPropertyBuilder) {
            access = ((POJOPropertyBuilder)propDef).findAccess();
        }
        boolean hasGetter = propDef.hasGetter();
        boolean hasSetter = propDef.hasSetter();
        boolean hasConstructorParameter = propDef.hasConstructorParameter();
        boolean hasField = propDef.hasField();
        if (access == null) {
            BeanDescription beanDesc = Json.mapper().getDeserializationConfig().introspect(type);
            List properties = beanDesc.findProperties();
            for (BeanPropertyDefinition prop : properties) {
                if (!StringUtils.isNotBlank((CharSequence)prop.getInternalName()) || !prop.getInternalName().equals(propDef.getInternalName())) continue;
                if (prop instanceof POJOPropertyBuilder) {
                    access = ((POJOPropertyBuilder)prop).findAccess();
                }
                hasGetter = hasGetter || prop.hasGetter();
                hasSetter = hasSetter || prop.hasSetter();
                hasConstructorParameter = hasConstructorParameter || prop.hasConstructorParameter();
                hasField = hasField || prop.hasField();
                break;
            }
        }
        if (access == null) {
            if (!hasGetter && !hasField && (hasConstructorParameter || hasSetter)) {
                return Schema.AccessMode.WRITE_ONLY;
            }
            return null;
        }
        switch (access) {
            case AUTO: {
                return Schema.AccessMode.AUTO;
            }
            case READ_ONLY: {
                return Schema.AccessMode.READ_ONLY;
            }
            case READ_WRITE: {
                return Schema.AccessMode.READ_WRITE;
            }
            case WRITE_ONLY: {
                return Schema.AccessMode.WRITE_ONLY;
            }
        }
        return Schema.AccessMode.AUTO;
    }

    protected Boolean resolveReadOnly(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.accessMode().equals((Object)Schema.AccessMode.READ_ONLY)) {
            return true;
        }
        if (schema != null && schema.accessMode().equals((Object)Schema.AccessMode.WRITE_ONLY)) {
            return null;
        }
        if (schema != null && schema.accessMode().equals((Object)Schema.AccessMode.READ_WRITE)) {
            return null;
        }
        if (schema != null && schema.readOnly()) {
            return schema.readOnly();
        }
        return null;
    }

    protected Boolean resolveNullable(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.nullable()) {
            return schema.nullable();
        }
        return null;
    }

    protected BigDecimal resolveMultipleOf(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.multipleOf() != 0.0) {
            return new BigDecimal(schema.multipleOf());
        }
        return null;
    }

    protected Integer resolveMaxLength(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.maxLength() != Integer.MAX_VALUE && schema.maxLength() > 0) {
            return schema.maxLength();
        }
        return null;
    }

    protected Integer resolveMinLength(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.minLength() > 0) {
            return schema.minLength();
        }
        return null;
    }

    protected BigDecimal resolveMinimum(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && NumberUtils.isNumber((String)schema.minimum())) {
            String filteredMinimum = schema.minimum().replaceAll(",", "");
            return new BigDecimal(filteredMinimum);
        }
        return null;
    }

    protected BigDecimal resolveMaximum(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && NumberUtils.isNumber((String)schema.maximum())) {
            String filteredMaximum = schema.maximum().replaceAll(",", "");
            return new BigDecimal(filteredMaximum);
        }
        return null;
    }

    protected Boolean resolveExclusiveMinimum(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.exclusiveMinimum()) {
            return schema.exclusiveMinimum();
        }
        return null;
    }

    protected Boolean resolveExclusiveMaximum(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.exclusiveMaximum()) {
            return schema.exclusiveMaximum();
        }
        return null;
    }

    protected String resolvePattern(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && StringUtils.isNotBlank((CharSequence)schema.pattern())) {
            return schema.pattern();
        }
        return null;
    }

    protected Integer resolveMinProperties(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.minProperties() > 0) {
            return schema.minProperties();
        }
        return null;
    }

    protected Integer resolveMaxProperties(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.maxProperties() > 0) {
            return schema.maxProperties();
        }
        return null;
    }

    protected List<String> resolveRequiredProperties(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.requiredProperties() != null && schema.requiredProperties().length > 0 && StringUtils.isNotBlank((CharSequence)schema.requiredProperties()[0])) {
            return Arrays.asList(schema.requiredProperties());
        }
        return null;
    }

    protected Boolean resolveWriteOnly(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.accessMode().equals((Object)Schema.AccessMode.READ_ONLY)) {
            return null;
        }
        if (schema != null && schema.accessMode().equals((Object)Schema.AccessMode.WRITE_ONLY)) {
            return true;
        }
        if (schema != null && schema.accessMode().equals((Object)Schema.AccessMode.READ_WRITE)) {
            return null;
        }
        if (schema != null && schema.writeOnly()) {
            return schema.writeOnly();
        }
        return null;
    }

    protected ExternalDocumentation resolveExternalDocumentation(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        io.swagger.v3.oas.annotations.ExternalDocumentation externalDocumentation = (io.swagger.v3.oas.annotations.ExternalDocumentation)a.getAnnotation(io.swagger.v3.oas.annotations.ExternalDocumentation.class);
        ExternalDocumentation external = this.resolveExternalDocumentation(externalDocumentation);
        if (external == null && schema != null) {
            external = this.resolveExternalDocumentation(schema.externalDocs());
        }
        return external;
    }

    protected ExternalDocumentation resolveExternalDocumentation(io.swagger.v3.oas.annotations.ExternalDocumentation externalDocumentation) {
        if (externalDocumentation == null) {
            return null;
        }
        boolean isEmpty = true;
        ExternalDocumentation external = new ExternalDocumentation();
        if (StringUtils.isNotBlank((CharSequence)externalDocumentation.description())) {
            isEmpty = false;
            external.setDescription(externalDocumentation.description());
        }
        if (StringUtils.isNotBlank((CharSequence)externalDocumentation.url())) {
            isEmpty = false;
            external.setUrl(externalDocumentation.url());
        }
        if (isEmpty) {
            return null;
        }
        return external;
    }

    protected Boolean resolveDeprecated(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.deprecated()) {
            return schema.deprecated();
        }
        return null;
    }

    protected List<String> resolveAllowableValues(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.allowableValues() != null && schema.allowableValues().length > 0) {
            return Arrays.asList(schema.allowableValues());
        }
        return null;
    }

    protected Map<String, Object> resolveExtensions(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        if (schema != null && schema.extensions() != null && schema.extensions().length > 0) {
            return AnnotationsUtils.getExtensions(schema.extensions());
        }
        return null;
    }

    protected Discriminator resolveDiscriminator(JavaType type, ModelConverterContext context) {
        JsonTypeInfo typeInfo;
        String disc;
        io.swagger.v3.oas.annotations.media.Schema declaredSchemaAnnotation = AnnotationsUtils.getSchemaDeclaredAnnotation(type.getRawClass());
        String string = disc = declaredSchemaAnnotation == null ? "" : declaredSchemaAnnotation.discriminatorProperty();
        if (disc.isEmpty() && (typeInfo = type.getRawClass().getDeclaredAnnotation(JsonTypeInfo.class)) != null) {
            disc = typeInfo.property();
        }
        if (!disc.isEmpty()) {
            DiscriminatorMapping[] mappings;
            Discriminator discriminator = new Discriminator().propertyName(disc);
            if (declaredSchemaAnnotation != null && (mappings = declaredSchemaAnnotation.discriminatorMapping()) != null && mappings.length > 0) {
                for (DiscriminatorMapping mapping : mappings) {
                    if (mapping.value().isEmpty() || mapping.schema().equals(Void.class)) continue;
                    discriminator.mapping(mapping.value(), RefUtils.constructRef(context.resolve(new AnnotatedType().type(mapping.schema())).getName()));
                }
            }
            return discriminator;
        }
        return null;
    }

    protected XML resolveXml(Annotated a, Annotation[] annotations, io.swagger.v3.oas.annotations.media.Schema schema) {
        XmlRootElement rootAnnotation = (XmlRootElement)a.getAnnotation(XmlRootElement.class);
        if (rootAnnotation == null && annotations != null) {
            for (Annotation ann : annotations) {
                if (!(ann instanceof XmlRootElement)) continue;
                rootAnnotation = (XmlRootElement)ann;
                break;
            }
        }
        if (rootAnnotation != null && !"".equals(rootAnnotation.name()) && !"##default".equals(rootAnnotation.name())) {
            XML xml = new XML().name(rootAnnotation.name());
            if (rootAnnotation.namespace() != null && !"".equals(rootAnnotation.namespace()) && !"##default".equals(rootAnnotation.namespace())) {
                xml.namespace(rootAnnotation.namespace());
            }
            return xml;
        }
        return null;
    }

    protected Integer resolveMinItems(AnnotatedType a, io.swagger.v3.oas.annotations.media.ArraySchema arraySchema) {
        if (arraySchema != null && arraySchema.minItems() < Integer.MAX_VALUE) {
            return arraySchema.minItems();
        }
        return null;
    }

    protected Integer resolveMaxItems(AnnotatedType a, io.swagger.v3.oas.annotations.media.ArraySchema arraySchema) {
        if (arraySchema != null && arraySchema.maxItems() > 0) {
            return arraySchema.maxItems();
        }
        return null;
    }

    protected Boolean resolveUniqueItems(AnnotatedType a, io.swagger.v3.oas.annotations.media.ArraySchema arraySchema) {
        if (arraySchema != null && arraySchema.uniqueItems()) {
            return arraySchema.uniqueItems();
        }
        return null;
    }

    protected Map<String, Object> resolveExtensions(AnnotatedType a, io.swagger.v3.oas.annotations.media.ArraySchema arraySchema) {
        if (arraySchema != null && arraySchema.extensions() != null && arraySchema.extensions().length > 0) {
            return AnnotationsUtils.getExtensions(arraySchema.extensions());
        }
        return null;
    }

    protected void resolveSchemaMembers(Schema schema, AnnotatedType annotatedType) {
        Map<String, Object> extensions;
        List<String> allowableValues;
        Boolean deprecated;
        ExternalDocumentation externalDocs;
        Boolean writeOnly;
        List<String> requiredProperties;
        Integer maxProperties;
        Integer minProperties;
        String pattern;
        Boolean exclusiveMaximum;
        Boolean exclusiveMinimum;
        BigDecimal maximum;
        BigDecimal minimum;
        Integer minLength;
        Integer maxLength;
        BigDecimal multipleOf;
        Boolean nullable;
        Boolean readOnly;
        Object example;
        String defaultValue;
        String format;
        String title;
        Annotation[] annotations;
        JavaType type = annotatedType.getType() instanceof JavaType ? (JavaType)annotatedType.getType() : this._mapper.constructType(annotatedType.getType());
        Annotation resolvedSchemaOrArrayAnnotation = AnnotationsUtils.mergeSchemaAnnotations(annotatedType.getCtxAnnotations(), type);
        io.swagger.v3.oas.annotations.media.Schema schemaAnnotation = resolvedSchemaOrArrayAnnotation == null ? null : (resolvedSchemaOrArrayAnnotation instanceof io.swagger.v3.oas.annotations.media.ArraySchema ? ((io.swagger.v3.oas.annotations.media.ArraySchema)resolvedSchemaOrArrayAnnotation).schema() : (io.swagger.v3.oas.annotations.media.Schema)resolvedSchemaOrArrayAnnotation);
        BeanDescription beanDesc = this._mapper.getSerializationConfig().introspect(type);
        AnnotatedClass a = beanDesc.getClassInfo();
        String description = this.resolveDescription((Annotated)a, annotations = annotatedType.getCtxAnnotations(), schemaAnnotation);
        if (StringUtils.isNotBlank((CharSequence)description)) {
            schema.description(description);
        }
        if (StringUtils.isNotBlank((CharSequence)(title = this.resolveTitle((Annotated)a, annotations, schemaAnnotation)))) {
            schema.title(title);
        }
        if (StringUtils.isNotBlank((CharSequence)(format = this.resolveFormat((Annotated)a, annotations, schemaAnnotation))) && StringUtils.isBlank((CharSequence)schema.getFormat())) {
            schema.format(format);
        }
        if (StringUtils.isNotBlank((CharSequence)(defaultValue = this.resolveDefaultValue((Annotated)a, annotations, schemaAnnotation)))) {
            schema.setDefault((Object)defaultValue);
        }
        if ((example = this.resolveExample((Annotated)a, annotations, schemaAnnotation)) != null) {
            schema.example(example);
        }
        if ((readOnly = this.resolveReadOnly((Annotated)a, annotations, schemaAnnotation)) != null) {
            schema.readOnly(readOnly);
        }
        if ((nullable = this.resolveNullable((Annotated)a, annotations, schemaAnnotation)) != null) {
            schema.nullable(nullable);
        }
        if ((multipleOf = this.resolveMultipleOf((Annotated)a, annotations, schemaAnnotation)) != null) {
            schema.multipleOf(multipleOf);
        }
        if ((maxLength = this.resolveMaxLength((Annotated)a, annotations, schemaAnnotation)) != null) {
            schema.maxLength(maxLength);
        }
        if ((minLength = this.resolveMinLength((Annotated)a, annotations, schemaAnnotation)) != null) {
            schema.minLength(minLength);
        }
        if ((minimum = this.resolveMinimum((Annotated)a, annotations, schemaAnnotation)) != null) {
            schema.minimum(minimum);
        }
        if ((maximum = this.resolveMaximum((Annotated)a, annotations, schemaAnnotation)) != null) {
            schema.maximum(maximum);
        }
        if ((exclusiveMinimum = this.resolveExclusiveMinimum((Annotated)a, annotations, schemaAnnotation)) != null) {
            schema.exclusiveMinimum(exclusiveMinimum);
        }
        if ((exclusiveMaximum = this.resolveExclusiveMaximum((Annotated)a, annotations, schemaAnnotation)) != null) {
            schema.exclusiveMaximum(exclusiveMaximum);
        }
        if (StringUtils.isNotBlank((CharSequence)(pattern = this.resolvePattern((Annotated)a, annotations, schemaAnnotation)))) {
            schema.pattern(pattern);
        }
        if ((minProperties = this.resolveMinProperties((Annotated)a, annotations, schemaAnnotation)) != null) {
            schema.minProperties(minProperties);
        }
        if ((maxProperties = this.resolveMaxProperties((Annotated)a, annotations, schemaAnnotation)) != null) {
            schema.maxProperties(maxProperties);
        }
        if ((requiredProperties = this.resolveRequiredProperties((Annotated)a, annotations, schemaAnnotation)) != null) {
            for (String prop : requiredProperties) {
                this.addRequiredItem(schema, prop);
            }
        }
        if ((writeOnly = this.resolveWriteOnly((Annotated)a, annotations, schemaAnnotation)) != null) {
            schema.writeOnly(writeOnly);
        }
        if ((externalDocs = this.resolveExternalDocumentation((Annotated)a, annotations, schemaAnnotation)) != null) {
            schema.externalDocs(externalDocs);
        }
        if ((deprecated = this.resolveDeprecated((Annotated)a, annotations, schemaAnnotation)) != null) {
            schema.deprecated(deprecated);
        }
        if ((allowableValues = this.resolveAllowableValues((Annotated)a, annotations, schemaAnnotation)) != null) {
            for (String prop : allowableValues) {
                schema.addEnumItemObject((Object)prop);
            }
        }
        if ((extensions = this.resolveExtensions((Annotated)a, annotations, schemaAnnotation)) != null) {
            for (String ext : extensions.keySet()) {
                schema.addExtension(ext, extensions.get(ext));
            }
        }
    }

    private void addRequiredItem(Schema model, String propName) {
        if (model == null || propName == null || StringUtils.isBlank((CharSequence)propName)) {
            return;
        }
        if (model.getRequired() == null || model.getRequired().isEmpty()) {
            model.addRequiredItem(propName);
        }
        if (model.getRequired().stream().noneMatch(s -> propName.equals(s))) {
            model.addRequiredItem(propName);
        }
    }

    protected boolean shouldIgnoreClass(Type type) {
        if (type instanceof Class) {
            Class cls = (Class)type;
            if (cls.getName().equals("javax.ws.rs.Response")) {
                return true;
            }
        } else if (type instanceof ResolvedType) {
            ResolvedType rt = (ResolvedType)type;
            this.LOGGER.trace("Can't check class {}, {}", (Object)type, (Object)rt.getRawClass().getName());
            if (rt.getRawClass().equals(Class.class)) {
                return true;
            }
        }
        return false;
    }

    private List<String> getIgnoredProperties(BeanDescription beanDescription) {
        AnnotationIntrospector introspector = this._mapper.getSerializationConfig().getAnnotationIntrospector();
        String[] ignored = introspector.findPropertiesToIgnore((Annotated)beanDescription.getClassInfo(), true);
        return ignored == null ? Collections.emptyList() : Arrays.asList(ignored);
    }

    private String decorateModelName(AnnotatedType type, String originalName) {
        if (StringUtils.isBlank((CharSequence)originalName)) {
            return originalName;
        }
        String name = originalName;
        if (type.getJsonViewAnnotation() != null && type.getJsonViewAnnotation().value().length > 0) {
            String COMBINER = "-or-";
            StringBuffer sb = new StringBuffer();
            for (Class view : type.getJsonViewAnnotation().value()) {
                sb.append(view.getSimpleName()).append(COMBINER);
            }
            String suffix = sb.toString().substring(0, sb.length() - COMBINER.length());
            name = originalName + "_" + suffix;
        }
        return name;
    }

    private boolean hiddenByJsonView(Annotation[] annotations, AnnotatedType type) {
        JsonView jsonView = type.getJsonViewAnnotation();
        if (jsonView == null) {
            return false;
        }
        Class[] filters = jsonView.value();
        boolean containsJsonViewAnnotation = false;
        for (Annotation ant : annotations) {
            if (!(ant instanceof JsonView)) continue;
            containsJsonViewAnnotation = true;
            Class[] views = ((JsonView)ant).value();
            for (Class f : filters) {
                for (Class v : views) {
                    if (v != f && !v.isAssignableFrom(f)) continue;
                    return false;
                }
            }
        }
        return containsJsonViewAnnotation;
    }

    private static enum GeneratorWrapper {
        PROPERTY(ObjectIdGenerators.PropertyGenerator.class){

            @Override
            protected Schema processAsProperty(String propertyName, AnnotatedType type, ModelConverterContext context, ObjectMapper mapper) {
                return null;
            }

            @Override
            protected Schema processAsId(String propertyName, AnnotatedType type, ModelConverterContext context, ObjectMapper mapper) {
                JavaType javaType = type.getType() instanceof JavaType ? (JavaType)type.getType() : mapper.constructType(type.getType());
                BeanDescription beanDesc = mapper.getSerializationConfig().introspect(javaType);
                for (BeanPropertyDefinition def : beanDesc.findProperties()) {
                    String name = def.getName();
                    if (name == null || !name.equals(propertyName)) continue;
                    AnnotatedMember propMember = def.getPrimaryMember();
                    JavaType propType = propMember.getType();
                    if (PrimitiveType.fromType((Type)propType) != null) {
                        return PrimitiveType.createProperty((Type)propType);
                    }
                    ArrayList<Annotation> list = new ArrayList<Annotation>();
                    for (Annotation a : propMember.annotations()) {
                        list.add(a);
                    }
                    Annotation[] annotations = list.toArray(new Annotation[list.size()]);
                    Annotation propSchemaOrArray = AnnotationsUtils.mergeSchemaAnnotations(annotations, propType);
                    AnnotatedType aType = new AnnotatedType().type((Type)propType).ctxAnnotations(annotations).jsonViewAnnotation(type.getJsonViewAnnotation()).schemaProperty(true);
                    return context.resolve(aType);
                }
                return null;
            }
        }
        ,
        INT(ObjectIdGenerators.IntSequenceGenerator.class){

            @Override
            protected Schema processAsProperty(String propertyName, AnnotatedType type, ModelConverterContext context, ObjectMapper mapper) {
                IntegerSchema id = new IntegerSchema();
                return GeneratorWrapper.process((Schema)id, propertyName, type, context);
            }

            @Override
            protected Schema processAsId(String propertyName, AnnotatedType type, ModelConverterContext context, ObjectMapper mapper) {
                return new IntegerSchema();
            }
        }
        ,
        UUID(ObjectIdGenerators.UUIDGenerator.class){

            @Override
            protected Schema processAsProperty(String propertyName, AnnotatedType type, ModelConverterContext context, ObjectMapper mapper) {
                UUIDSchema id = new UUIDSchema();
                return GeneratorWrapper.process((Schema)id, propertyName, type, context);
            }

            @Override
            protected Schema processAsId(String propertyName, AnnotatedType type, ModelConverterContext context, ObjectMapper mapper) {
                return new UUIDSchema();
            }
        }
        ,
        NONE(ObjectIdGenerators.None.class){

            @Override
            protected Schema processAsProperty(String propertyName, AnnotatedType type, ModelConverterContext context, ObjectMapper mapper) {
                return null;
            }

            @Override
            protected Schema processAsId(String propertyName, AnnotatedType type, ModelConverterContext context, ObjectMapper mapper) {
                return null;
            }
        };

        private final Class<? extends ObjectIdGenerator> generator;

        private GeneratorWrapper(Class<? extends ObjectIdGenerator> generator) {
            this.generator = generator;
        }

        protected abstract Schema processAsProperty(String var1, AnnotatedType var2, ModelConverterContext var3, ObjectMapper var4);

        protected abstract Schema processAsId(String var1, AnnotatedType var2, ModelConverterContext var3, ObjectMapper var4);

        public static Schema processJsonIdentity(AnnotatedType type, ModelConverterContext context, ObjectMapper mapper, JsonIdentityInfo identityInfo, JsonIdentityReference identityReference) {
            GeneratorWrapper wrapper;
            GeneratorWrapper generatorWrapper = wrapper = identityInfo != null ? GeneratorWrapper.getWrapper(identityInfo.generator()) : null;
            if (wrapper == null) {
                return null;
            }
            if (identityReference != null && identityReference.alwaysAsId()) {
                return wrapper.processAsId(identityInfo.property(), type, context, mapper);
            }
            return wrapper.processAsProperty(identityInfo.property(), type, context, mapper);
        }

        private static GeneratorWrapper getWrapper(Class<?> generator) {
            for (GeneratorWrapper value : GeneratorWrapper.values()) {
                if (!value.generator.isAssignableFrom(generator)) continue;
                return value;
            }
            return null;
        }

        private static Schema process(Schema id, String propertyName, AnnotatedType type, ModelConverterContext context) {
            Schema model;
            Schema mi = model = context.resolve(GeneratorWrapper.removeJsonIdentityAnnotations(type));
            mi.addProperties(propertyName, id);
            return new Schema().$ref(StringUtils.isNotEmpty((CharSequence)mi.get$ref()) ? mi.get$ref() : mi.getName());
        }

        private static AnnotatedType removeJsonIdentityAnnotations(AnnotatedType type) {
            return new AnnotatedType().jsonUnwrappedHandler(type.getJsonUnwrappedHandler()).jsonViewAnnotation(type.getJsonViewAnnotation()).name(type.getName()).parent(type.getParent()).resolveAsRef(false).schemaProperty(type.isSchemaProperty()).skipOverride(type.isSkipOverride()).skipSchemaName(type.isSkipSchemaName()).type(type.getType()).skipJsonIdentity(true).ctxAnnotations(AnnotationsUtils.removeAnnotations(type.getCtxAnnotations(), JsonIdentityInfo.class, JsonIdentityReference.class));
        }
    }
}

