/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.model.base;

import io.jans.orm.annotation.AttributeName;
import io.jans.orm.annotation.AttributesList;
import io.jans.orm.annotation.CustomObjectClass;
import io.jans.orm.annotation.DN;
import io.jans.orm.annotation.DataEntry;
import io.jans.orm.annotation.ObjectClass;
import io.jans.orm.model.base.CustomObjectAttribute;
import io.jans.orm.util.StringHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@DataEntry
@ObjectClass
public class SimpleUser
implements Serializable {
    private static final long serialVersionUID = -1634191420188575733L;
    @DN
    private String dn;
    @AttributeName(name="uid", consistency=true)
    private String userId;
    @AttributeName
    private Date updatedAt;
    @AttributeName(name="jansCreationTimestamp")
    private Date createdAt;
    @AttributeName(name="jansPersistentJWT")
    private String[] oxAuthPersistentJwt;
    @AttributesList(name="name", value="values", multiValued="multiValued", sortByName=true)
    protected List<CustomObjectAttribute> customAttributes = new ArrayList<CustomObjectAttribute>();
    @CustomObjectClass
    private String[] customObjectClasses;

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String[] getOxAuthPersistentJwt() {
        return this.oxAuthPersistentJwt;
    }

    public void setOxAuthPersistentJwt(String[] oxAuthPersistentJwt) {
        this.oxAuthPersistentJwt = oxAuthPersistentJwt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public List<CustomObjectAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<CustomObjectAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public String getAttribute(String attributeName) {
        Object objectAttribute = this.getAttributeObject(attributeName);
        return StringHelper.toString((Object)objectAttribute);
    }

    public Object getAttributeObject(String attributeName) {
        Object attribute = null;
        if (attributeName != null && !attributeName.isEmpty()) {
            for (CustomObjectAttribute customAttribute : this.customAttributes) {
                if (!customAttribute.getName().equals(attributeName)) continue;
                attribute = customAttribute.getValue();
                break;
            }
        }
        return attribute;
    }

    public List<String> getAttributeValues(String attributeName) {
        List<Object> objectValues = this.getAttributeObjectValues(attributeName);
        if (objectValues == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>(objectValues.size());
        for (Object objectValue : objectValues) {
            values.add(StringHelper.toString((Object)objectValue));
        }
        return values;
    }

    public List<Object> getAttributeObjectValues(String attributeName) {
        List<Object> values = null;
        if (attributeName != null && !attributeName.isEmpty()) {
            for (CustomObjectAttribute customAttribute : this.customAttributes) {
                if (!StringHelper.equalsIgnoreCase((String)customAttribute.getName(), (String)attributeName)) continue;
                values = customAttribute.getValues();
                break;
            }
        }
        return values;
    }

    public String[] getCustomObjectClasses() {
        return this.customObjectClasses;
    }

    public void setCustomObjectClasses(String[] customObjectClasses) {
        this.customObjectClasses = customObjectClasses;
    }
}

