/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.ldap.operation.impl;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.FailoverServerSet;
import com.unboundid.ldap.sdk.GetEntryLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import io.jans.orm.exception.operation.ConfigurationException;
import io.jans.orm.operation.auth.PasswordEncryptionMethod;
import io.jans.orm.util.ArrayHelper;
import io.jans.orm.util.StringHelper;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LdapConnectionProvider.class);
    private static final int DEFAULT_SUPPORTED_LDAP_VERSION = 2;
    private static final String DEFAULT_SUBSCHEMA_SUBENTRY = "cn=schema";
    private static final String[] SSL_PROTOCOLS = new String[]{"TLSv1.2", "TLSv1.1", "TLSv1", "SSLv3"};
    private LDAPConnectionPool connectionPool;
    private ResultCode creationResultCode;
    private int supportedLDAPVersion = 2;
    private String subschemaSubentry = "cn=schema";
    private String[] servers;
    private String[] addresses;
    private int[] ports;
    private String bindDn;
    private String bindPassword;
    private boolean useSSL;
    private ArrayList<PasswordEncryptionMethod> additionalPasswordMethods;
    private ArrayList<String> binaryAttributes;
    private ArrayList<String> certificateAttributes;
    private boolean supportsSubtreeDeleteRequestControl;

    protected LdapConnectionProvider() {
    }

    public LdapConnectionProvider(Properties props) {
        this.create(props);
    }

    protected void create(Properties props) {
        try {
            this.init(props);
        }
        catch (LDAPException ex) {
            this.creationResultCode = ex.getResultCode();
            Properties clonedProperties = (Properties)props.clone();
            if (clonedProperties.getProperty("bindPassword") != null) {
                clonedProperties.setProperty("bindPassword", "REDACTED");
            }
            LOG.error("Failed to create connection pool with properties: " + clonedProperties, (Throwable)ex);
        }
        catch (Exception ex) {
            Properties clonedProperties = (Properties)props.clone();
            if (clonedProperties.getProperty("bindPassword") != null) {
                clonedProperties.setProperty("bindPassword", "REDACTED");
            }
            LOG.error("Failed to create connection pool with properties: " + clonedProperties, (Throwable)ex);
        }
    }

    protected void init(Properties props) throws NumberFormatException, LDAPException, GeneralSecurityException {
        String[] binaryAttrs;
        FailoverServerSet failoverSet;
        String serverProp = props.getProperty("servers");
        this.servers = serverProp.split(",");
        this.addresses = new String[this.servers.length];
        this.ports = new int[this.servers.length];
        for (int i = 0; i < this.servers.length; ++i) {
            String str = this.servers[i];
            int idx = str.indexOf(":");
            if (idx == -1) {
                throw new ConfigurationException("Ldap server settings should be in format server:port");
            }
            this.addresses[i] = str.substring(0, idx).trim();
            this.ports[i] = Integer.parseInt(str.substring(str.indexOf(":") + 1, str.length()));
        }
        SimpleBindRequest bindRequest = null;
        if (StringHelper.isEmpty((String)props.getProperty("bindDN"))) {
            this.bindDn = null;
            this.bindPassword = null;
            bindRequest = new SimpleBindRequest();
        } else {
            this.bindDn = props.getProperty("bindDN");
            this.bindPassword = props.getProperty("bindPassword");
            bindRequest = new SimpleBindRequest(this.bindDn, this.bindPassword);
        }
        LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
        connectionOptions.setConnectTimeoutMillis(100000);
        connectionOptions.setAutoReconnect(true);
        this.useSSL = Boolean.valueOf(props.getProperty("useSSL"));
        SSLUtil sslUtil = null;
        if (this.useSSL) {
            String sslTrustStoreFile = props.getProperty("ssl.trustStoreFile");
            String sslTrustStorePin = props.getProperty("ssl.trustStorePin");
            String sslTrustStoreFormat = props.getProperty("ssl.trustStoreFormat");
            if (StringHelper.isEmpty((String)sslTrustStoreFile) && StringHelper.isEmpty((String)sslTrustStorePin)) {
                sslUtil = new SSLUtil((TrustManager)new TrustAllTrustManager());
            } else {
                TrustStoreTrustManager trustStoreTrustManager = new TrustStoreTrustManager(sslTrustStoreFile, sslTrustStorePin.toCharArray(), sslTrustStoreFormat, true);
                sslUtil = new SSLUtil((TrustManager)trustStoreTrustManager);
            }
            failoverSet = new FailoverServerSet(this.addresses, this.ports, (SocketFactory)sslUtil.createSSLSocketFactory(SSL_PROTOCOLS[0]), connectionOptions);
        } else {
            failoverSet = new FailoverServerSet(this.addresses, this.ports, connectionOptions);
        }
        int maxConnections = StringHelper.toInt((String)props.getProperty("maxconnections"), (int)10);
        this.connectionPool = this.createConnectionPoolWithWaitImpl(props, failoverSet, (BindRequest)bindRequest, connectionOptions, maxConnections, sslUtil);
        if (this.connectionPool != null) {
            boolean backgroundHealthCheckEnabled;
            this.connectionPool.setCreateIfNecessary(true);
            String connectionMaxWaitTime = props.getProperty("connection.max-wait-time-millis");
            if (StringHelper.isNotEmpty((String)connectionMaxWaitTime)) {
                this.connectionPool.setMaxWaitTimeMillis(Long.parseLong(connectionMaxWaitTime));
            }
            String maxConnectionAge = props.getProperty("connection.max-age-time-millis");
            if (StringHelper.isNotEmpty((String)connectionMaxWaitTime)) {
                this.connectionPool.setMaxConnectionAgeMillis(Long.parseLong(maxConnectionAge));
            }
            boolean onCheckoutHealthCheckEnabled = StringHelper.toBoolean((String)props.getProperty("connection-pool.health-check.on-checkout.enabled"), (boolean)false);
            long healthCheckIntervalMillis = StringHelper.toLong((String)props.getProperty("connection-pool.health-check.interval-millis"), (int)0);
            long healthCheckMaxResponsetimeMillis = StringHelper.toLong((String)props.getProperty("connection-pool.health-check.max-response-time-millis"), (int)0);
            boolean bl = backgroundHealthCheckEnabled = !onCheckoutHealthCheckEnabled && healthCheckIntervalMillis > 0L;
            if (backgroundHealthCheckEnabled) {
                this.connectionPool.setHealthCheckIntervalMillis(healthCheckIntervalMillis);
            }
            if (onCheckoutHealthCheckEnabled || backgroundHealthCheckEnabled) {
                GetEntryLDAPConnectionPoolHealthCheck healthChecker = new GetEntryLDAPConnectionPoolHealthCheck(null, healthCheckMaxResponsetimeMillis, false, onCheckoutHealthCheckEnabled, false, backgroundHealthCheckEnabled, false);
                this.connectionPool.setHealthCheck((LDAPConnectionPoolHealthCheck)healthChecker);
            }
        }
        this.additionalPasswordMethods = new ArrayList();
        if (props.containsKey("additionalPasswordMethods")) {
            String[] additionalPasswordMethodsArray;
            for (String additionalPasswordMethod : additionalPasswordMethodsArray = StringHelper.split((String)props.get("additionalPasswordMethods").toString(), (String)",")) {
                PasswordEncryptionMethod passwordEncryptionMethod = PasswordEncryptionMethod.getMethod((String)additionalPasswordMethod);
                if (passwordEncryptionMethod == null) continue;
                this.additionalPasswordMethods.add(passwordEncryptionMethod);
            }
        }
        LOG.debug("Adding support for password methods: " + this.additionalPasswordMethods);
        this.binaryAttributes = new ArrayList();
        if (props.containsKey("binaryAttributes")) {
            binaryAttrs = StringHelper.split((String)props.get("binaryAttributes").toString().toLowerCase(), (String)",");
            this.binaryAttributes.addAll(Arrays.asList(binaryAttrs));
        }
        LOG.debug("Using next binary attributes: " + this.binaryAttributes);
        this.certificateAttributes = new ArrayList();
        if (props.containsKey("certificateAttributes")) {
            binaryAttrs = StringHelper.split((String)props.get("certificateAttributes").toString().toLowerCase(), (String)",");
            this.certificateAttributes.addAll(Arrays.asList(binaryAttrs));
        }
        LOG.debug("Using next binary certificateAttributes: " + this.certificateAttributes);
        this.supportedLDAPVersion = this.determineSupportedLdapVersion();
        this.subschemaSubentry = this.determineSubschemaSubentry();
        this.supportsSubtreeDeleteRequestControl = this.supportsSubtreeDeleteRequestControl();
        this.creationResultCode = ResultCode.SUCCESS;
    }

    private LDAPConnectionPool createConnectionPoolWithWaitImpl(Properties props, FailoverServerSet failoverSet, BindRequest bindRequest, LDAPConnectionOptions connectionOptions, int maxConnections, SSLUtil sslUtil) throws LDAPException {
        int connectionPoolMaxWaitTimeSeconds = StringHelper.toInt((String)props.getProperty("connection-pool-max-wait-time"), (int)30);
        LOG.debug("Using LDAP connection pool timeout: '" + connectionPoolMaxWaitTimeSeconds + "'");
        LDAPConnectionPool createdConnectionPool = null;
        LDAPException lastException = null;
        int attempt = 0;
        long currentTime = System.currentTimeMillis();
        long maxWaitTime = currentTime + (long)(connectionPoolMaxWaitTimeSeconds * 1000);
        while (true) {
            if (++attempt > 0) {
                LOG.info("Attempting to create connection pool: " + attempt);
            }
            try {
                createdConnectionPool = this.createConnectionPoolImpl(failoverSet, bindRequest, connectionOptions, maxConnections, sslUtil);
            }
            catch (LDAPException ex) {
                if (ex.getResultCode().intValue() != 91) {
                    throw ex;
                }
                lastException = ex;
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException ex2) {
                    LOG.error("Exception happened in sleep", (Throwable)ex2);
                    return null;
                }
                if (maxWaitTime > (currentTime = System.currentTimeMillis())) continue;
            }
            break;
        }
        if (createdConnectionPool == null && lastException != null) {
            throw lastException;
        }
        return createdConnectionPool;
    }

    private LDAPConnectionPool createConnectionPoolImpl(FailoverServerSet failoverSet, BindRequest bindRequest, LDAPConnectionOptions connectionOptions, int maxConnections, SSLUtil sslUtil) throws LDAPException {
        LDAPConnectionPool createdConnectionPool;
        block4: {
            try {
                createdConnectionPool = new LDAPConnectionPool((ServerSet)failoverSet, bindRequest, maxConnections);
            }
            catch (LDAPException ex) {
                if (!this.useSSL) {
                    throw ex;
                }
                if (ex.getResultCode() != ResultCode.SERVER_DOWN) {
                    throw ex;
                }
                LOG.info("Attempting to use older SSL protocols", (Throwable)ex);
                createdConnectionPool = this.createSSLConnectionPoolWithPreviousProtocols(sslUtil, bindRequest, connectionOptions, maxConnections);
                if (createdConnectionPool != null) break block4;
                throw ex;
            }
        }
        return createdConnectionPool;
    }

    private LDAPConnectionPool createSSLConnectionPoolWithPreviousProtocols(SSLUtil sslUtil, BindRequest bindRequest, LDAPConnectionOptions connectionOptions, int maxConnections) throws LDAPException {
        for (int i = 1; i < SSL_PROTOCOLS.length; ++i) {
            String protocol = SSL_PROTOCOLS[i];
            try {
                FailoverServerSet failoverSet = new FailoverServerSet(this.addresses, this.ports, (SocketFactory)sslUtil.createSSLSocketFactory(protocol), connectionOptions);
                LDAPConnectionPool connectionPool = new LDAPConnectionPool((ServerSet)failoverSet, bindRequest, maxConnections);
                LOG.info("Server supports: '" + protocol + "'");
                return connectionPool;
            }
            catch (GeneralSecurityException ex) {
                LOG.debug("Server not supports: '" + protocol + "'", (Throwable)ex);
                continue;
            }
            catch (LDAPException ex) {
                if (ex.getResultCode() != ResultCode.SERVER_DOWN) {
                    throw ex;
                }
                LOG.debug("Server not supports: '" + protocol + "'", (Throwable)ex);
            }
        }
        return null;
    }

    private int determineSupportedLdapVersion() {
        int resultSupportedLDAPVersion = 2;
        boolean validConnection = this.isValidConnection();
        if (!validConnection) {
            return resultSupportedLDAPVersion;
        }
        try {
            Object[] supportedLDAPVersions = this.connectionPool.getRootDSE().getAttributeValues("supportedLDAPVersion");
            if (ArrayHelper.isEmpty((Object[])supportedLDAPVersions)) {
                return resultSupportedLDAPVersion;
            }
            for (Object supportedLDAPVersion : supportedLDAPVersions) {
                resultSupportedLDAPVersion = Math.max(resultSupportedLDAPVersion, Integer.parseInt((String)supportedLDAPVersion));
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to determine supportedLDAPVersion", (Throwable)ex);
        }
        return resultSupportedLDAPVersion;
    }

    private String determineSubschemaSubentry() {
        String resultSubschemaSubentry = DEFAULT_SUBSCHEMA_SUBENTRY;
        boolean validConnection = this.isValidConnection();
        if (!validConnection) {
            return resultSubschemaSubentry;
        }
        try {
            String subschemaSubentry = this.connectionPool.getRootDSE().getAttributeValue("subschemaSubentry");
            if (StringHelper.isEmpty((String)subschemaSubentry)) {
                return resultSubschemaSubentry;
            }
            resultSubschemaSubentry = subschemaSubentry;
        }
        catch (Exception ex) {
            LOG.error("Failed to determine subschemaSubentry", (Throwable)ex);
        }
        return resultSubschemaSubentry;
    }

    private boolean supportsSubtreeDeleteRequestControl() {
        boolean supportsSubtreeDeleteRequestControl = false;
        boolean validConnection = this.isValidConnection();
        if (!validConnection) {
            return supportsSubtreeDeleteRequestControl;
        }
        try {
            supportsSubtreeDeleteRequestControl = this.connectionPool.getRootDSE().supportsControl("1.2.840.113556.1.4.805");
        }
        catch (Exception ex) {
            LOG.error("Failed to determine if LDAP server supports Subtree Delete Request Control", (Throwable)ex);
        }
        return supportsSubtreeDeleteRequestControl;
    }

    private boolean isValidConnection() {
        if (StringHelper.isEmptyString((Object)this.bindDn) || StringHelper.isEmptyString((Object)this.bindPassword)) {
            return false;
        }
        return this.connectionPool != null;
    }

    public int getSupportedLDAPVersion() {
        return this.supportedLDAPVersion;
    }

    public String getSubschemaSubentry() {
        return this.subschemaSubentry;
    }

    public boolean isSupportsSubtreeDeleteRequestControl() {
        return this.supportsSubtreeDeleteRequestControl;
    }

    public LDAPConnection getConnection() throws LDAPException {
        return this.connectionPool.getConnection();
    }

    public void releaseConnection(LDAPConnection connection) {
        this.connectionPool.releaseConnection(connection);
    }

    public void releaseConnection(LDAPConnection connection, LDAPException ex) {
        this.connectionPool.releaseConnectionAfterException(connection, ex);
    }

    public void closeDefunctConnection(LDAPConnection connection) {
        this.connectionPool.releaseDefunctConnection(connection);
    }

    public LDAPConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public void closeConnectionPool() {
        this.connectionPool.close();
    }

    public boolean isConnected() {
        if (this.connectionPool == null) {
            return false;
        }
        boolean isConnected = false;
        try {
            LDAPConnection connection = this.getConnection();
            try {
                isConnected = connection.isConnected();
            }
            finally {
                this.releaseConnection(connection);
            }
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        return isConnected;
    }

    public ResultCode getCreationResultCode() {
        return this.creationResultCode;
    }

    public void setCreationResultCode(ResultCode creationResultCode) {
        this.creationResultCode = creationResultCode;
    }

    public boolean isCreated() {
        return ResultCode.SUCCESS == this.creationResultCode;
    }

    public String[] getServers() {
        return this.servers;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    public int[] getPorts() {
        return this.ports;
    }

    public String getBindDn() {
        return this.bindDn;
    }

    public String getBindPassword() {
        return this.bindPassword;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public final ArrayList<PasswordEncryptionMethod> getAdditionalPasswordMethods() {
        return this.additionalPasswordMethods;
    }

    public ArrayList<String> getBinaryAttributes() {
        return this.binaryAttributes;
    }

    public ArrayList<String> getCertificateAttributes() {
        return this.certificateAttributes;
    }

    public boolean isBinaryAttribute(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return false;
        }
        return this.binaryAttributes.contains(attributeName.toLowerCase());
    }

    public boolean isCertificateAttribute(String attributeName) {
        String realAttributeName = this.getCertificateAttributeName(attributeName);
        return this.certificateAttributes.contains(realAttributeName.toLowerCase());
    }

    public String getCertificateAttributeName(String attributeName) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return attributeName;
        }
        if (attributeName.endsWith(";binary")) {
            return attributeName.substring(0, attributeName.length() - 7);
        }
        return attributeName;
    }
}

