/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.ldap.impl;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import io.jans.orm.exception.operation.SearchException;
import io.jans.orm.search.filter.FilterType;
import io.jans.orm.util.ArrayHelper;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class LdapFilterConverter {
    public Filter convertToLdapFilter(io.jans.orm.search.filter.Filter genericFilter) throws SearchException {
        FilterType type = genericFilter.getType();
        if (FilterType.RAW == type) {
            try {
                return Filter.create((String)genericFilter.getFilterString());
            }
            catch (LDAPException ex) {
                throw new SearchException("Failed to parse RAW Ldap filter", (Throwable)ex, ex.getResultCode().intValue());
            }
        }
        if (FilterType.NOT == type || FilterType.AND == type || FilterType.OR == type) {
            io.jans.orm.search.filter.Filter[] genericFilters = genericFilter.getFilters();
            Filter[] ldapFilters = new Filter[genericFilters.length];
            if (genericFilters != null) {
                for (int i = 0; i < genericFilters.length; ++i) {
                    ldapFilters[i] = this.convertToLdapFilter(genericFilters[i]);
                }
                if (FilterType.NOT == type) {
                    return Filter.createNOTFilter((Filter)ldapFilters[0]);
                }
                if (FilterType.AND == type) {
                    return Filter.createANDFilter((Filter[])ldapFilters);
                }
                if (FilterType.OR == type) {
                    return Filter.createORFilter((Filter[])ldapFilters);
                }
            }
        }
        if (FilterType.EQUALITY == type) {
            String attributeName = ArrayHelper.isEmpty((Object[])genericFilter.getFilters()) ? genericFilter.getAttributeName() : this.convertToLdapFilter(genericFilter.getFilters()[0]).getAttributeName();
            return Filter.createEqualityFilter((String)attributeName, (String)String.valueOf(genericFilter.getAssertionValue()));
        }
        if (FilterType.LESS_OR_EQUAL == type) {
            return Filter.createLessOrEqualFilter((String)genericFilter.getAttributeName(), (String)String.valueOf(genericFilter.getAssertionValue()));
        }
        if (FilterType.GREATER_OR_EQUAL == type) {
            return Filter.createGreaterOrEqualFilter((String)genericFilter.getAttributeName(), (String)String.valueOf(genericFilter.getAssertionValue()));
        }
        if (FilterType.PRESENCE == type) {
            return Filter.createPresenceFilter((String)genericFilter.getAttributeName());
        }
        if (FilterType.APPROXIMATE_MATCH == type) {
            return Filter.createApproximateMatchFilter((String)genericFilter.getAttributeName(), (String)String.valueOf(genericFilter.getAssertionValue()));
        }
        if (FilterType.SUBSTRING == type) {
            return Filter.createSubstringFilter((String)genericFilter.getAttributeName(), (String)genericFilter.getSubInitial(), (String[])genericFilter.getSubAny(), (String)genericFilter.getSubFinal());
        }
        if (FilterType.LOWERCASE == type) {
            return Filter.createPresenceFilter((String)genericFilter.getAttributeName());
        }
        throw new SearchException(String.format("Unknown filter type '%s'", type), 2);
    }

    public io.jans.orm.search.filter.Filter convertRawLdapFilterToFilter(String rawFilter) throws SearchException {
        Filter ldapFilter;
        try {
            ldapFilter = Filter.create((String)rawFilter);
        }
        catch (LDAPException ex) {
            throw new SearchException("Failed to parse RAW Ldap filter", (Throwable)ex, ex.getResultCode().intValue());
        }
        return this.convertRawLdapFilterToFilterImpl(ldapFilter);
    }

    protected io.jans.orm.search.filter.Filter convertRawLdapFilterToFilterImpl(Filter ldapFilter) throws SearchException {
        byte type = ldapFilter.getFilterType();
        if (-94 == type || -96 == type || -95 == type) {
            Filter[] ldapFilters = ldapFilter.getComponents();
            io.jans.orm.search.filter.Filter[] genericFilters = new io.jans.orm.search.filter.Filter[ldapFilters.length];
            if (ldapFilters != null) {
                for (int i = 0; i < ldapFilters.length; ++i) {
                    genericFilters[i] = this.convertRawLdapFilterToFilterImpl(ldapFilters[i]);
                }
                if (-94 == type) {
                    return io.jans.orm.search.filter.Filter.createNOTFilter((io.jans.orm.search.filter.Filter)genericFilters[0]);
                }
                if (-96 == type) {
                    return io.jans.orm.search.filter.Filter.createANDFilter((io.jans.orm.search.filter.Filter[])genericFilters);
                }
                if (-95 == type) {
                    return io.jans.orm.search.filter.Filter.createORFilter((io.jans.orm.search.filter.Filter[])genericFilters);
                }
            }
        }
        if (-93 == type) {
            return io.jans.orm.search.filter.Filter.createEqualityFilter((String)ldapFilter.getAttributeName(), (Object)ldapFilter.getAssertionValue());
        }
        if (-90 == type) {
            return io.jans.orm.search.filter.Filter.createLessOrEqualFilter((String)ldapFilter.getAttributeName(), (Object)ldapFilter.getAssertionValue());
        }
        if (-91 == type) {
            return io.jans.orm.search.filter.Filter.createGreaterOrEqualFilter((String)ldapFilter.getAttributeName(), (Object)ldapFilter.getAssertionValue());
        }
        if (-121 == type) {
            return io.jans.orm.search.filter.Filter.createPresenceFilter((String)ldapFilter.getAttributeName());
        }
        if (-88 == type) {
            return io.jans.orm.search.filter.Filter.createApproximateMatchFilter((String)ldapFilter.getAttributeName(), (String)ldapFilter.getAssertionValue());
        }
        if (-92 == type) {
            return io.jans.orm.search.filter.Filter.createSubstringFilter((String)ldapFilter.getAttributeName(), (String)ldapFilter.getSubInitialString(), (String[])ldapFilter.getSubAnyStrings(), (String)ldapFilter.getSubFinalString());
        }
        throw new SearchException(String.format("Unknown filter type '%s'", type), 2);
    }
}

