/*
 * Decompiled with CFR 0.152.
 */
package io.jans.orm.ldap.impl;

import io.jans.orm.PersistenceEntryManagerFactory;
import io.jans.orm.exception.operation.ConfigurationException;
import io.jans.orm.ldap.impl.LdapEntryManager;
import io.jans.orm.ldap.operation.impl.LdapAuthConnectionProvider;
import io.jans.orm.ldap.operation.impl.LdapConnectionProvider;
import io.jans.orm.ldap.operation.impl.LdapOperationServiceImpl;
import io.jans.orm.service.BaseFactoryService;
import io.jans.orm.util.PropertiesHelper;
import java.util.HashMap;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class LdapEntryManagerFactory
implements PersistenceEntryManagerFactory {
    public static final String PERSISTENCE_TYPE = "ldap";
    public static final String LDAP_DEFAULT_PROPERTIES_FILE = "jans-ldap.properties";
    private static final Logger LOG = LoggerFactory.getLogger(LdapEntryManagerFactory.class);

    public String getPersistenceType() {
        return PERSISTENCE_TYPE;
    }

    public HashMap<String, String> getConfigurationFileNames() {
        HashMap<String, String> confs = new HashMap<String, String>();
        confs.put(PERSISTENCE_TYPE, LDAP_DEFAULT_PROPERTIES_FILE);
        return confs;
    }

    public LdapEntryManager createEntryManager(Properties conf) {
        Properties entryManagerConf = PropertiesHelper.filterProperties((Properties)conf, (String)PERSISTENCE_TYPE);
        LdapConnectionProvider connectionProvider = new LdapConnectionProvider(entryManagerConf);
        if (!connectionProvider.isCreated()) {
            throw new ConfigurationException(String.format("Failed to create LDAP connection pool! Result code: '%s'", connectionProvider.getCreationResultCode()));
        }
        LOG.debug("Created connectionProvider '{}' with code '{}'", (Object)connectionProvider, (Object)connectionProvider.getCreationResultCode());
        LdapAuthConnectionProvider bindConnectionProvider = new LdapAuthConnectionProvider(entryManagerConf);
        if (!bindConnectionProvider.isCreated()) {
            throw new ConfigurationException(String.format("Failed to create LDAP bind connection pool! Result code: '%s'", bindConnectionProvider.getCreationResultCode()));
        }
        LOG.debug("Created bindConnectionProvider '{}' with code '{}'", (Object)bindConnectionProvider, (Object)bindConnectionProvider.getCreationResultCode());
        LdapEntryManager ldapEntryManager = new LdapEntryManager(new LdapOperationServiceImpl(connectionProvider, bindConnectionProvider));
        LOG.info("Created LdapEntryManager: {}", (Object)ldapEntryManager.getOperationService());
        return ldapEntryManager;
    }

    public void initStandalone(BaseFactoryService persistanceFactoryService) {
    }
}

