/*
 * Decompiled with CFR 0.152.
 */
package io.jans.util;

import io.jans.model.SelectableEntity;
import java.util.ArrayList;
import java.util.List;

public final class SelectableEntityHelper {
    private SelectableEntityHelper() {
    }

    public static <T> List<SelectableEntity<T>> convertToSelectableEntityModel(List<T> entities) {
        ArrayList<SelectableEntity<T>> result = new ArrayList<SelectableEntity<T>>(entities.size());
        for (T entity : entities) {
            result.add(new SelectableEntity<T>(entity, false));
        }
        return result;
    }

    public static <T> List<T> convertToEntities(List<SelectableEntity<T>> selectableEntities) {
        ArrayList<T> result = new ArrayList<T>(selectableEntities.size());
        for (SelectableEntity<T> selectableEntity : selectableEntities) {
            result.add(selectableEntity.getEntity());
        }
        return result;
    }

    public static <T> void select(List<SelectableEntity<T>> selectableEntities, List<T> entities) {
        for (SelectableEntity<T> selectable : selectableEntities) {
            selectable.setSelected(entities.contains(selectable.getEntity()));
        }
    }
}

