/*
 * Decompiled with CFR 0.152.
 */
package io.jans.model;

import io.jans.orm.annotation.AttributeEnum;
import java.util.HashMap;
import java.util.Map;

public enum ScriptLocationType implements AttributeEnum
{
    LDAP("ldap", "Database"),
    FILE("file", "File");

    private String value;
    private String displayName;
    private static Map<String, ScriptLocationType> MAP_BY_VALUES;

    private ScriptLocationType(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static ScriptLocationType getByValue(String value) {
        return MAP_BY_VALUES.get(value);
    }

    public Enum<? extends AttributeEnum> resolveByValue(String value) {
        return ScriptLocationType.getByValue(value);
    }

    public String toString() {
        return this.value;
    }

    static {
        MAP_BY_VALUES = new HashMap<String, ScriptLocationType>();
        for (ScriptLocationType enumType : ScriptLocationType.values()) {
            MAP_BY_VALUES.put(enumType.getValue(), enumType);
        }
    }
}

